/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.awt.RenderingHints;
import java.util.Map;
import org.geotools.factory.FactoryNotFoundException;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.referencing.FactoryFinder;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.feature.display.FeatureDisplayFactory;
import org.opengis.feature.type.TypeFactory;
import org.opengis.filter.FilterFactory;
import org.opengis.go.CommonCapabilities;
import org.opengis.go.CommonFactory;
import org.opengis.go.display.DisplayFactory;
import org.opengis.metadata.citation.CitationFactory;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.sld.FeatureStyleFactory;
import org.opengis.spatialschema.geometry.geometry.GeometryFactory;
import org.opengis.spatialschema.geometry.primitive.PrimitiveFactory;
import org.opengis.util.NameFactory;

public class BasicFactories
implements CommonFactory {
    private static final String DEFAULT_AUTHORITY = "EPSG";
    private static CommonFactory DEFAULT;
    protected final Hints hints;

    public BasicFactories(Map hints) {
        this.hints = hints != null ? new Hints(hints) : null;
    }

    public static synchronized CommonFactory getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new BasicFactories((Map)new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
        }
        return DEFAULT;
    }

    private static String unsupportedFactory(Class type) {
        return Errors.format((int)189, (Object)Utilities.getShortName((Class)type));
    }

    public CommonCapabilities getCapabilities() {
        throw new FactoryRegistryException(BasicFactories.unsupportedFactory(CommonCapabilities.class));
    }

    public FeatureDisplayFactory getFeatureDisplayFactory() throws FactoryRegistryException {
        throw new FactoryNotFoundException(BasicFactories.unsupportedFactory(FeatureDisplayFactory.class));
    }

    public TypeFactory getTypeFactory() throws FactoryRegistryException {
        throw new FactoryNotFoundException(BasicFactories.unsupportedFactory(TypeFactory.class));
    }

    public FilterFactory getFilterFactory() throws FactoryRegistryException {
        throw new FactoryNotFoundException(BasicFactories.unsupportedFactory(FilterFactory.class));
    }

    public DisplayFactory getDisplayFactory() throws FactoryRegistryException {
        throw new FactoryNotFoundException(BasicFactories.unsupportedFactory(DisplayFactory.class));
    }

    public NameFactory getNameFactory() throws FactoryRegistryException {
        throw new FactoryNotFoundException(BasicFactories.unsupportedFactory(NameFactory.class));
    }

    public CitationFactory getCitationFactory() throws FactoryRegistryException {
        throw new FactoryNotFoundException(BasicFactories.unsupportedFactory(CitationFactory.class));
    }

    public CRSAuthorityFactory getCRSAuthorityFactory() throws FactoryRegistryException {
        return FactoryFinder.getCRSAuthorityFactory((String)DEFAULT_AUTHORITY, (Hints)this.hints);
    }

    public CRSFactory getCRSFactory() throws FactoryRegistryException {
        return FactoryFinder.getCRSFactory((Hints)this.hints);
    }

    public CSAuthorityFactory getCSAuthorityFactory() throws FactoryRegistryException {
        return FactoryFinder.getCSAuthorityFactory((String)DEFAULT_AUTHORITY, (Hints)this.hints);
    }

    public CSFactory getCSFactory() throws FactoryRegistryException {
        return FactoryFinder.getCSFactory((Hints)this.hints);
    }

    public DatumAuthorityFactory getDatumAuthorityFactory() throws FactoryRegistryException {
        return FactoryFinder.getDatumAuthorityFactory((String)DEFAULT_AUTHORITY, (Hints)this.hints);
    }

    public DatumFactory getDatumFactory() throws FactoryRegistryException {
        return FactoryFinder.getDatumFactory((Hints)this.hints);
    }

    public CoordinateOperationAuthorityFactory getCoordinateOperationAuthorityFactory() throws FactoryRegistryException {
        return FactoryFinder.getCoordinateOperationAuthorityFactory((String)DEFAULT_AUTHORITY, (Hints)this.hints);
    }

    public CoordinateOperationFactory getCoordinateOperationFactory() throws FactoryRegistryException {
        return FactoryFinder.getCoordinateOperationFactory((Hints)this.hints);
    }

    public FeatureStyleFactory getFeatureStyleFactory() throws FactoryRegistryException {
        throw new FactoryNotFoundException(BasicFactories.unsupportedFactory(FeatureStyleFactory.class));
    }

    public GeometryFactory getGeometryFactory(CoordinateReferenceSystem crs) throws FactoryRegistryException {
        throw new FactoryNotFoundException(BasicFactories.unsupportedFactory(GeometryFactory.class));
    }

    public PrimitiveFactory getPrimitiveFactory(CoordinateReferenceSystem crs) throws FactoryRegistryException {
        throw new FactoryNotFoundException(BasicFactories.unsupportedFactory(PrimitiveFactory.class));
    }
}

