/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_salt;

import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Title", author="Manfred Fink", description="Calculates salt dynamics in soil")
public class j2k_soil_salt
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU attribute name area in m\u00c2\u00b2")
    public JAMSDouble area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" number of soil layers [-]")
    public JAMSDouble Layer;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in mm depth of soil layer")
    public JAMSDoubleArray layerdepth = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in cm depth of soil profile")
    public JAMSDouble totaldepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in dm actual depth of roots")
    public JAMSDouble rootdepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in kg/dm\u00c2\u00b3 soil bulk density")
    public JAMSDoubleArray soil_bulk_density = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="actual LPS in portion of sto_LPS soil water content")
    public JAMSDoubleArray sat_LPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="actual MPS in portion of sto_MPS soil water content")
    public JAMSDoubleArray sat_MPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="maximum MPS  in l soil water content")
    public JAMSDoubleArray stohru_MPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="maximum LPS  in l soil water content")
    public JAMSDoubleArray stohru_LPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="maximum FPS  in l soil water content")
    public JAMSDoubleArray stohru_FPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="soil temperature in layerdepth in \u00c2\u00b0C")
    public JAMSDoubleArray Soil_Temp_Layer = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" NO3-Pool in kgN/ha")
    public JAMSDoubleArray NaCl_Pool = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="sum of NO3-Pool in kgN/ha")
    public JAMSDouble sNaCl_Pool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description=" sum of interflowNaClabs in kgNaCl/ha")
    public JAMSDouble sinterflowNaClabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description=" sum of interflowNaCl in kgNaCl/ha")
    public JAMSDouble sinterflowNaCl;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" actual evaporation in mm")
    public JAMSDoubleArray aEP_h = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="mps diffusion between layers value")
    public JAMSDoubleArray w_layer_diff = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" surface runoff in l")
    public JAMSDouble RD1_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" interflow in l")
    public JAMSDoubleArray RD2_out = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" percolation in l")
    public JAMSDouble D_perco;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" NaCl in surface runoff in  in kgNaCl/ha")
    public JAMSDouble SurfaceNaCl;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" NaCl in interflow in  in kgNaCl/ha")
    public JAMSDoubleArray InterflowNaCl = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" NaCl in percolation in kgNaCl/ha")
    public JAMSDouble PercoNaCl;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in surface runoff in kgNaCl")
    public JAMSDouble SurfaceNaClabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in interflow in in kgNaCl")
    public JAMSDoubleArray InterflowNaClabs = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in percolation in in kgNaCl")
    public JAMSDouble PercoNaClabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in surface runoff added to HRU layer in in kgNaCl")
    public JAMSDouble SurfaceNaCl_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" NaCl in interflow in added to HRU layer in kgNaCl")
    public JAMSDoubleArray InterflowNaCl_in = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="potential NaCl content of plants in kgNaCl/ha")
    public JAMSDouble BioSALToptAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual NaCl nitrogen content of plants in kgN/ha")
    public JAMSDouble BioSALTAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual NaCl uptake of plants in kgN/ha")
    public JAMSDouble actNaCl_up;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="intfiltration poritions for the single horizonts in l")
    public JAMSDoubleArray infiltration_hor = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="percolation out ouf the single horizonts in l")
    public JAMSDoubleArray perco_hor = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="percolation out ouf the single horizonts in l")
    public JAMSDoubleArray actETP_h = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" Input of plant residues kg/ha")
    public JAMSDouble inp_biomass;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Nitrogen input of plant residues in kgN/ha")
    public JAMSDouble inpNaCl_biomass;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Residue in Layer in kgN/ha")
    public JAMSDoubleArray Residue_pool = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" NaCl-Organic fresh Pool from Residue in kgN/ha")
    public JAMSDoubleArray NaCl_residue_pool_fresh = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" NaCl-Organic fresh Pool from Residue in kgN/ha")
    public JAMSDouble sNaClResiduePool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="infiltration bypass parameter to calibrate = 0 - 1")
    public JAMSDouble infil_conc_factor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="concentration of Salt in rain = 0 - 0.05 kgNaCl/(mm * ha)")
    public JAMSDouble deposition_factor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="precipitation in mm")
    public JAMSDouble precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="indicates dormancy of plants")
    public JAMSBoolean dormancy;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" actual evaporation in mm")
    public JAMSDoubleArray aTP_h = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" percolation coefitient to calibrate = 0.2")
    public JAMSDouble Beta_NaCl;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" percolation coefitient to calibrate = 0.2")
    public JAMSDouble Beta_rsd;
    private double gamma_temp;
    private double gamma_water;
    private double runarea;
    private double runSoil_Temp_Layer;
    private double[] runlayerdepth;
    private double runsoil_bulk_density;
    private double sto_MPS;
    private double sto_LPS;
    private double sto_FPS;
    private double act_LPS;
    private double act_MPS;
    private double runnetPrecip;
    private double runNaCl_Pool;
    private double RD1_out_mm;
    private double RD2_out_mm;
    private double d_perco_mm;
    private double h_perco_mm;
    private double h_infilt_mm;
    private int layer;
    private double runResidue_pool;
    private double runplantupNaCl;
    private double runsurfaceNaCl;
    private double runinterflowNaCl;
    private double runpercoNaCl;
    private double runsurfaceNaClabs;
    private double runinterflowNaClabs;
    private double runpercoNaClabs;
    private double runsurfaceNaCl_in;
    private double runinterflowNaCl_in;
    private double sumlayer;
    private double runNaCl_residue_pool_fresh;
    private double runBeta_min;
    private double runBeta_rsd;
    private double runBeta_NaCl;
    private double theta_nit = 0.0;
    private double concSALT_mobile = 0.0;
    private double delta_ntr = 0.0;
    private int datumjul = 0;
    private int app_time = 0;
    double[] hor_by_infilt;
    double[] NaCl_Poolvals;
    double[] w_l_diff;
    double[] ConcSALT_mobile;
    double[] diffout;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        int i = 0;
        this.gamma_temp = 0.0;
        this.gamma_water = 0.0;
        this.runarea = this.area.getValue();
        this.layer = (int)this.Layer.getValue();
        double runprecip = this.precip.getValue();
        this.sumlayer = 0.0;
        double runsum_Ninput = 0.0;
        double sumNaCl_Pool = 0.0;
        double sumNaCl_residue_pool = 0.0;
        double plantuptake_NaCl = 0.0;
        double sumplantuptake_NaCl = 0.0;
        double suminterflowNaClabs = 0.0;
        double suminterflowNaCl = 0.0;
        double h_infilt_mm_sum = 0.0;
        double sumh_infilt_mm = 0.0;
        double sum_Saltupmove = 0.0;
        double Salt_upmove_h = 0.0;
        double a_deposition = 0.0;
        double NaClrespool = 0.0;
        double diffoutNa = 0.0;
        this.runlayerdepth = new double[this.layer];
        double[] NaCl_residue_pool_freshvals = new double[this.layer];
        double[] Residue_poolvals = new double[this.layer];
        double[] interflowNaClvals = new double[this.layer];
        double[] percoNaClvals = new double[this.layer];
        double[] interflowNaClabsvals = new double[this.layer];
        double[] percoNaClabsvals = new double[this.layer];
        double[] plantup_hor = new double[this.layer];
        double[] NaClbalance = new double[this.layer];
        double[] NaCl_Poolalt = new double[this.layer];
        this.runsurfaceNaCl = 0.0;
        this.runBeta_rsd = this.Beta_rsd.getValue();
        this.hor_by_infilt = new double[this.layer];
        this.diffout = new double[this.layer];
        this.w_l_diff = new double[this.layer];
        this.NaCl_Poolvals = new double[this.layer];
        this.ConcSALT_mobile = new double[this.layer];
        i = 0;
        i = 0;
        double sumplant = 0.0;
        double plantup_h = 0.0;
        for (i = this.layer - 1; i > 0; --i) {
            this.h_infilt_mm = this.infiltration_hor.getValue()[i] / this.runarea;
            this.hor_by_infilt[i - 1] = (sumh_infilt_mm += this.h_infilt_mm) * this.infil_conc_factor.getValue();
        }
        for (i = 0; i < this.layer; ++i) {
            this.NaCl_Poolvals[i] = this.NaCl_Pool.getValue()[i];
            this.diffout[i] = 0.0;
        }
        i = 0;
        for (i = 0; i < this.layer - 1; ++i) {
            this.w_l_diff[i] = this.w_layer_diff.getValue()[i] / this.runarea;
            if (this.w_l_diff[i] > 0.0) {
                this.diffout[i + 1] = this.diffout[i + 1] + this.w_l_diff[i];
                continue;
            }
            this.diffout[i] = this.diffout[i] - this.w_l_diff[i];
        }
        for (i = 0; i < this.layer; ++i) {
            this.sto_MPS = this.stohru_MPS.getValue()[i] / this.runarea;
            this.sto_LPS = this.stohru_LPS.getValue()[i] / this.runarea;
            this.sto_FPS = this.stohru_FPS.getValue()[i] / this.runarea;
            this.act_LPS = this.sat_LPS.getValue()[i] * this.sto_LPS;
            this.act_MPS = this.sat_MPS.getValue()[i] * this.sto_MPS;
            this.runResidue_pool = this.Residue_pool.getValue()[i];
            this.runNaCl_Pool = this.NaCl_Pool.getValue()[i];
            this.RD1_out_mm = this.RD1_out.getValue() / this.runarea;
            this.RD2_out_mm = this.RD2_out.getValue()[i] / this.runarea;
            this.d_perco_mm = this.D_perco.getValue() / this.runarea;
            this.h_perco_mm = this.perco_hor.getValue()[i] / this.runarea;
            this.runinterflowNaCl = 0.0;
            this.runpercoNaCl = 0.0;
            this.runNaCl_residue_pool_fresh = this.NaCl_residue_pool_fresh.getValue()[i];
            this.runsurfaceNaCl_in = this.SurfaceNaCl_in.getValue() * 10000.0 / this.runarea;
            this.runinterflowNaCl_in = this.InterflowNaCl_in.getValue()[i] * 10000.0 / this.runarea;
            this.SurfaceNaCl_in.setValue(0.0);
            for (int j = 1; j < this.layer; ++j) {
                Salt_upmove_h = this.calc_saltupmove(j);
                sum_Saltupmove += Salt_upmove_h;
            }
            if (this.runSoil_Temp_Layer == 0.0) {
                this.runSoil_Temp_Layer = 1.0E-5;
            }
            this.gamma_temp = 0.9 * (this.runSoil_Temp_Layer / (this.runSoil_Temp_Layer * Math.exp(9.93 - 0.312 * this.runSoil_Temp_Layer)));
            this.gamma_water = this.sto_LPS + this.sto_MPS + this.sto_FPS > 0.0 ? (this.act_LPS + this.act_MPS + this.sto_FPS) / (this.sto_LPS + this.sto_MPS + this.sto_FPS) : 0.0;
            a_deposition = this.deposition_factor.getValue() * runprecip;
            double delta_res = this.calc_Res_Salt_trans();
            NaClrespool = delta_res * this.runNaCl_residue_pool_fresh;
            this.runNaCl_Pool = this.runNaCl_Pool + sum_Saltupmove + a_deposition + NaClrespool;
            this.runNaCl_residue_pool_fresh -= delta_res * this.runNaCl_residue_pool_fresh;
            this.runNaCl_Pool = i > 0 ? this.runNaCl_Pool + this.runinterflowNaCl_in + percoNaClvals[i - 1] : (this.runNaCl_Pool += this.runinterflowNaCl_in);
            this.ConcSALT_mobile[i] = this.concSALT_mobile = this.calc_concSALT_mobile(i);
            plantuptake_NaCl = this.calc_plantuptake(i);
            if (i == 0) {
                this.runsurfaceNaCl = this.calc_surfaceNaCl();
                this.runNaCl_Pool -= this.runsurfaceNaCl;
            }
            this.runinterflowNaCl = this.calc_interflowNaCl(i);
            this.runNaCl_Pool -= this.runinterflowNaCl;
            this.runpercoNaCl = this.calc_percoNaCl(i);
            this.runNaCl_Pool -= this.runpercoNaCl;
            if (this.runNaCl_Pool < 0.0) {
                this.runNaCl_Pool = 0.0;
            }
            this.runinterflowNaClabs = this.runinterflowNaCl * this.runarea / 10000.0;
            this.runpercoNaClabs = this.runpercoNaCl * this.runarea / 10000.0;
            this.NaCl_Poolvals[i] = this.runNaCl_Pool;
            Residue_poolvals[i] = this.runResidue_pool;
            interflowNaClvals[i] = this.runinterflowNaCl;
            interflowNaClabsvals[i] = this.runinterflowNaClabs;
            percoNaClvals[i] = this.runpercoNaCl;
            percoNaClabsvals[i] = this.runpercoNaClabs;
            sumplantuptake_NaCl += plantuptake_NaCl;
            sumNaCl_residue_pool += this.runNaCl_residue_pool_fresh;
            sumNaCl_Pool += this.runNaCl_Pool;
            suminterflowNaClabs = this.runinterflowNaClabs + suminterflowNaClabs;
            suminterflowNaCl = this.runinterflowNaCl + suminterflowNaCl;
            NaCl_residue_pool_freshvals[i] = this.runNaCl_residue_pool_fresh;
        }
        i = 0;
        for (i = 0; i < this.layer - 1; ++i) {
            if (this.w_l_diff[i] < 0.0) {
                diffoutNa = this.w_l_diff[i] * this.ConcSALT_mobile[i];
                this.NaCl_Poolvals[i] = this.NaCl_Poolvals[i] + diffoutNa;
                this.NaCl_Poolvals[i + 1] = this.NaCl_Poolvals[i + 1] - diffoutNa;
                continue;
            }
            diffoutNa = this.w_l_diff[i] * this.ConcSALT_mobile[i + 1];
            this.NaCl_Poolvals[i] = this.NaCl_Poolvals[i] - diffoutNa;
            this.NaCl_Poolvals[i + 1] = this.NaCl_Poolvals[i + 1] + diffoutNa;
        }
        double[] zerosetter = new double[this.layer];
        for (i = 0; i < this.layer; ++i) {
            zerosetter[i] = 0.0;
        }
        this.NaCl_Pool.setValue(this.NaCl_Poolvals);
        this.NaCl_residue_pool_fresh.setValue(NaCl_residue_pool_freshvals);
        this.Residue_pool.setValue(Residue_poolvals);
        this.InterflowNaCl.setValue(interflowNaClvals);
        this.InterflowNaClabs.setValue(interflowNaClabsvals);
        this.PercoNaCl.setValue(percoNaClvals[this.layer - 1]);
        this.PercoNaClabs.setValue(percoNaClabsvals[this.layer - 1]);
        this.SurfaceNaCl.setValue(this.runsurfaceNaCl);
        this.runsurfaceNaClabs = this.runsurfaceNaCl * this.runarea / 10000.0;
        this.SurfaceNaClabs.setValue(this.runsurfaceNaClabs);
        this.sinterflowNaClabs.setValue(suminterflowNaClabs);
        this.sinterflowNaCl.setValue(suminterflowNaCl);
        this.actNaCl_up.setValue(sumplantuptake_NaCl);
        this.sNaCl_Pool.setValue(sumNaCl_Pool);
        this.sNaClResiduePool.setValue(sumNaCl_residue_pool);
        this.InterflowNaCl_in.setValue(zerosetter);
    }

    private double calc_plantuptake(int i) {
        double plantuptake = 0.0;
        plantuptake = this.ConcSALT_mobile[i] * this.aTP_h.getValue()[i];
        return plantuptake;
    }

    private double calc_saltupmove(int j) {
        double salt_upmove = 0.0;
        double runaEvap = this.aEP_h.getValue()[j];
        double sto_MPS = this.stohru_MPS.getValue()[j];
        double sto_LPS = this.stohru_LPS.getValue()[j];
        double sto_FPS = this.stohru_FPS.getValue()[j];
        double act_LPS = this.sat_LPS.getValue()[j] * sto_LPS;
        double act_MPS = this.sat_MPS.getValue()[j] * sto_MPS;
        salt_upmove = 0.1 * this.NaCl_Poolvals[j] * (runaEvap / (act_LPS + act_MPS + sto_FPS));
        this.NaCl_Poolvals[j] = this.NaCl_Poolvals[j] - salt_upmove;
        return salt_upmove;
    }

    private double calc_concSALT_mobile(int i) {
        double concSALT_mobile = 0.0;
        double concSALT_temp = 0.0;
        double mobilewater = 0.0;
        double soilstorage = 0.0;
        soilstorage = this.sto_LPS + this.sto_MPS + this.sto_FPS;
        if (i == 0) {
            mobilewater = this.RD1_out_mm + this.RD2_out_mm + this.h_perco_mm + this.hor_by_infilt[i] + this.diffout[i] + 1.0E-10;
        } else if (i > 0) {
            mobilewater = this.RD2_out_mm + this.h_perco_mm + this.hor_by_infilt[i] + this.diffout[i] + 1.0E-10;
        }
        if (i == this.layer - 1) {
            mobilewater = this.RD2_out_mm + this.d_perco_mm + this.diffout[i] + 1.0E-10;
        }
        if ((concSALT_mobile = (concSALT_temp = this.runNaCl_Pool * (1.0 - Math.exp(-mobilewater / ((1.0 - this.theta_nit) * soilstorage)))) / mobilewater) < 0.0) {
            concSALT_mobile = 0.0;
        }
        return concSALT_mobile;
    }

    private double concSALT_mobile2() {
        double concSALT_mobile = 0.0;
        double mobilewater = 0.0;
        double soilstorage = 0.0;
        soilstorage = this.sto_LPS + this.sto_MPS + this.sto_FPS;
        if (this.layer == 0) {
            mobilewater = this.RD1_out_mm + this.RD2_out_mm + this.d_perco_mm + 1.0E-10;
        } else if (this.layer > 0) {
            mobilewater = this.RD2_out_mm + this.d_perco_mm + 1.0E-10;
        }
        concSALT_mobile = this.runNaCl_Pool / (mobilewater + (1.0 - this.theta_nit) * soilstorage);
        if (concSALT_mobile < 0.0) {
            concSALT_mobile = 0.0;
        }
        return concSALT_mobile;
    }

    private double calc_surfaceNaCl() {
        double surfaceSALT = 0.0;
        surfaceSALT = this.Beta_NaCl.getValue() * this.RD1_out_mm * this.concSALT_mobile;
        surfaceSALT = Math.min(surfaceSALT, this.runNaCl_Pool);
        return surfaceSALT;
    }

    private double calc_interflowNaCl(int i) {
        double interflowSALT = 0.0;
        if (i == 0) {
            interflowSALT = (1.0 - this.Beta_NaCl.getValue()) * this.RD2_out_mm * this.concSALT_mobile;
            interflowSALT = Math.min(interflowSALT, this.runNaCl_Pool);
        } else if (i > 0) {
            interflowSALT = this.RD2_out_mm * this.concSALT_mobile;
            interflowSALT = Math.min(interflowSALT, this.runNaCl_Pool);
        }
        if (interflowSALT < 0.0) {
            System.out.println(this.RD2_out_mm + " = RD2_out_mm " + interflowSALT + " = interflowN");
        }
        return interflowSALT;
    }

    private double calc_percoNaCl(int i) {
        double percoSALT = 0.0;
        percoSALT = i < this.layer - 1 ? (this.hor_by_infilt[i] + this.h_perco_mm) * this.concSALT_mobile : this.d_perco_mm * this.concSALT_mobile;
        percoSALT = Math.min(percoSALT, this.runNaCl_Pool);
        return percoSALT;
    }

    private double calc_Res_Salt_trans() {
        double epsilon_C_N = 0.0;
        double gamma_ntr = 0.0;
        epsilon_C_N = 30.0;
        gamma_ntr = Math.min(1.0, Math.exp(-0.693 * ((epsilon_C_N - 25.0) / 25.0)));
        this.delta_ntr = this.runBeta_rsd * gamma_ntr * Math.sqrt(this.gamma_temp * this.gamma_water);
        return this.delta_ntr;
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException {
    }
}

