/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_salt;

import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KProcessReachRouting_NaCl", author="c0krpe & Manfred Fink", description="Reach Routing of Water and Salt to replace J2KProcessReachRouting")
public class J2KProcessReachRouting_NaCl
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The reach collection")
    public JAMSEntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute length")
    public JAMSDouble length;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute slope")
    public JAMSDouble slope;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute width")
    public JAMSDouble width;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute roughness")
    public JAMSDouble roughness;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD1 inflow")
    public JAMSDouble inRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD2 inflow")
    public JAMSDouble inRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG1 inflow")
    public JAMSDouble inRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG2 inflow")
    public JAMSDouble inRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD1 outflow")
    public JAMSDouble outRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD2 outflow")
    public JAMSDouble outRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG1 outflow")
    public JAMSDouble outRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG2 outflow")
    public JAMSDouble outRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar simulated Runoff")
    public JAMSDouble simRunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD1 storage")
    public JAMSDouble actRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD2 storage")
    public JAMSDouble actRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG1 storage")
    public JAMSDouble actRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG2 storage")
    public JAMSDouble actRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Channel storage")
    public JAMSDouble channelStorage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="flow routing coefficient TA")
    public JAMSDouble flowRouteTA;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="SurfaceNaCl outflow in kgNaCl")
    public JAMSDouble SurfaceNaClabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="(fast) InterflowN outflow in kgN")
    public JAMSDouble InterflowNaClabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="(slow) InterflowN outflow in kgN")
    public JAMSDouble NaCl_RG1_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="GoundwaterN outflow in kgN")
    public JAMSDouble NaCl_RG2_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD1_N (SurfaceN) storage in kgN")
    public JAMSDouble ActRD1_NaCl;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD2_N ((fast) InterflowN) storage in kgN")
    public JAMSDouble ActRD2_NaCl;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG1_N ((slow) InterflowN) storage in kgN")
    public JAMSDouble ActRG1_NaCl;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG2_N (GoundwaterN) storage in kgN")
    public JAMSDouble ActRG2_NaCl;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach Channel storage N in kgN")
    public JAMSDouble ChannelStorage_NaCl;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Simulated N Runoff in kgN")
    public JAMSDouble SimRunoff_NaCl;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="SurfaceN inflow in kgN")
    public JAMSDouble SurfaceNaCl_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="(fast) InterflowN inflow in kgN")
    public JAMSDouble InterflowNaCl_sum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="(slow) InterflowN inflow in kgN")
    public JAMSDouble NaCl_RG1_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="GoundwaterN inflow in kgN")
    public JAMSDouble NaCl_RG2_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet RD1 storage")
    public JAMSDouble catchmentRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet RD2 storage")
    public JAMSDouble catchmentRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet RG1 storage")
    public JAMSDouble catchmentRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet RG2 storage")
    public JAMSDouble catchmentRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet sim runoff")
    public JAMSDouble catchmentSimRunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet NRD1 storage")
    public JAMSDouble catchmentNaClRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet NRD2 storage")
    public JAMSDouble catchmentNaClRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet NRG1 storage")
    public JAMSDouble catchmentNaClRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet NRG2 storage")
    public JAMSDouble catchmentNaClRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet sim Nitrogen runoff")
    public JAMSDouble catchmentSimRunoffNaCl;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="switch whether deep sink is allowed or not")
    public JAMSDouble deepsink;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="amount of water lost by deep sink in l/d")
    public JAMSDouble DeepsinkW;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="amount of nitrogen lost by deep sink in kg/d")
    public JAMSDouble DeepsinkNaCl;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="K-Value for the riverbed in cm/d")
    public JAMSDouble Ksink;
    private double depth;
    private double rh;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double RG2DestIn_NaCl;
        double RG1DestIn_NaCl;
        double RD2DestIn_NaCl;
        double RD1DestIn_NaCl;
        double RG2DestIn;
        double RG1DestIn;
        double RD2DestIn;
        double RD1DestIn;
        JAMSEntity entity = this.entities.getCurrent();
        JAMSEntity DestReach = (JAMSEntity)entity.getObject("to_reach");
        double deepsinkW = 0.0;
        double deepsinkNaCl = 0.0;
        double Larea = 0.0;
        double width = this.width.getValue();
        double slope = this.slope.getValue();
        double rough = this.roughness.getValue();
        double length = this.length.getValue();
        double RD1act = this.actRD1.getValue() + this.inRD1.getValue();
        double RD2act = this.actRD2.getValue() + this.inRD2.getValue();
        double RG1act = this.actRG1.getValue() + this.inRG1.getValue();
        double RG2act = this.actRG2.getValue() + this.inRG2.getValue();
        double RD1act_NaCl = this.ActRD1_NaCl.getValue() + this.SurfaceNaCl_in.getValue();
        double RD2act_NaCl = this.ActRD2_NaCl.getValue() + this.InterflowNaCl_sum.getValue();
        double RG1act_NaCl = this.ActRG1_NaCl.getValue() + this.NaCl_RG1_in.getValue();
        double RG2act_NaCl = this.ActRG2_NaCl.getValue() + this.NaCl_RG2_in.getValue();
        this.depth = 0.0;
        this.inRD1.setValue(0.0);
        this.inRD2.setValue(0.0);
        this.inRG1.setValue(0.0);
        this.inRG2.setValue(0.0);
        this.actRD1.setValue(0.0);
        this.actRD2.setValue(0.0);
        this.actRG1.setValue(0.0);
        this.actRG2.setValue(0.0);
        this.SurfaceNaCl_in.setValue(0.0);
        this.InterflowNaCl_sum.setValue(0.0);
        this.NaCl_RG1_in.setValue(0.0);
        this.NaCl_RG2_in.setValue(0.0);
        this.ActRD1_NaCl.setValue(0.0);
        this.ActRD2_NaCl.setValue(0.0);
        this.ActRG1_NaCl.setValue(0.0);
        this.ActRG2_NaCl.setValue(0.0);
        if (entity.getObject("to_reach") == null) {
            RD1DestIn = 0.0;
            RD2DestIn = 0.0;
            RG1DestIn = 0.0;
            RG2DestIn = 0.0;
            RD1DestIn_NaCl = 0.0;
            RD2DestIn_NaCl = 0.0;
            RG1DestIn_NaCl = 0.0;
            RG2DestIn_NaCl = 0.0;
        } else {
            RD1DestIn = DestReach.getDouble("inRD1");
            RD2DestIn = DestReach.getDouble("inRD2");
            RG1DestIn = DestReach.getDouble("inRG1");
            RG2DestIn = DestReach.getDouble("inRG2");
            RD1DestIn_NaCl = DestReach.getDouble("SurfaceNaCl_in");
            RD2DestIn_NaCl = DestReach.getDouble("InterflowNaCl_sum");
            RG1DestIn_NaCl = DestReach.getDouble("NaCl_RG1_in");
            RG2DestIn_NaCl = DestReach.getDouble("NaCl_RG2_in");
        }
        double q_act_tot = RD1act + RD2act + RG1act + RG2act;
        double q_act_tot_NaCl = RD1act_NaCl + RD2act_NaCl + RG1act_NaCl + RG2act_NaCl;
        if (q_act_tot == 0.0) {
            this.outRD1.setValue(0.0);
            this.outRD2.setValue(0.0);
            this.outRG1.setValue(0.0);
            this.outRG2.setValue(0.0);
            this.SurfaceNaClabs.setValue(0.0);
            this.InterflowNaClabs.setValue(0.0);
            this.NaCl_RG1_out.setValue(0.0);
            this.NaCl_RG2_out.setValue(0.0);
            return;
        }
        double RD1_part = RD1act / q_act_tot;
        double RD2_part = RD2act / q_act_tot;
        double RG1_part = RG1act / q_act_tot;
        double RG2_part = RG2act / q_act_tot;
        double RD1_part_NaCl = 0.0;
        double RD2_part_NaCl = 0.0;
        double RG1_part_NaCl = 0.0;
        double RG2_part_NaCl = 0.0;
        if (q_act_tot_NaCl != 0.0) {
            RD1_part_NaCl = RD1act_NaCl / q_act_tot_NaCl;
            RD2_part_NaCl = RD2act_NaCl / q_act_tot_NaCl;
            RG1_part_NaCl = RG1act_NaCl / q_act_tot_NaCl;
            RG2_part_NaCl = RG2act_NaCl / q_act_tot_NaCl;
        }
        double NaCl_conc_tot = q_act_tot_NaCl / q_act_tot;
        double flow_veloc = this.calcFlowVelocity(q_act_tot, width, slope, rough, 86400);
        double Rk = flow_veloc / length * this.flowRouteTA.getValue() * 3600.0;
        double q_act_out = Rk > 0.0 ? q_act_tot * Math.exp(-1.0 / Rk) : 0.0;
        double q_act_out_NaCl = q_act_out * NaCl_conc_tot;
        if (this.deepsink.getValue() == 1.0) {
            Larea = Math.pow(this.rh, 2.0) * length;
            deepsinkW = Larea * this.Ksink.getValue() * 10.0;
            deepsinkNaCl = deepsinkW * NaCl_conc_tot;
            deepsinkW = Math.min(deepsinkW, q_act_out);
            deepsinkNaCl = Math.min(deepsinkNaCl, q_act_out_NaCl);
            deepsinkW = Math.max(deepsinkW, 0.0);
            deepsinkNaCl = Math.max(deepsinkNaCl, 0.0);
        } else {
            deepsinkW = 0.0;
            deepsinkNaCl = 0.0;
        }
        this.DeepsinkW.setValue(deepsinkW);
        this.DeepsinkNaCl.setValue(deepsinkNaCl);
        double RD1outdeep = deepsinkW * RD1_part;
        double RD2outdeep = deepsinkW * RD2_part;
        double RG1outdeep = deepsinkW * RG1_part;
        double RG2outdeep = deepsinkW * RG2_part;
        double RD1out_NaCldeep = deepsinkNaCl * RD1_part_NaCl;
        double RD2out_NaCldeep = deepsinkNaCl * RD2_part_NaCl;
        double RG1out_NaCldeep = deepsinkNaCl * RG1_part_NaCl;
        double RG2out_NaCldeep = deepsinkNaCl * RG2_part_NaCl;
        double RD1out = q_act_out * RD1_part - RD1outdeep;
        double RD2out = q_act_out * RD2_part - RD2outdeep;
        double RG1out = q_act_out * RG1_part - RG1outdeep;
        double RG2out = q_act_out * RG2_part - RG2outdeep;
        double RD1out_NaCl = q_act_out_NaCl * RD1_part_NaCl - RD1out_NaCldeep;
        double RD2out_NaCl = q_act_out_NaCl * RD2_part_NaCl - RD2out_NaCldeep;
        double RG1out_NaCl = q_act_out_NaCl * RG1_part_NaCl - RG1out_NaCldeep;
        double RG2out_NaCl = q_act_out_NaCl * RG2_part_NaCl - RG2out_NaCldeep;
        RD1DestIn += RD1out;
        RD2DestIn += RD2out;
        RG1DestIn += RG1out;
        RG2DestIn += RG2out;
        RD1DestIn_NaCl += RD1out_NaCl;
        RD2DestIn_NaCl += RD2out_NaCl;
        RG1DestIn_NaCl += RG1out_NaCl;
        RG2DestIn_NaCl += RG2out_NaCl;
        RD1act = RD1act - RD1out - RD1outdeep;
        if (RD1act < 0.0) {
            RD1act = 0.0;
        }
        if ((RD2act = RD2act - RD2out - RD2outdeep) < 0.0) {
            RD2act = 0.0;
        }
        if ((RG1act = RG1act - RG1out - RG1outdeep) < 0.0) {
            RG1act = 0.0;
        }
        if ((RG2act = RG2act - RG2out - RG1outdeep) < 0.0) {
            RG2act = 0.0;
        }
        if ((RD1act_NaCl = RD1act_NaCl - RD1out_NaCl - RD1out_NaCldeep) < 0.0) {
            RD1act_NaCl = 0.0;
        }
        if ((RD2act_NaCl = RD2act_NaCl - RD2out_NaCl - RD2out_NaCldeep) < 0.0) {
            RD2act_NaCl = 0.0;
        }
        if ((RG1act_NaCl = RG1act_NaCl - RG1out_NaCl - RG1out_NaCldeep) < 0.0) {
            RG1act_NaCl = 0.0;
        }
        if ((RG2act_NaCl = RG2act_NaCl - RG2out_NaCl - RG2out_NaCldeep) < 0.0) {
            RG2act_NaCl = 0.0;
        }
        double channelStorage = RD1act + RD2act + RG1act + RG2act;
        double channelStorage_NaCl = RD1act_NaCl + RD2act_NaCl + RG1act_NaCl + RG2act_NaCl;
        double cumOutflow = RD1out + RD2out + RG1out + RG2out;
        double cumOutflow_NaCl = RD1out_NaCl + RD2out_NaCl + RG1out_NaCl + RG2out_NaCl;
        this.simRunoff.setValue(cumOutflow);
        this.SimRunoff_NaCl.setValue(cumOutflow_NaCl);
        this.channelStorage.setValue(channelStorage);
        this.ChannelStorage_NaCl.setValue(channelStorage_NaCl);
        this.inRD1.setValue(0.0);
        this.inRD2.setValue(0.0);
        this.inRG1.setValue(0.0);
        this.inRG2.setValue(0.0);
        this.SurfaceNaCl_in.setValue(0.0);
        this.InterflowNaCl_sum.setValue(0.0);
        this.NaCl_RG1_in.setValue(0.0);
        this.NaCl_RG2_in.setValue(0.0);
        this.actRD1.setValue(RD1act);
        this.actRD2.setValue(RD2act);
        this.actRG1.setValue(RG1act);
        this.actRG2.setValue(RG2act);
        this.ActRD1_NaCl.setValue(RD1act_NaCl);
        this.ActRD2_NaCl.setValue(RD2act_NaCl);
        this.ActRG1_NaCl.setValue(RG1act_NaCl);
        this.ActRG2_NaCl.setValue(RG2act_NaCl);
        this.outRD1.setValue(RD1out);
        this.outRD2.setValue(RD2out);
        this.outRG1.setValue(RG1out);
        this.outRG2.setValue(RG2out);
        this.SurfaceNaClabs.setValue(RD1out_NaCl);
        this.InterflowNaClabs.setValue(RD2out_NaCl);
        this.NaCl_RG1_out.setValue(RG1out_NaCl);
        this.NaCl_RG2_out.setValue(RG2out_NaCl);
        if (entity.getObject("to_reach") != null) {
            DestReach.setDouble("inRD1", RD1DestIn);
            DestReach.setDouble("inRD2", RD2DestIn);
            DestReach.setDouble("inRG1", RG1DestIn);
            DestReach.setDouble("inRG2", RG2DestIn);
            DestReach.setDouble("SurfaceNaCl_in", RD1DestIn_NaCl);
            DestReach.setDouble("InterflowNaCl_sum", RD2DestIn_NaCl);
            DestReach.setDouble("NaCl_RG1_in", RG1DestIn_NaCl);
            DestReach.setDouble("NaCl_RG2_in", RG2DestIn_NaCl);
        } else {
            this.catchmentRD1.setValue(RD1out);
            this.catchmentRD2.setValue(RD2out);
            this.catchmentRG1.setValue(RG1out);
            this.catchmentRG2.setValue(RG2out);
            this.catchmentSimRunoff.setValue(cumOutflow);
            this.catchmentNaClRD1.setValue(RD1out_NaCl);
            this.catchmentNaClRD2.setValue(RD2out_NaCl);
            this.catchmentNaClRG1.setValue(RG1out_NaCl);
            this.catchmentNaClRG2.setValue(RG2out_NaCl);
            this.catchmentSimRunoffNaCl.setValue(cumOutflow_NaCl);
        }
    }

    public void cleanup() {
    }

    public double calcFlowVelocity(double q, double width, double slope, double rough, int secondsOfTimeStep) {
        double afv = 1.0;
        double veloc = 0.0;
        double q_m = q / (double)(1000 * secondsOfTimeStep);
        this.rh = J2KProcessReachRouting_NaCl.calcHydraulicRadius(afv, q_m, width);
        boolean cont = true;
        while (cont) {
            veloc = rough * Math.pow(this.rh, 0.6666666666666666) * Math.sqrt(slope);
            if (Math.abs(veloc - afv) > 0.001) {
                afv = veloc;
                this.rh = J2KProcessReachRouting_NaCl.calcHydraulicRadius(afv, q_m, width);
                continue;
            }
            cont = false;
            afv = veloc;
        }
        return afv;
    }

    public static double calcHydraulicRadius(double v, double q, double width) {
        double A = q / v;
        double rh = A / (width + 2.0 * (A / width));
        return rh;
    }
}

