/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n.management;

import java.util.ArrayList;
import org.jams.j2k.s_n.crop.J2KSNCrop;
import org.jams.j2k.s_n.crop.J2KSNFertilizer;
import org.jams.j2k.s_n.crop.J2KSNLMArable;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSTimeInterval;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;

public class ManageLanduse_szeno
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current hru object")
    public JAMSEntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Current NH4 fertilizer amount")
    public JAMSDouble fertNH4N;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Current NO3 fertilizer amount")
    public JAMSDouble fertNO3N;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Current organic fertilizer amount")
    public JAMSDouble fertorgNactive;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Current organic fertilizer amount added to residue pool")
    public JAMSDouble fertorgNfresh;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reduction Factor for Fertilisation 0 - 10 [-]")
    public JAMSDouble ReductionFactor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Current organic fertilizer amount")
    public JAMSInteger RotPos;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Current organic fertilizer amount")
    public JAMSInteger ManagementPos;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Plant exisiting or not")
    public JAMSBoolean plantExisting;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Indicator for harvesting")
    public JAMSBoolean doHarvest;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Date to start reduction")
    public JAMSCalendar start;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Date to end reduction")
    public JAMSCalendar end;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Encapsulating time interval")
    public JAMSTimeInterval timeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Indicates fertilazation optimization with plant demand")
    public JAMSDouble opti;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Mineral nitrogen content in the soil profile down to 60 cm depth")
    public JAMSDouble nmin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="optimal nitrogen content in Biomass in (kgN/ha)")
    public JAMSDouble optibioN;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual nitrogen content in Biomass in (kgN/ha)")
    public JAMSDouble actbioN;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Fraction of actual potential heat units sum [-]")
    public JAMSDouble FPHUact;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Fertilisation reduction due to the plant demand routine [kgN/ha]")
    public JAMSDouble Nredu;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Number of fertilisation action in crop [-]")
    public JAMSDouble gift;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Maximum amount of N-fertilizer in [kg/ha*a]")
    public JAMSDouble maxfert;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Rest after former gifts amount of N-fertilizer in [kg/ha*a]")
    public JAMSDouble restfert;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="in [-] plant groth nitrogen stress factor")
    public JAMSDouble nstrs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Minimum counter between 2 fertilizer actions in days (only used when opti = 2)")
    public JAMSDouble Dayintervall;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Type of harvest to distiguish between crops with undersown plants and normal harvesting")
    public JAMSInteger harvesttype;
    private JAMSTimeInterval ti;
    double endbioN;
    double bion02;
    double bion04;
    double bion06;
    double bion08;
    double runNredu;

    public void init() {
        this.ti = new JAMSTimeInterval(this.start, this.end, this.timeInterval.getTimeUnit(), this.timeInterval.getTimeUnitCount());
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double dayintervall = this.Dayintervall.getValue();
        JAMSEntity entity = this.entities.getCurrent();
        this.fertNO3N.setValue(0.0);
        this.fertNH4N.setValue(0.0);
        this.fertorgNactive.setValue(0.0);
        this.fertorgNfresh.setValue(0.0);
        boolean runplantex = false;
        this.runNredu = 0.0;
        runplantex = this.plantExisting.getValue();
        ArrayList rotation = (ArrayList)entity.getObject("landuseRotation");
        int rotPos = this.RotPos.getValue();
        J2KSNCrop currentCrop = (J2KSNCrop)rotation.get(rotPos);
        int idc = currentCrop.idc;
        this.endbioN = currentCrop.endbioN;
        this.bion02 = currentCrop.bion02;
        this.bion04 = currentCrop.bion04;
        this.bion06 = currentCrop.bion06;
        this.bion08 = currentCrop.bion08;
        if (idc != 1 && idc != 2 && idc != 4 && idc != 5) {
            runplantex = true;
        }
        ArrayList<J2KSNLMArable> managementList = currentCrop.managementList;
        int managementPos = this.ManagementPos.getValue();
        J2KSNLMArable currentManagement = managementList.get(managementPos);
        int nextDay = currentManagement.jDay;
        this.doHarvest.setValue(false);
        if (nextDay - 1 == this.time.get(6) && currentManagement.harvest != -1) {
            this.doHarvest.setValue(true);
        }
        if (nextDay == this.time.get(6)) {
            if (managementPos + 1 == managementList.size()) {
                this.ManagementPos.setValue(0);
                int rotCount = rotation.size();
                rotPos = (rotPos + 1) % rotCount;
                this.RotPos.setValue(rotPos);
            } else {
                this.ManagementPos.setValue(managementPos + 1);
            }
            if (currentManagement.till == null) {
                if (currentManagement.fert != null) {
                    if (this.opti.getValue() != 2.0 || this.gift.getValue() == 0.0 && this.opti.getValue() == 2.0 || idc != 1 && idc != 2 && idc != 4 && idc != 5) {
                        this.processFertilization(currentManagement);
                        this.restfert.setValue(currentCrop.maxfert);
                    }
                } else if (currentManagement.plant) {
                    runplantex = true;
                } else if (currentManagement.harvest != -1 && (idc == 1 || idc == 2 || idc == 4 || idc == 5 || idc == 8)) {
                    runplantex = false;
                    this.harvesttype.setValue(1);
                    if (currentManagement.harvest == 2) {
                        this.harvesttype.setValue(2);
                        runplantex = true;
                    }
                }
            }
        }
        double day = this.time.get(6);
        if (this.opti.getValue() == 2.0 && day > 90.0 && day < 300.0 && this.gift.getValue() > 0.0 && (idc == 1 || idc == 2 || idc == 4 || idc == 5) && this.nstrs.getValue() > 0.03 && this.gift.getValue() < 4.0 && dayintervall < 1.0) {
            this.processFertilizationopti(currentManagement);
            dayintervall = 30.0;
        }
        this.plantExisting.setValue(runplantex);
        this.Nredu.setValue(this.runNredu);
        if (dayintervall > 0.0) {
            dayintervall -= 1.0;
        }
        this.Dayintervall.setValue(dayintervall);
    }

    private void processFertilization(J2KSNLMArable currentManagement) {
        double run_gift = this.gift.getValue();
        double fertN_total = 0.0;
        J2KSNFertilizer fert = currentManagement.fert;
        double redu = this.ReductionFactor.getValue();
        redu = this.time.after((Object)this.ti.getStart()) && this.time.before((Object)this.ti.getEnd()) ? Math.max(0.0, redu) : 1.0;
        double famount = currentManagement.famount * redu;
        fertN_total = famount * (double)(fert.fminn + fert.forgn);
        if (this.opti.getValue() == 1.0 && run_gift == 0.0 || this.opti.getValue() == 2.0 && run_gift == 0.0) {
            double actual_demand;
            double demand_factor = Math.min(Math.sqrt(this.FPHUact.getValue() + 0.15), 1.0);
            double future_demand = demand_factor * this.endbioN - this.optibioN.getValue();
            double total_demand = future_demand + (actual_demand = this.optibioN.getValue() - this.actbioN.getValue()) - this.nmin.getValue() + 30.0;
            redu = total_demand / fertN_total;
            if (redu < 0.0) {
                redu = 0.0;
            }
            redu = Math.min(redu, 1.0);
            this.runNredu = (1.0 - redu) * (double)(fert.forgn + fert.fminn) * famount;
            famount = redu * famount;
            fertN_total = famount * (double)(fert.fminn + fert.forgn);
        }
        this.gift.setValue(run_gift += 1.0);
        double fertNH4N = famount * (double)fert.fminn * (double)fert.fnh4n;
        double fertNO3N = famount * (double)fert.fminn * (double)(1.0f - fert.fnh4n);
        double fertorgNfresh = 0.5 * (double)fert.forgn * famount;
        double fertorgNactive = 0.5 * famount * (double)fert.forgn;
        this.fertNO3N.setValue(fertNO3N);
        this.fertNH4N.setValue(fertNH4N);
        this.fertorgNfresh.setValue(fertorgNfresh);
        this.fertorgNactive.setValue(fertorgNactive);
    }

    private void processFertilizationopti(J2KSNLMArable currentManagement) {
        double actual_demand;
        double demand_factor;
        double future_demand;
        double total_demand;
        double run_gift = this.gift.getValue();
        double run_restfert = this.restfert.getValue();
        double targetN = 0.0;
        double fertN_total = 0.0;
        double fertNH4 = 0.0;
        double fertNO3 = 0.0;
        double fertNactive = 0.0;
        double fertNfresh = 0.0;
        double famount = 0.0;
        double Namount = 0.0;
        double actsollbio = 0.0;
        if (run_gift == 0.0) {
            fertNH4 = 0.0099;
            fertNO3 = 1.0E-4;
            fertNactive = 0.015;
            fertNfresh = 0.015;
        } else if (run_gift < 3.0) {
            fertNH4 = 0.0;
            fertNO3 = 0.15;
            fertNactive = 0.0;
            fertNfresh = 0.0;
        } else if (run_gift == 3.0) {
            fertNH4 = 0.43;
            fertNO3 = 0.0;
            fertNactive = 0.0;
            fertNfresh = 0.0;
        }
        fertN_total = fertNH4 + fertNO3 + fertNactive + fertNfresh;
        if (this.FPHUact.getValue() > 0.0 && this.FPHUact.getValue() <= 0.2) {
            targetN = this.bion02 * this.FPHUact.getValue() / 0.2;
        } else if (this.FPHUact.getValue() > 0.2 && this.FPHUact.getValue() <= 0.4) {
            targetN = (this.bion04 - this.bion02) * this.FPHUact.getValue() / 0.4 + this.bion02;
        } else if (this.FPHUact.getValue() > 0.4 && this.FPHUact.getValue() <= 0.6) {
            targetN = (this.bion06 - this.bion04) * this.FPHUact.getValue() / 0.6 + this.bion04;
        } else if (this.FPHUact.getValue() > 0.6 && this.FPHUact.getValue() <= 0.8) {
            targetN = (this.bion08 - this.bion06) * this.FPHUact.getValue() / 0.8 + this.bion06;
        } else if (this.FPHUact.getValue() > 0.8 && this.FPHUact.getValue() <= 1.0) {
            targetN = (this.endbioN - this.bion08) * this.FPHUact.getValue() / 1.0 + this.bion08;
        }
        if (this.optibioN.getValue() < targetN) {
            this.endbioN -= targetN - this.optibioN.getValue();
        }
        if ((famount = (total_demand = (future_demand = (demand_factor = Math.min(Math.sqrt(this.FPHUact.getValue()) + 0.1, 1.0)) * this.endbioN - this.optibioN.getValue()) + (actual_demand = this.optibioN.getValue() - this.actbioN.getValue()) - this.nmin.getValue()) / fertN_total) < 0.0) {
            famount = 0.0;
        }
        Namount = famount * fertN_total;
        if (run_gift > 0.0 && !(Namount < run_restfert)) {
            Namount = run_restfert;
        }
        run_restfert -= Namount;
        famount = Namount / fertN_total;
        if (this.FPHUact.getValue() > 0.95) {
            famount = 0.0;
        }
        run_restfert = Math.max(run_restfert, 0.0);
        this.gift.setValue(run_gift += 1.0);
        double fertNH4N = famount * fertNH4;
        double fertNO3N = famount * fertNO3;
        double fertorgNfresh = famount * fertNfresh;
        double fertorgNactive = famount * fertNactive;
        this.restfert.setValue(run_restfert);
        this.fertNO3N.setValue(fertNO3N);
        this.fertNH4N.setValue(fertNH4N);
        this.fertorgNfresh.setValue(fertorgNfresh);
        this.fertorgNactive.setValue(fertorgNactive);
    }
}

