/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n.management;

import java.util.ArrayList;
import org.jams.j2k.s_n.crop.J2KSNCrop;
import org.jams.j2k.s_n.crop.J2KSNFertilizer;
import org.jams.j2k.s_n.crop.J2KSNLMArable;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;

public class ManageLanduse
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current hru object")
    public JAMSEntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Current NH4 fertilizer amount")
    public JAMSDouble fertNH4N;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Current NO3 fertilizer amount")
    public JAMSDouble fertNO3N;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Current organic fertilizer amount")
    public JAMSDouble fertorgNactive;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Current organic fertilizer amount")
    public JAMSDouble fertorgNfresh;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reduction Factor for Fertilisation 0 - 10 [-]")
    public JAMSDouble ReductionFactor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Current organic fertilizer amount")
    public JAMSInteger RotPos;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Current organic fertilizer amount")
    public JAMSInteger ManagementPos;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Plant exisiting or not")
    public JAMSBoolean plantExisting;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Indicator for harvesting")
    public JAMSBoolean doHarvest;

    public void run() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntity entity = this.entities.getCurrent();
        this.fertNO3N.setValue(0.0);
        this.fertNH4N.setValue(0.0);
        this.fertorgNactive.setValue(0.0);
        this.fertorgNfresh.setValue(0.0);
        ArrayList rotation = (ArrayList)entity.getObject("landuseRotation");
        int rotPos = this.RotPos.getValue();
        J2KSNCrop currentCrop = (J2KSNCrop)rotation.get(rotPos);
        int idc = currentCrop.idc;
        if (idc != 1 && idc != 2 && idc != 4 && idc != 5) {
            this.plantExisting.setValue(true);
        }
        ArrayList<J2KSNLMArable> managementList = currentCrop.managementList;
        int managementPos = this.ManagementPos.getValue();
        J2KSNLMArable currentManagement = managementList.get(managementPos);
        int nextDay = currentManagement.jDay;
        this.doHarvest.setValue(false);
        if (nextDay - 1 == this.time.get(6) && currentManagement.harvest != -1) {
            this.doHarvest.setValue(true);
        }
        if (nextDay == this.time.get(6)) {
            if (managementPos + 1 == managementList.size()) {
                this.ManagementPos.setValue(0);
                int rotCount = rotation.size();
                rotPos = (rotPos + 1) % rotCount;
                this.RotPos.setValue(rotPos);
            } else {
                this.ManagementPos.setValue(managementPos + 1);
            }
            if (currentManagement.till == null) {
                if (currentManagement.fert != null) {
                    this.processFertilization(currentManagement);
                } else if (currentManagement.plant) {
                    this.plantExisting.setValue(true);
                } else if (currentManagement.harvest != -1 && (idc == 1 || idc == 2 || idc == 4 || idc == 5)) {
                    this.plantExisting.setValue(false);
                }
            }
        }
    }

    private void processFertilization(J2KSNLMArable currentManagement) {
        J2KSNFertilizer fert = currentManagement.fert;
        double redu = this.ReductionFactor.getValue();
        redu = Math.max(0.0, redu);
        double famount = currentManagement.famount * redu;
        double fertN_total = famount * (double)fert.fminn;
        double fertNH4N = fertN_total * (double)fert.fnh4n;
        double fertNO3N = fertN_total - fertNH4N;
        double fertorgNfresh = 0.5 * (double)fert.forgn * famount;
        double fertorgNactive = 0.5 * famount * (double)fert.forgn;
        this.fertNO3N.setValue(fertNO3N);
        this.fertNH4N.setValue(fertNH4N);
        this.fertorgNfresh.setValue(fertorgNfresh);
        this.fertorgNactive.setValue(fertorgNactive);
    }
}

