/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n.init;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="initJ2KNSoil", author="Manfred Fink", description="intitiallizing Nitrogen Pools in Soil and additional variables. Method after SWAT2000")
public class InitJ2KNSoil
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in mm depth of soil layer")
    public JAMSDouble layerdepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in mm depth of soil profile")
    public JAMSDouble totaldepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="in kg/dm\u00c2\u00b3 soil bulk density")
    public JAMSDouble soil_bulk_density;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" in % organic Carbon in soil")
    public JAMSDouble C_org;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" NO3-Pool in kgN/ha")
    public JAMSDouble NO3_Pool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" NH4-Pool in kgN/ha")
    public JAMSDouble NH4_Pool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" N-Organic Pool with reactive organic matter in kgN/ha")
    public JAMSDouble N_activ_pool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" N-Organic Pool with stable organic matter in kgN/ha")
    public JAMSDouble N_stabel_pool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Residue in Layer in kgN/ha")
    public JAMSDouble Residue_pool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" N-Organic fresh Pool from Residue in kgN/ha")
    public JAMSDouble N_residue_pool_fresh;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" voltalisation rate from NH4_Pool in kgN/ha")
    public JAMSDouble Volati_trans;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" NH4 fertilizer rate in kgN/ha")
    public JAMSDouble NH4inp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" plantuptake rate in kgN/ha")
    public JAMSDouble PlantupN;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" nitrification rate from  NO3_Pool in kgN/ha")
    public JAMSDouble Nitri_trans;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" denitrification rate from  NO3_Pool in kgN/ha")
    public JAMSDouble Denit_trans;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in surface runoff in  in kgN/ha")
    public JAMSDouble SurfaceN;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in interflow in  in kgN/ha")
    public JAMSDouble InterflowN;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in percolation in  in kgN/ha")
    public JAMSDouble PercoN;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in surface runoff in  in kgN")
    public JAMSDouble SurfaceNabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in interflow in  in kgN")
    public JAMSDouble InterflowNabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in percolation in  in kgN")
    public JAMSDouble PercoNabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in surface runoff added to HRU layer in in kgN")
    public JAMSDouble SurfaceN_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in interflow in added to HRU layer in kgN")
    public JAMSDouble InterflowN_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in percolation in added to HRU layer in kgN")
    public JAMSDouble PercoN_in;
    private double runlayerdepth;
    private double runsoil_bulk_density;
    private double runC_org;
    private double runNO3_Pool;
    private double runNH4_Pool;
    private double runN_activ_pool;
    private double runN_stabel_pool;
    private double runN_residue_pool_fresh;
    private double runResidue_pool;
    private double runaEvap;
    private double runNH4inp;
    private double plantupN;
    private double surfaceN;
    private double interflowN;
    private double percoN;
    private double surfaceNabs;
    private double interflowNabs;
    private double percoNabs;
    private double surfaceN_in;
    private double interflowN_in;
    private double percoN_in;
    private double fr_actN = 0.02;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double orgNhum = 0.0;
        this.runC_org = this.C_org.getValue();
        this.runsoil_bulk_density = this.soil_bulk_density.getValue();
        this.runlayerdepth = this.layerdepth.getValue() * 100.0;
        this.runResidue_pool = 10.0;
        this.runNO3_Pool = 7.0 * Math.exp(-this.runlayerdepth / 1000.0) * this.runsoil_bulk_density * this.runlayerdepth / 100.0;
        this.runNH4_Pool = 0.1 * this.runNO3_Pool;
        orgNhum = 10000.0 * this.runC_org / 14.0;
        this.runN_activ_pool = orgNhum * this.fr_actN * this.runsoil_bulk_density * this.runlayerdepth / 100.0;
        this.runN_stabel_pool = orgNhum * (1.0 - this.fr_actN) * this.runsoil_bulk_density * this.runlayerdepth / 100.0;
        this.runN_residue_pool_fresh = 0.0015 * this.runResidue_pool;
        this.NO3_Pool.setValue(this.runNO3_Pool);
        this.NH4_Pool.setValue(this.runNH4_Pool);
        this.N_activ_pool.setValue(this.runN_activ_pool);
        this.N_stabel_pool.setValue(this.runN_stabel_pool);
        this.Residue_pool.setValue(this.runResidue_pool);
        this.N_residue_pool_fresh.setValue(this.runN_residue_pool_fresh);
        this.NH4inp.setValue(0.0);
        this.PlantupN.setValue(0.0);
        this.SurfaceN_in.setValue(0.0);
        this.InterflowN_in.setValue(0.0);
        this.PercoN_in.setValue(0.0);
        this.SurfaceNabs.setValue(0.0);
        this.InterflowNabs.setValue(0.0);
        this.PercoNabs.setValue(0.0);
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException {
    }
}

