/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n.crop;

import java.io.IOException;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

public class Heatunits
extends JAMSComponent {
    @JAMSComponentDescription(title="j2k_HeatUnits", author="Ulrike Bende-Michl", description="Module for calculation heat units")
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The current hru entity")
    public JAMSEntity entity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="start date of growing season")
    public JAMSDouble GRWstart;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="end date of growing season")
    public JAMSDouble GRWend;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU daily mean temperature [\u00c2\u00b0C]")
    public JAMSDouble Tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Plants base temperature required for growing[\u00c2\u00b0C]")
    public JAMSDouble Tbase;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Plants heat units sum to reach maturity [-]")
    public JAMSDouble PHU;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="Daily plants heat units sum [-]")
    public JAMSDouble PHUact;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="HRU fraction daily potential heat units")
    public JAMSDouble FPHUact;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="HRU half of annual potential heat units")
    public JAMSDouble PHU_50;
    private double phu_abs;
    private double phu_act;
    private double fphu_act;
    private double phu_50;
    private double phu_year;
    private double startdate;
    private double enddate;
    private double tmean;
    private double tbase;

    public void init() throws JAMSEntity.NoSuchAttributeException, IOException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        this.phu_abs = this.PHU.getValue();
        this.tmean = this.Tmean.getValue();
        this.tbase = this.Tbase.getValue();
        this.calc_dailyHU();
        this.PHUact.setValue(this.phu_act);
        this.FPHUact.setValue(this.fphu_act);
        this.PHU_50.setValue(this.phu_50);
    }

    private boolean calc_dailyHU() throws JAMSEntity.NoSuchAttributeException {
        if (this.startdate >= this.enddate) {
            double phu_delta = this.tmean - this.tbase;
            this.phu_act = phu_delta + (this.tmean - this.tbase);
        }
        this.fphu_act = this.phu_act / this.phu_abs;
        if (this.startdate <= this.enddate) {
            this.phu_act = this.phu_year;
            this.phu_50 = this.phu_year / 2.0;
        }
        return true;
    }
}

