/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KSoilTemplayer", author="Manfred Fink", description="Calculates soil temperature in diffrent depths")
public class J2KSoilTemplayer
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU attribute name area in m\u00c2\u00b2")
    public JAMSDouble area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in \u00c2\u00b0C daily max. temperature")
    public JAMSDouble atemp_max;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in \u00c2\u00b0C dayly min. temperature")
    public JAMSDouble atemp_min;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in \u00c2\u00b0C dayly mean. temperature")
    public JAMSDouble atemp_mean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in \u00c2\u00b0C anual mean temperature")
    public JAMSDouble anatemp_mean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in mm depth of soil layer")
    public JAMSDoubleArray layerdepth = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in mm depth of soil profile")
    public JAMSDouble totaldepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="number of layers in soil profile in [-]")
    public JAMSDouble Layer;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Soil bulk density in g/cm\u00c2\u00b3")
    public JAMSDoubleArray bulk_density_h = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Temperature lag coefficient perhaps to calibrate, typcal value 0.8, range  0 - 1")
    public JAMSDouble temp_lag;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="actual LPS in portion of sto_LPS soil water content")
    public JAMSDoubleArray Sat_LPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="actual MPS in portion of sto_MPS soil water content")
    public JAMSDoubleArray Sat_MPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="maximum MPS  in l soil water content")
    public JAMSDoubleArray stohru_MPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="maximum LPS  in l soil water content")
    public JAMSDoubleArray stohru_LPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="maximum FPS  in l soil water content")
    public JAMSDoubleArray stohru_FPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="snowcover in mm water aequivalent")
    public JAMSDouble snowcover;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="soilalbedo")
    public JAMSDouble soilalbedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="global radiation in MJ/(m\u00c2\u00b2*d)")
    public JAMSDouble radiation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="soil temperature in different layerdepths in \u00c2\u00b0C")
    public JAMSDoubleArray Soil_Temp_Layer = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="in \u00c2\u00b0C *  Output soil surface temperature")
    public JAMSDouble Surfacetemp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="in \u00c2\u00b0C *  Output soil average temperature")
    public JAMSDouble Soil_Tempaverage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="aboveground biomass in kg/ha")
    public JAMSDouble biomass;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" Residue in Layer in kgN/ha")
    public JAMSDoubleArray Residue_pool = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="switch for mulch drilling scenario")
    public JAMSDouble sceno;
    double[] Soiltemp_hor;
    double Soil_Temp;
    double Soil_Temp1;
    double surfacet;
    double radiat;
    double suml_depth;
    double total_depth;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double l_depth;
        int i;
        int layer = (int)this.Layer.getValue();
        double Soil_Temp_Sum = 0.0;
        double Soil_Temp_avg = 0.0;
        this.suml_depth = 0.0;
        this.total_depth = 0.0;
        this.Soiltemp_hor = this.Soil_Temp_Layer.getValue();
        for (i = 0; i < layer; ++i) {
            l_depth = this.layerdepth.getValue()[i] * 10.0;
            this.total_depth += l_depth;
        }
        this.radiat = this.radiation.getValue();
        for (i = 0; i < layer; ++i) {
            double runSoil_Temp_Layer;
            l_depth = this.layerdepth.getValue()[i] * 10.0;
            this.suml_depth += l_depth;
            this.Soil_Temp = this.Soiltemp_hor[i];
            if (i == 0) {
                this.Soil_Temp1 = this.Soil_Temp;
            }
            this.Soiltemp_hor[i] = runSoil_Temp_Layer = this.calc_Soil_Temp_Layer(i);
            Soil_Temp_Sum += runSoil_Temp_Layer;
        }
        Soil_Temp_avg = Soil_Temp_Sum / (double)layer;
        this.Soil_Tempaverage.setValue(Soil_Temp_avg);
        this.Soil_Temp_Layer.setValue(this.Soiltemp_hor);
    }

    private double calc_Soil_Temp_Layer(int i) throws JAMSEntity.NoSuchAttributeException {
        double temp_lag1 = this.temp_lag.getValue();
        double anavgtemp = this.anatemp_mean.getValue();
        double depthfactor = this.calc_Soil_Temp_Depth_Factor(i);
        double surfacetemp = this.calc_Soil_Surface_Temp();
        this.Soil_Temp = temp_lag1 * this.Soil_Temp + (1.0 - temp_lag1) * (depthfactor * (anavgtemp - surfacetemp) + surfacetemp);
        return this.Soil_Temp;
    }

    private double calc_water_content(int i) throws JAMSEntity.NoSuchAttributeException {
        double soilwater = 0.0;
        double area_ = this.area.getValue();
        double sto_LPS = this.stohru_LPS.getValue()[i] / area_;
        double sto_MPS = this.stohru_MPS.getValue()[i] / area_;
        double sto_FPS = 0.3 * sto_MPS;
        double act_LPS = sto_LPS * this.Sat_LPS.getValue()[i];
        double act_MPS = sto_MPS * this.Sat_MPS.getValue()[i];
        soilwater = act_LPS + act_MPS + sto_FPS;
        return soilwater;
    }

    private double calc_Soil_Temp_Depth_Factor(int i) throws JAMSEntity.NoSuchAttributeException {
        double dampingdepth = this.calc_Soil_Temp_Dampingdepth(i);
        double depthfactor = dampingdepth / (dampingdepth + Math.exp(-0.867 - 2.078 * dampingdepth));
        return depthfactor;
    }

    private double calc_Soil_Temp_Dampingdepth(int i) throws JAMSEntity.NoSuchAttributeException {
        double soil_bulk_dens = this.bulk_density_h.getValue()[i];
        double soilwater = this.calc_water_content(i);
        double dd_max = 1000.0 + 2500.0 * soil_bulk_dens / (soil_bulk_dens + 686.0 * Math.exp(-5.63 * soil_bulk_dens));
        double lamda = soilwater / ((0.356 - 0.144 * soil_bulk_dens) * this.total_depth);
        double dd = dd_max * Math.exp(Math.log(500.0 / dd_max) * ((1.0 - lamda) / (1.0 + lamda)) * ((1.0 - lamda) / (1.0 + lamda)));
        double dampingdepth = this.suml_depth / dd;
        return dampingdepth;
    }

    private double calc_Soil_Surface_Temp() throws JAMSEntity.NoSuchAttributeException {
        double snowcov = this.snowcover.getValue();
        double vegetationcover = this.biomass.getValue();
        if (this.sceno.getValue() == 1.0) {
            vegetationcover = this.biomass.getValue() + this.Residue_pool.getValue()[0];
        }
        double radiation = this.radiat / 1000.0;
        double epsilon_solar = (radiation * 0.8 - 14.0) / 20.0;
        double coverweightveg = vegetationcover / (vegetationcover + Math.exp(7.563 - 1.297E-4 * vegetationcover));
        double coverweightsnow = snowcov / (snowcov + Math.exp(6.055 - 0.3002 * snowcov));
        double coverweight = Math.max(coverweightveg, coverweightsnow);
        double temp_bare_soil = this.calc_Soil_Surface_Temp2();
        this.surfacet = coverweight * this.Soil_Temp1 + (1.0 - coverweight) * temp_bare_soil;
        this.Surfacetemp.setValue(this.surfacet);
        return this.surfacet;
    }

    private double calc_Soil_Surface_Temp2() throws JAMSEntity.NoSuchAttributeException {
        double temp_min = this.atemp_min.getValue();
        double temp_max = this.atemp_max.getValue();
        double albedofactor = 0.01;
        double temp_bare_soil = (1.0 - albedofactor) * (temp_min + (temp_max - temp_min) * Math.pow(0.03 * this.radiat, 0.5)) + this.surfacet * albedofactor;
        return temp_bare_soil;
    }

    public void cleanup() {
    }
}

