/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.geotools.resources.Arguments;
import org.geotools.resources.i18n.Descriptions;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Logging;
import org.geotools.resources.i18n.Vocabulary;

final class ResourceCompiler
implements Comparator {
    private static final String PROPERTIES_EXT = ".properties";
    private static final String RESOURCES_EXT = ".utf";
    private static final String ARGUMENT_COUNT_PREFIX = "_$";
    private final Map allocatedIDs = new HashMap();
    private final Map resources = new HashMap();
    private final PrintWriter out;

    private ResourceCompiler(PrintWriter out, Class bundleClass) throws IOException {
        this.out = out;
        try {
            String classname = ResourceCompiler.toKeyClass(bundleClass.getName());
            AccessibleObject[] fields = Class.forName(classname).getFields();
            out.print("Loading ");
            out.println(classname);
            Field.setAccessible(fields, true);
            int i = fields.length;
            while (--i >= 0) {
                AccessibleObject field = fields[i];
                String key = ((Field)field).getName();
                try {
                    Object ID = ((Field)field).get(null);
                    if (!(ID instanceof Integer)) continue;
                    this.allocatedIDs.put((Integer)ID, key);
                }
                catch (IllegalAccessException exception) {
                    File source = new File(classname.replace('.', '/') + ".class");
                    this.warning(source, key, "Access denied", exception);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static String toKeyClass(String bundleClass) {
        if (bundleClass.endsWith("s")) {
            bundleClass = bundleClass.substring(0, bundleClass.length() - 1);
        }
        return bundleClass + "Keys";
    }

    /*
     * WARNING - void declaration
     */
    private void loadPropertyFile(File file) throws IOException {
        FileInputStream input = new FileInputStream(file);
        Properties properties = new Properties();
        properties.load(input);
        ((InputStream)input).close();
        this.resources.clear();
        Iterator<Map.Entry<Object, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            int expected;
            void var9_12;
            int argumentCount;
            MessageFormat message;
            Map.Entry<Object, Object> entry = it.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.trim().length() == 0) {
                this.warning(file, key, "Empty key.", null);
                continue;
            }
            if (value.trim().length() == 0) {
                this.warning(file, key, "Empty value.", null);
                continue;
            }
            try {
                message = new MessageFormat(ResourceCompiler.toMessageFormatString(value));
            }
            catch (IllegalArgumentException exception) {
                this.warning(file, key, "Bad resource value", exception);
                continue;
            }
            int index = key.lastIndexOf(ARGUMENT_COUNT_PREFIX);
            if (index < 0) {
                argumentCount = 0;
                this.resources.put(key, value);
            } else {
                try {
                    String suffix = key.substring(index + ARGUMENT_COUNT_PREFIX.length());
                    argumentCount = Integer.parseInt(suffix);
                    this.resources.put(key, message.toPattern());
                }
                catch (NumberFormatException exception) {
                    this.warning(file, key, "Bad number in resource key", exception);
                    continue;
                }
            }
            if (var9_12 == (expected = message.getFormats().length)) continue;
            String suffix = ARGUMENT_COUNT_PREFIX + expected;
            this.warning(file, key, "Key name should ends with \"" + suffix + "\".", null);
        }
        String[] keys = this.resources.keySet().toArray(new String[this.resources.size()]);
        Arrays.sort(keys, this);
        int freeID = 0;
        for (int i = 0; i < keys.length; ++i) {
            Integer ID;
            String key = keys[i];
            if (this.allocatedIDs.containsValue(key)) continue;
            while (this.allocatedIDs.containsKey(ID = new Integer(freeID++))) {
            }
            this.allocatedIDs.put(ID, key);
        }
    }

    private void writeUTFFile(File file) throws IOException {
        int count = this.allocatedIDs.isEmpty() ? 0 : (Integer)Collections.max(this.allocatedIDs.keySet()) + 1;
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        out.writeInt(count);
        for (int i = 0; i < count; ++i) {
            String value = (String)this.resources.get(this.allocatedIDs.get(new Integer(i)));
            out.writeUTF(value != null ? value : "");
        }
        out.close();
    }

    private static String toMessageFormatString(String text) {
        int level = 0;
        int last = -1;
        StringBuffer buffer = new StringBuffer(text);
        block9: for (int i = 0; i < buffer.length(); ++i) {
            switch (buffer.charAt(i)) {
                case '{': {
                    ++level;
                    last = i;
                    continue block9;
                }
                case '}': {
                    --level;
                    last = i;
                    continue block9;
                }
                case '\'': {
                    if (i + 2 < buffer.length() && buffer.charAt(i + 2) == '\'') {
                        switch (buffer.charAt(i + 1)) {
                            case '{': {
                                i += 2;
                                continue block9;
                            }
                            case '}': {
                                i += 2;
                                continue block9;
                            }
                        }
                    }
                    if (level <= 0) {
                        buffer.insert(i++, '\'');
                        continue block9;
                    }
                    if (last < 0 || buffer.charAt(last) != '{') continue block9;
                    int scan = last;
                    while (scan < i) {
                        if (Character.isDigit(buffer.charAt(++scan))) continue;
                        String choice = ",choice,";
                        int end = scan + ",choice,".length();
                        if (end >= buffer.length() || !buffer.substring(scan, end).equalsIgnoreCase(",choice,")) continue block9;
                        buffer.insert(i++, '\'');
                        continue block9;
                    }
                    continue block9;
                }
            }
        }
        return buffer.toString();
    }

    private void warning(File file, String key, String message, Exception exception) {
        this.out.print("ERROR ");
        if (file != null) {
            String filename = file.getPath();
            if (filename.endsWith(PROPERTIES_EXT)) {
                filename = filename.substring(0, filename.length() - PROPERTIES_EXT.length());
            }
            this.out.print('(');
            this.out.print(filename);
            this.out.print(')');
        }
        this.out.print(": ");
        if (key != null) {
            this.out.print('\"');
            this.out.print(key);
            this.out.print('\"');
        }
        this.out.println();
        this.out.print(message);
        if (exception != null) {
            this.out.print(": ");
            this.out.print(exception.getLocalizedMessage());
        }
        this.out.println();
        this.out.println();
        this.out.flush();
    }

    private static void writeWhiteSpaces(Writer out, int count) throws IOException {
        while (--count >= 0) {
            out.write(32);
        }
    }

    private void writeJavaSource(Class bundleClass) throws IOException {
        String fullname = ResourceCompiler.toKeyClass(bundleClass.getName());
        String classname = fullname.substring(fullname.lastIndexOf(46) + 1);
        String packageName = fullname.substring(0, fullname.lastIndexOf(46));
        File file = new File(fullname.replace('.', '/') + ".java");
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        out.write("/*\n *    GeoTools - OpenSource mapping toolkit\n *    http://geotools.org\n *    (C) 2003-2006, Geotools Project Managment Committee (PMC)\n *    \n *    This library is free software; you can redistribute it and/or\n *    modify it under the terms of the GNU Lesser General Public\n *    License as published by the Free Software Foundation; either\n *    version 2.1 of the License, or (at your option) any later version.\n *    \n *    This library is distributed in the hope that it will be useful,\n *    but WITHOUT ANY WARRANTY; without even the implied warranty of\n *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n *    Lesser General Public License for more details.\n *    \n *    THIS IS AN AUTOMATICALLY GENERATED FILE. DO NOT EDIT!\n *    Generated with: org.geotools.resources.ResourceCompiler\n */\n");
        out.write("package ");
        out.write(packageName);
        out.write(";\n\n\n");
        out.write("/**\n * Resource keys. This class is used when compiling sources, but\n * no dependencies to {@code ResourceKeys} should appear in any\n * resulting class files.  Since Java compiler inlines final integer\n * values, using long identifiers will not bloat constant pools of\n * classes compiled against the interface, provided that no class\n * implements this interface.\n *\n * @see org.geotools.resources.ResourceBundle\n * @see org.geotools.resources.ResourceCompiler\n * @source $URL$\n */\n");
        out.write("public final class ");
        out.write(classname);
        out.write(" {\n");
        out.write("    private ");
        out.write(classname);
        out.write("() {\n");
        out.write("    }\n");
        out.write("\n");
        Map.Entry[] entries = this.allocatedIDs.entrySet().toArray(new Map.Entry[this.allocatedIDs.size()]);
        Arrays.sort(entries, this);
        int maxLength = 0;
        int i = entries.length;
        while (--i >= 0) {
            int length = ((String)entries[i].getValue()).length();
            if (length <= maxLength) continue;
            maxLength = length;
        }
        for (i = 0; i < entries.length; ++i) {
            String key = (String)entries[i].getValue();
            String ID = entries[i].getKey().toString();
            ResourceCompiler.writeWhiteSpaces(out, 4);
            out.write("public static final int ");
            out.write(key);
            ResourceCompiler.writeWhiteSpaces(out, maxLength - key.length());
            out.write(" = ");
            ResourceCompiler.writeWhiteSpaces(out, 5 - ID.length());
            out.write(ID);
            out.write(";\n");
        }
        out.write("}\n");
        out.close();
    }

    public int compare(Object o1, Object o2) {
        if (o1 instanceof Map.Entry) {
            o1 = ((Map.Entry)o1).getValue();
        }
        if (o2 instanceof Map.Entry) {
            o2 = ((Map.Entry)o2).getValue();
        }
        String key1 = (String)o1;
        String key2 = (String)o2;
        return key1.compareTo(key2);
    }

    private static void scanForResources(PrintWriter out, Class bundleClass) throws IOException {
        String classname = bundleClass.getName();
        File directory = new File(classname.replace('.', '/')).getParentFile();
        if (!directory.isDirectory()) {
            out.print('\"');
            out.print(directory.getPath());
            out.println("\" is not a directory.");
            return;
        }
        classname = classname.substring(classname.lastIndexOf(46) + 1);
        ResourceCompiler compiler = null;
        File[] content = directory.listFiles();
        for (int i = 0; i < content.length; ++i) {
            File file = content[i];
            String filename = file.getName();
            if (!filename.startsWith(classname) || !filename.endsWith(PROPERTIES_EXT)) continue;
            if (compiler == null) {
                compiler = new ResourceCompiler(out, bundleClass);
            }
            compiler.loadPropertyFile(file);
            String path = file.getPath();
            path = path.substring(0, path.length() - PROPERTIES_EXT.length()) + RESOURCES_EXT;
            compiler.writeUTFFile(new File(path));
        }
        if (compiler != null) {
            super.writeJavaSource(bundleClass);
        }
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        PrintWriter out = arguments.out;
        args = arguments.getRemainingArguments(0);
        if (args.length == 0) {
            args = new String[]{Descriptions.class.getName(), Vocabulary.class.getName(), Logging.class.getName(), Errors.class.getName()};
        }
        for (int i = 0; i < args.length; ++i) {
            try {
                ResourceCompiler.scanForResources(out, Class.forName(args[i]));
                continue;
            }
            catch (ClassNotFoundException exception) {
                out.println(exception.getLocalizedMessage());
                continue;
            }
            catch (IOException exception) {
                out.println(exception.getLocalizedMessage());
            }
        }
        out.flush();
    }
}

