/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.util.Collection;
import java.util.List;
import javax.units.NonSI;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.StereographicEquatorial;
import org.geotools.referencing.operation.projection.StereographicOblique;
import org.geotools.referencing.operation.projection.StereographicPolar;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;

public abstract class Stereographic
extends MapProjection {
    protected static final short EPSG = 0;
    protected static final short USGS = 1;
    protected static final short POLAR_A = 2;
    protected static final short POLAR_B = 3;
    protected static final short POLAR_NORTH = 4;
    protected static final short POLAR_SOUTH = 5;
    protected short stereoType;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$opengis$referencing$operation$PlanarProjection;

    Stereographic(ParameterValueGroup parameters, Collection expected) throws ParameterNotFoundException {
        super(parameters, expected);
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        switch (this.stereoType) {
            case 0: {
                return Provider_Oblique.PARAMETERS;
            }
            case 1: {
                return Provider_USGS.PARAMETERS;
            }
            case 2: {
                return Provider_Polar_A.PARAMETERS;
            }
            case 3: {
                return Provider_Polar_B.PARAMETERS;
            }
            case 4: {
                return Provider_North_Pole.PARAMETERS;
            }
            case 5: {
                return Provider_South_Pole.PARAMETERS;
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    static {
        $assertionsDisabled = !Stereographic.class.desiredAssertionStatus();
    }

    public static final class Provider_USGS
    extends MapProjection.AbstractProvider {
        static final ParameterDescriptorGroup PARAMETERS = Provider_USGS.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Stereographic"), new NamedIdentifier(Citations.GEOTIFF, "CT_Stereographic"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(159))}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider_USGS() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$PlanarProjection == null ? (class$org$opengis$referencing$operation$PlanarProjection = Stereographic.class$("org.opengis.referencing.operation.PlanarProjection")) : class$org$opengis$referencing$operation$PlanarProjection;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            double latitudeOfOrigin = Math.abs(Provider_USGS.doubleValue(LATITUDE_OF_ORIGIN, parameters));
            List descriptors = PARAMETERS.descriptors();
            if (Provider_USGS.isSpherical(parameters)) {
                if (Math.abs(latitudeOfOrigin - 1.5707963267948966) < 1.0E-6) {
                    return new StereographicPolar.Spherical(parameters, descriptors, Double.NaN, 1);
                }
                if (latitudeOfOrigin < 1.0E-6) {
                    return new StereographicEquatorial.Spherical(parameters, descriptors, 1);
                }
                return new StereographicOblique.Spherical(parameters, descriptors, 1);
            }
            if (Math.abs(latitudeOfOrigin - 1.5707963267948966) < 1.0E-6) {
                return new StereographicPolar(parameters, descriptors, Double.NaN, 1);
            }
            if (latitudeOfOrigin < 1.0E-6) {
                return new StereographicEquatorial(parameters, descriptors, 1);
            }
            return new StereographicOblique(parameters, descriptors, 1);
        }
    }

    public static final class Provider_South_Pole
    extends Provider_North_Pole {
        static final ParameterDescriptorGroup PARAMETERS = Provider_South_Pole.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Stereographic_South_Pole"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(159))}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_TRUE_SCALE, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider_South_Pole() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$PlanarProjection == null ? (class$org$opengis$referencing$operation$PlanarProjection = Stereographic.class$("org.opengis.referencing.operation.PlanarProjection")) : class$org$opengis$referencing$operation$PlanarProjection;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            List descriptors = PARAMETERS.descriptors();
            if (Provider_South_Pole.isSpherical(parameters)) {
                return new StereographicPolar.Spherical(parameters, descriptors, -1.5707963267948966, 5);
            }
            return new StereographicPolar(parameters, descriptors, -1.5707963267948966, 5);
        }
    }

    public static class Provider_North_Pole
    extends Provider_Polar_B {
        static final ParameterDescriptorGroup PARAMETERS = Provider_North_Pole.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Stereographic_North_Pole"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(159))}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_TRUE_SCALE, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider_North_Pole() {
            super(PARAMETERS);
        }

        protected Provider_North_Pole(ParameterDescriptorGroup params) {
            super(params);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$PlanarProjection == null ? (class$org$opengis$referencing$operation$PlanarProjection = Stereographic.class$("org.opengis.referencing.operation.PlanarProjection")) : class$org$opengis$referencing$operation$PlanarProjection;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            List descriptors = PARAMETERS.descriptors();
            if (Provider_North_Pole.isSpherical(parameters)) {
                return new StereographicPolar.Spherical(parameters, descriptors, 1.5707963267948966, 4);
            }
            return new StereographicPolar(parameters, descriptors, 1.5707963267948966, 4);
        }
    }

    public static class Provider_Polar_B
    extends MapProjection.AbstractProvider {
        public static final ParameterDescriptor LATITUDE_TRUE_SCALE = Provider_Polar_B.createOptionalDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Standard_Parallel_1"), new NamedIdentifier(Citations.EPSG, "Latitude of standard parallel")}, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = Provider_Polar_B.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "Polar Stereographic (variant B)"), new NamedIdentifier(Citations.EPSG, "9829"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(159))}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_TRUE_SCALE, FALSE_EASTING, FALSE_NORTHING});

        public Provider_Polar_B() {
            super(PARAMETERS);
        }

        protected Provider_Polar_B(ParameterDescriptorGroup params) {
            super(params);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$PlanarProjection == null ? (class$org$opengis$referencing$operation$PlanarProjection = Stereographic.class$("org.opengis.referencing.operation.PlanarProjection")) : class$org$opengis$referencing$operation$PlanarProjection;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            double latitudeTrueScale = Provider_Polar_B.doubleValue(LATITUDE_TRUE_SCALE, parameters);
            double latitudeOfOrigin = latitudeTrueScale < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
            List descriptors = PARAMETERS.descriptors();
            if (Provider_Polar_B.isSpherical(parameters)) {
                return new StereographicPolar.Spherical(parameters, descriptors, latitudeOfOrigin, 3);
            }
            return new StereographicPolar.Series(parameters, descriptors, latitudeOfOrigin, 3);
        }
    }

    public static final class Provider_Polar_A
    extends MapProjection.AbstractProvider {
        static final ParameterDescriptorGroup PARAMETERS = Provider_Polar_A.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Polar_Stereographic"), new NamedIdentifier(Citations.EPSG, "Polar Stereographic (variant A)"), new NamedIdentifier(Citations.EPSG, "9810"), new NamedIdentifier(Citations.GEOTIFF, "CT_PolarStereographic"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(159))}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider_Polar_A() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$PlanarProjection == null ? (class$org$opengis$referencing$operation$PlanarProjection = Stereographic.class$("org.opengis.referencing.operation.PlanarProjection")) : class$org$opengis$referencing$operation$PlanarProjection;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            List descriptors = PARAMETERS.descriptors();
            if (Provider_Polar_A.isSpherical(parameters)) {
                return new StereographicPolar.Spherical(parameters, descriptors, Double.NaN, 2);
            }
            return new StereographicPolar.Series(parameters, descriptors, Double.NaN, 2);
        }
    }

    public static final class Provider_Oblique
    extends MapProjection.AbstractProvider {
        static final ParameterDescriptorGroup PARAMETERS = Provider_Oblique.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Oblique_Stereographic"), new NamedIdentifier(Citations.EPSG, "Oblique Stereographic"), new NamedIdentifier(Citations.EPSG, "Roussilhe"), new NamedIdentifier(Citations.EPSG, "9809"), new NamedIdentifier(Citations.GEOTIFF, "CT_ObliqueStereographic"), new NamedIdentifier(Citations.ESRI, "Double_Stereographic"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(159))}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider_Oblique() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$PlanarProjection == null ? (class$org$opengis$referencing$operation$PlanarProjection = Stereographic.class$("org.opengis.referencing.operation.PlanarProjection")) : class$org$opengis$referencing$operation$PlanarProjection;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            double latitudeOfOrigin = Math.abs(Provider_Oblique.doubleValue(LATITUDE_OF_ORIGIN, parameters));
            List descriptors = PARAMETERS.descriptors();
            if (Provider_Oblique.isSpherical(parameters)) {
                if (Math.abs(latitudeOfOrigin - 1.5707963267948966) < 1.0E-6) {
                    return new StereographicPolar.Spherical(parameters, descriptors, Double.NaN, 0);
                }
                if (latitudeOfOrigin < 1.0E-6) {
                    return new StereographicEquatorial.Spherical(parameters, descriptors, 0);
                }
                return new StereographicOblique.Spherical(parameters, descriptors, 0);
            }
            if (Math.abs(latitudeOfOrigin - 1.5707963267948966) < 1.0E-6) {
                return new StereographicPolar(parameters, descriptors, Double.NaN, 0);
            }
            return new StereographicOblique.EPSG(parameters, descriptors, 0);
        }
    }
}

