/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.distribution;

import java.util.Date;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.resources.Utilities;
import org.opengis.metadata.distribution.StandardOrderProcess;
import org.opengis.util.InternationalString;

public class StandardOrderProcessImpl
extends MetadataEntity
implements StandardOrderProcess {
    private static final long serialVersionUID = -6503378937452728631L;
    private InternationalString fees;
    private long plannedAvailableDateTime = Long.MIN_VALUE;
    private InternationalString orderingInstructions;
    private InternationalString turnaround;

    public InternationalString getFees() {
        return this.fees;
    }

    public synchronized void setFees(InternationalString newValue) {
        this.checkWritePermission();
        this.fees = newValue;
    }

    public synchronized Date getPlannedAvailableDateTime() {
        return this.plannedAvailableDateTime != Long.MIN_VALUE ? new Date(this.plannedAvailableDateTime) : null;
    }

    public synchronized void setPlannedAvailableDateTime(Date newValue) {
        this.checkWritePermission();
        this.plannedAvailableDateTime = newValue != null ? newValue.getTime() : Long.MIN_VALUE;
    }

    public InternationalString getOrderingInstructions() {
        return this.orderingInstructions;
    }

    public synchronized void setOrderingInstructions(InternationalString newValue) {
        this.checkWritePermission();
        this.orderingInstructions = newValue;
    }

    public InternationalString getTurnaround() {
        return this.turnaround;
    }

    public synchronized void setTurnaround(InternationalString newValue) {
        this.checkWritePermission();
        this.turnaround = newValue;
    }

    protected void freeze() {
        super.freeze();
        this.fees = (InternationalString)StandardOrderProcessImpl.unmodifiable(this.fees);
        this.orderingInstructions = (InternationalString)StandardOrderProcessImpl.unmodifiable(this.orderingInstructions);
        this.turnaround = (InternationalString)StandardOrderProcessImpl.unmodifiable(this.turnaround);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            StandardOrderProcessImpl that = (StandardOrderProcessImpl)object;
            return Utilities.equals(this.fees, that.fees) && this.plannedAvailableDateTime == that.plannedAvailableDateTime && Utilities.equals(this.orderingInstructions, that.orderingInstructions) && Utilities.equals(this.turnaround, that.turnaround);
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = 291466953;
        if (this.fees != null) {
            code ^= this.fees.hashCode();
        }
        if (this.orderingInstructions != null) {
            code ^= this.orderingInstructions.hashCode();
        }
        if (this.turnaround != null) {
            code ^= this.turnaround.hashCode();
        }
        return code;
    }

    public String toString() {
        return String.valueOf(this.orderingInstructions);
    }
}

