/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.predictionnet.kernels;

import org.unijena.predictionnet.kernels.Kernel;

public class TestKernel
extends Kernel {
    public TestKernel(int inputDim) {
        this.inputDim = inputDim;
        this.KernelParameterCount = inputDim + 1;
        this.parameterCount = inputDim + 1;
    }

    public double SqrDistance2(double[] x, double[] y) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double tmp = x[i] - y[i];
            sum += (tmp /= this.theta[i]) * tmp;
        }
        return sum;
    }

    @Override
    public double kernel(double[] x, double[] y, int index1, int index2) {
        double r = this.SqrDistance2(x, y);
        if (index1 == index2) {
            return Math.exp(-0.5 * r) + this.theta[this.KernelParameterCount - 1] * this.theta[this.KernelParameterCount - 1];
        }
        return Math.exp(-0.5 * r);
    }

    @Override
    public double dkernel(double[] x, double[] y, int d) {
        double r = this.SqrDistance2(x, y);
        double dr = (x[d] - y[d]) / this.theta[d];
        if (d == this.inputDim) {
            return 0.0;
        }
        return dr * dr * Math.exp(-0.5 * r) / this.theta[d];
    }
}

