/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.predictionnet;

import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSContext;
import org.unijena.jams.model.JAMSVarDescription;

public class CrossValidation
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSInteger k;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSEntity Data;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSEntity trainingData;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSEntity validationData;

    public void init() {
    }

    private void singleRun() {
        JAMSComponent comp;
        if (this.runEnumerator == null) {
            this.runEnumerator = this.getChildrenEnumerator();
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.init();
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.run();
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.cleanup();
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
    }

    public void run() {
        double[][] data = null;
        double[] predict = null;
        try {
            data = (double[][])this.Data.getObject("data");
            predict = (double[])this.Data.getObject("predict");
        }
        catch (Exception e) {
            System.out.println("Konnte Daten nicht finden!!" + e.toString());
        }
        System.out.println("Cross Validation");
        int N = data.length;
        int M = data[0].length;
        int d = N / this.k.getValue();
        if (d * this.k.getValue() != N) {
            ++d;
        }
        for (int i = 0; i < this.k.getValue(); ++i) {
            int trainCounter = 0;
            int valCounter = 0;
            System.out.println("Run " + (i + 1) + " of " + this.k.getValue());
            for (int j = 0; j < N; ++j) {
                if (j / d == i) {
                    ++valCounter;
                    continue;
                }
                ++trainCounter;
            }
            double[][] valData = new double[valCounter][];
            double[] valPredict = new double[valCounter];
            double[][] trainData = new double[trainCounter][];
            double[] trainPredict = new double[trainCounter];
            trainCounter = 0;
            valCounter = 0;
            for (int j = 0; j < N; ++j) {
                if (j / d == i) {
                    valData[valCounter] = data[j];
                    valPredict[valCounter] = predict[j];
                    ++valCounter;
                    continue;
                }
                trainData[trainCounter] = data[j];
                trainPredict[trainCounter] = predict[j];
                ++trainCounter;
            }
            this.trainingData.setObject("data", (Object)trainData);
            this.trainingData.setObject("predict", (Object)trainPredict);
            this.validationData.setObject("data", (Object)valData);
            this.validationData.setObject("predict", (Object)valPredict);
            this.singleRun();
        }
    }
}

