/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.hydronet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import org.geotools.feature.Feature;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DefaultXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.unijena.hydronet.DistNeuron;
import org.unijena.hydronet.GenericFunction;
import org.unijena.hydronet.LinApprox;
import org.unijena.hydronet.Matrix;
import org.unijena.hydronet.NONeuron;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.data.JAMSStringArray;
import org.unijena.jams.model.JAMSVarDescription;

public class MapCreator
extends jams.components.gui.MapCreator {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Name of SLD-File containing layer style information")
    public JAMSString stylesFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="ID of a style in the SLD-File")
    public JAMSInteger styleID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Collection of hru objects")
    public JAMSEntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Name of hru attribute to add for mapping")
    public JAMSStringArray showAttr;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Number of ranges for classification attribute")
    public JAMSStringArray numOfRanges;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Color shading the ranges")
    public JAMSStringArray rangeColor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Name of shapefile to add as a layer to the map")
    public JAMSString shapeFileName1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Name of shapefile to add as a layer to the map")
    public JAMSString shapeFileName2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Name of shapefile to add as a layer to the map")
    public JAMSString shapeFileName3;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Colors for extra shapefiles")
    public JAMSStringArray shapeColors;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Original shape file name")
    public JAMSString baseShape;
    private JTextArea idfield;
    private JFreeChart chart;
    private XYPlot plot;
    private XYSeries dataset1;
    private JLabel InterflowWeight;
    private JLabel percolation_weight;
    private JButton downstreamID;
    private JLabel ist_input;
    private JLabel cur_input;

    public void run() throws Exception {
        ((jams.components.gui.MapCreator)this).hrus = this.hrus;
        ((jams.components.gui.MapCreator)this).stylesFileName = this.stylesFileName;
        ((jams.components.gui.MapCreator)this).styleID = this.styleID;
        ((jams.components.gui.MapCreator)this).dirName = this.dirName;
        ((jams.components.gui.MapCreator)this).showAttr = this.showAttr;
        ((jams.components.gui.MapCreator)this).numOfRanges = this.numOfRanges;
        ((jams.components.gui.MapCreator)this).rangeColor = this.rangeColor;
        ((jams.components.gui.MapCreator)this).shapeFileName1 = this.shapeFileName1;
        ((jams.components.gui.MapCreator)this).shapeFileName2 = this.shapeFileName2;
        ((jams.components.gui.MapCreator)this).shapeFileName3 = this.shapeFileName3;
        ((jams.components.gui.MapCreator)this).shapeColors = this.shapeColors;
        ((jams.components.gui.MapCreator)this).baseShape = this.baseShape;
        super.run();
        this.createPanel();
    }

    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        try {
            Feature f = this.getSelectedFeature();
            if (f != null) {
                this.ShowActFunction(new Double(f.getID()).intValue());
            }
        }
        catch (Exception e1) {
            this.getContext().getModel().getRuntime().println(e1.toString());
        }
    }

    protected void createPanel() {
        try {
            this.plot = new XYPlot();
            this.plot.setDomainAxis((ValueAxis)new NumberAxis("Nitrogen Input"));
            this.plot.setRangeAxis((ValueAxis)new NumberAxis("Nitrogen Output"));
            this.chart = new JFreeChart((Plot)this.plot);
            this.dataset1 = new XYSeries((Comparable)((Object)"Activation - Function"));
            this.plot.setDataset(0, (XYDataset)new XYSeriesCollection(this.dataset1));
            this.plot.setRenderer(0, (XYItemRenderer)new DefaultXYItemRenderer());
            JFrame frame = new JFrame("Activation - Function");
            frame.setDefaultCloseOperation(3);
            frame.getContentPane().setLayout(new BorderLayout());
            frame.getContentPane().add((Component)new ChartPanel(this.chart), "Center");
            JPanel panel = new JPanel(new FlowLayout());
            this.idfield = new JTextArea(1, 40);
            this.idfield.setEditable(true);
            panel.add((Component)this.idfield, "West");
            JButton bShow = new JButton("Show");
            JLabel label1 = new JLabel("Interflow - Weight: ");
            JLabel label2 = new JLabel("Percolation - Weight: ");
            JLabel label3 = new JLabel("DownstreamID: ");
            JLabel label4 = new JLabel("Input (old): ");
            JLabel label5 = new JLabel("Input (new): ");
            this.InterflowWeight = new JLabel();
            this.percolation_weight = new JLabel();
            this.downstreamID = new JButton("-");
            this.downstreamID.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        MapCreator.this.ShowActFunction(new Integer(MapCreator.this.downstreamID.getText()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.ist_input = new JLabel();
            this.cur_input = new JLabel();
            JPanel infopanel = new JPanel(new SpringLayout());
            infopanel.add(label1);
            infopanel.add(this.InterflowWeight);
            infopanel.add(label2);
            infopanel.add(this.percolation_weight);
            infopanel.add(label3);
            infopanel.add(this.downstreamID);
            infopanel.add(label4);
            infopanel.add(this.ist_input);
            infopanel.add(label5);
            infopanel.add(this.cur_input);
            MapCreator.makeCompactGrid(infopanel, 5, 2, 6, 6, 6, 6);
            bShow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        MapCreator.this.ShowActFunction(new Integer(MapCreator.this.idfield.getText()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            panel.add((Component)bShow, "East");
            frame.getContentPane().add((Component)panel, "South");
            frame.getContentPane().add((Component)infopanel, "East");
            frame.setBounds(50, 50, 800, 500);
            frame.setVisible(true);
        }
        catch (Exception e) {
            this.getContext().getModel().getRuntime().println(e.toString());
        }
    }

    void ShowActFunction(int id) throws Exception {
        JAMSEntity e = null;
        for (int i = 0; i < this.hrus.getEntities().size() && (e = (JAMSEntity)this.hrus.getEntities().get(i)).getDouble("ID") != (double)id; ++i) {
        }
        if (e == null) {
            return;
        }
        NONeuron nitr_neuron = (NONeuron)e.getObject("NITROGEN_NEURON");
        GenericFunction f = nitr_neuron.getFilter(0);
        this.dataset1.clear();
        if (f.getFunction().getType() == 3) {
            Matrix M = ((LinApprox)f.getFunction()).getData();
            for (int i = 0; i < M.rows; ++i) {
                this.dataset1.add(M.element[i][0], M.element[i][1]);
            }
        }
        this.idfield.setText(new Integer(id).toString());
        this.InterflowWeight.setText(new Double(((NONeuron)e.getObject("NITROGEN_NEURON")).getDownstreamWeight()).toString());
        this.percolation_weight.setText(new Double(((NONeuron)e.getObject("NITROGEN_NEURON")).getOutputWeight()).toString());
        this.ist_input.setText(new Double(((DistNeuron)e.getObject("DIST_NEURON")).getInitalExternInput()).toString());
        this.cur_input.setText(new Double(((DistNeuron)e.getObject("DIST_NEURON")).getInput()).toString());
        this.downstreamID.setText(new Integer(new Double(e.getDouble("ID")).intValue()).toString());
    }

    private static SpringLayout.Constraints getConstraintsForCell(int row, int col, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }

    private static void makeCompactGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException exc) {
            System.err.println("The first argument to makeCompactGrid must use SpringLayout.");
            return;
        }
        Spring x = Spring.constant(initialX);
        for (int c = 0; c < cols; ++c) {
            int r;
            Spring width = Spring.constant(0);
            for (r = 0; r < rows; ++r) {
                width = Spring.max(width, MapCreator.getConstraintsForCell(r, c, parent, cols).getWidth());
            }
            for (r = 0; r < rows; ++r) {
                SpringLayout.Constraints constraints = MapCreator.getConstraintsForCell(r, c, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
        }
        Spring y = Spring.constant(initialY);
        for (int r = 0; r < rows; ++r) {
            int c;
            Spring height = Spring.constant(0);
            for (c = 0; c < cols; ++c) {
                height = Spring.max(height, MapCreator.getConstraintsForCell(r, c, parent, cols).getHeight());
            }
            for (c = 0; c < cols; ++c) {
                SpringLayout.Constraints constraints = MapCreator.getConstraintsForCell(r, c, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", y);
        pCons.setConstraint("East", x);
    }
}

