/*
 * Decompiled with CFR 0.152.
 */
package javax.units;

import java.io.Serializable;
import javax.units.ConversionException;
import javax.units.Converter;
import javax.units.DerivedUnit;
import javax.units.MultiplyConverter;
import javax.units.Unit;

public final class ProductUnit
extends DerivedUnit {
    private final Element[] _elements;
    private transient Unit _systemUnitCache;

    ProductUnit() {
        super(null);
        this._elements = new Element[0];
    }

    private ProductUnit(Element[] elementArray) {
        super(null);
        this._elements = elementArray;
    }

    static Unit getInstance(Element[] elementArray, Element[] elementArray2) {
        int n;
        int n2;
        Unit unit;
        int n3;
        Element[] elementArray3 = new Element[elementArray.length + elementArray2.length];
        int n4 = 0;
        for (n3 = 0; n3 < elementArray.length; ++n3) {
            int n5;
            unit = elementArray[n3]._unit;
            n2 = elementArray[n3]._pow;
            n = elementArray[n3]._root;
            int n6 = 0;
            int n7 = 1;
            for (n5 = 0; n5 < elementArray2.length; ++n5) {
                if (unit != elementArray2[n5]._unit) continue;
                n6 = elementArray2[n5]._pow;
                n7 = elementArray2[n5]._root;
                break;
            }
            n5 = n2 * n7 + n6 * n;
            int n8 = n * n7;
            if (n5 == 0) continue;
            int n9 = ProductUnit.gcd(Math.abs(n5), n8);
            elementArray3[n4++] = new Element(unit, n5 / n9, n8 / n9);
        }
        for (n3 = 0; n3 < elementArray2.length; ++n3) {
            unit = elementArray2[n3]._unit;
            n2 = 0;
            for (n = 0; n < elementArray.length; ++n) {
                if (unit != elementArray[n]._unit) continue;
                n2 = 1;
                break;
            }
            if (n2 != 0) continue;
            elementArray3[n4++] = elementArray2[n3];
        }
        if (n4 == 0) {
            return ONE;
        }
        if (n4 == 1 && elementArray3[0]._pow == elementArray3[0]._root) {
            return elementArray3[0]._unit;
        }
        Element[] elementArray4 = new Element[n4];
        for (int i = 0; i < n4; ++i) {
            elementArray4[i] = elementArray3[i];
        }
        return ProductUnit.getInstance(new ProductUnit(elementArray4));
    }

    static Unit getProductInstance(Unit unit, Unit unit2) {
        Element[] elementArray = unit instanceof ProductUnit ? ((ProductUnit)unit)._elements : new Element[]{new Element(unit, 1, 1)};
        Element[] elementArray2 = unit2 instanceof ProductUnit ? ((ProductUnit)unit2)._elements : new Element[]{new Element(unit2, 1, 1)};
        return ProductUnit.getInstance(elementArray, elementArray2);
    }

    static Unit getQuotientInstance(Unit unit, Unit unit2) {
        Element[] elementArray;
        Element[] elementArray2 = unit instanceof ProductUnit ? ((ProductUnit)unit)._elements : new Element[]{new Element(unit, 1, 1)};
        if (unit2 instanceof ProductUnit) {
            Element[] elementArray3 = ((ProductUnit)unit2)._elements;
            elementArray = new Element[elementArray3.length];
            for (int i = 0; i < elementArray3.length; ++i) {
                elementArray[i] = new Element(elementArray3[i]._unit, -elementArray3[i]._pow, elementArray3[i]._root);
            }
        } else {
            elementArray = new Element[]{new Element(unit2, -1, 1)};
        }
        return ProductUnit.getInstance(elementArray2, elementArray);
    }

    static Unit getRootInstance(Unit unit, int n) {
        Element[] elementArray;
        if (unit instanceof ProductUnit) {
            Element[] elementArray2 = ((ProductUnit)unit)._elements;
            elementArray = new Element[elementArray2.length];
            for (int i = 0; i < elementArray2.length; ++i) {
                int n2 = ProductUnit.gcd(Math.abs(elementArray2[i]._pow), elementArray2[i]._root * n);
                elementArray[i] = new Element(elementArray2[i]._unit, elementArray2[i]._pow / n2, elementArray2[i]._root * n / n2);
            }
        } else {
            elementArray = new Element[]{new Element(unit, 1, n)};
        }
        return ProductUnit.getInstance(elementArray, new Element[0]);
    }

    static Unit getPowInstance(Unit unit, int n) {
        Element[] elementArray;
        if (unit instanceof ProductUnit) {
            Element[] elementArray2 = ((ProductUnit)unit)._elements;
            elementArray = new Element[elementArray2.length];
            for (int i = 0; i < elementArray2.length; ++i) {
                int n2 = ProductUnit.gcd(Math.abs(elementArray2[i]._pow * n), elementArray2[i]._root);
                elementArray[i] = new Element(elementArray2[i]._unit, elementArray2[i]._pow * n / n2, elementArray2[i]._root / n2);
            }
        } else {
            elementArray = new Element[]{new Element(unit, n, 1)};
        }
        return ProductUnit.getInstance(elementArray, new Element[0]);
    }

    public int size() {
        return this._elements.length;
    }

    public Element get(int n) {
        return this._elements[n];
    }

    public Unit getSystemUnit() {
        if (this._systemUnitCache == null) {
            Unit unit = ONE;
            for (int i = 0; i < this._elements.length; ++i) {
                Unit unit2 = this._elements[i]._unit.getSystemUnit();
                unit2 = unit2.pow(this._elements[i]._pow);
                unit2 = unit2.root(this._elements[i]._root);
                unit = unit.multiply(unit2);
            }
            this._systemUnitCache = unit;
        }
        return this._systemUnitCache;
    }

    public boolean equals(Object object) {
        Element[] elementArray;
        if (this == object) {
            return true;
        }
        if (object instanceof ProductUnit && this._elements.length == (elementArray = ((ProductUnit)object)._elements).length) {
            for (int i = 0; i < this._elements.length; ++i) {
                boolean bl = false;
                for (int j = 0; j < elementArray.length; ++j) {
                    if (this._elements[i]._unit != elementArray[j]._unit) continue;
                    if (this._elements[i]._pow != elementArray[j]._pow || this._elements[i]._root != elementArray[j]._root) {
                        return false;
                    }
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    int calculateHashCode() {
        int n = 0;
        for (int i = 0; i < this._elements.length; ++i) {
            n += this._elements[i]._unit.hashCode() * (this._elements[i]._pow * 3 - this._elements[i]._root * 2);
        }
        return n;
    }

    Unit getCtxDimension() {
        Unit unit = ONE;
        for (int i = 0; i < this._elements.length; ++i) {
            Unit unit2 = this._elements[i]._unit.getCtxDimension();
            unit2 = unit2.pow(this._elements[i]._pow);
            unit2 = unit2.root(this._elements[i]._root);
            unit = unit.multiply(unit2);
        }
        return unit;
    }

    Converter getCtxToDimension() {
        double d = 1.0;
        for (int i = 0; i < this._elements.length; ++i) {
            Converter converter = this._elements[i]._unit.getCtxToDimension();
            if (converter.isLinear()) {
                d *= Math.pow(converter.derivative(0.0), (double)this._elements[i]._pow / (double)this._elements[i]._root);
                continue;
            }
            throw new ConversionException(this._elements[i]._unit + " is non-linear, cannot convert");
        }
        if (Math.abs(d - 1.0) < 1.0E-9) {
            return Converter.IDENTITY;
        }
        return new MultiplyConverter(d);
    }

    private static int gcd(int n, int n2) {
        if (n2 == 0) {
            return n;
        }
        return ProductUnit.gcd(n2, n % n2);
    }

    public static final class Element
    implements Serializable {
        private final Unit _unit;
        private final int _pow;
        private final int _root;

        private Element(Unit unit, int n, int n2) {
            this._unit = unit;
            this._pow = n;
            this._root = n2;
        }

        public Unit getUnit() {
            return this._unit;
        }

        public int getPow() {
            return this._pow;
        }

        public int getRoot() {
            return this._root;
        }
    }
}

