/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import java.util.HashMap;
import org.unijena.j2k.J2KFunctions;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;

public class LayeredSoilParaReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Soil types parameter file name")
    public JAMSString stFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Collection of hru objects")
    public JAMSEntityCollection hrus;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntityCollection soilTypes = new JAMSEntityCollection();
        soilTypes.setEntities(J2KFunctions.readParas(this.dirName.getValue() + "/" + this.stFileName.getValue(), this.getModel()));
        HashMap<Double, JAMSEntity> stMap = new HashMap<Double, JAMSEntity>();
        for (JAMSEntity st : soilTypes.getEntities()) {
            stMap.put(st.getDouble("SID"), st);
        }
        for (JAMSEntity e : this.hrus.getEntities()) {
            double hruSID = e.getDouble("soilID") * 100.0 + 1.0;
            int horizon = 0;
            while (stMap.containsKey(hruSID)) {
                JAMSEntity st;
                Double hSID = new Double("" + hruSID);
                st = (JAMSEntity)stMap.get(hSID);
                e.setObject("soilHorizon", (Object)st);
                Object[] attrs = st.getKeys();
                for (int i = 0; i < attrs.length; ++i) {
                    Object o = st.getObject((String)attrs[i]);
                    if (o instanceof JAMSString) continue;
                    e.setObject((String)attrs[i] + "_h" + horizon, o);
                }
                hruSID += 1.0;
                ++horizon;
            }
            e.setDouble("horizons", (double)horizon);
        }
        this.getModel().getRuntime().println("Layered soil parameter file processed ...");
    }
}

