/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;

public class J2KTopologyCreator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Collection of hru objects")
    public JAMSEntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Collection of reach objects")
    public JAMSEntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Collection of reservoir objects")
    public JAMSEntityCollection reservoirs;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        this.createTopology();
        this.getModel().getRuntime().println("Create ordered hru-list", 1);
        this.createOrderedList(this.hrus, "to_poly");
        this.getModel().getRuntime().println("Create ordered reach-list", 1);
        this.createOrderedList(this.reaches, "to_reach");
        this.getModel().getRuntime().println("Entities read successfull!", 1);
    }

    protected boolean cycleCheck(JAMSEntity node, Stack<JAMSEntity> searchStack, HashSet<JAMSDouble> closedList, HashSet<JAMSDouble> visitedList) throws JAMSEntity.NoSuchAttributeException {
        if (searchStack.indexOf(node) != -1) {
            int index = searchStack.indexOf(node);
            String cyc_output = new String();
            for (int i = index; i < searchStack.size(); ++i) {
                cyc_output = cyc_output + ((JAMSEntity)searchStack.get(i)).getDouble("ID") + " ";
            }
            this.getModel().getRuntime().println("Found circle with ids:" + cyc_output);
            return true;
        }
        if (closedList.contains(node.getObject("ID"))) {
            return false;
        }
        visitedList.add((JAMSDouble)node.getObject("ID"));
        JAMSEntity child_node = (JAMSEntity)node.getObject("to_poly");
        if (child_node != null) {
            searchStack.push(node);
            boolean result = this.cycleCheck(child_node, searchStack, closedList, visitedList);
            searchStack.pop();
            return result;
        }
        return false;
    }

    protected boolean cycleCheck() throws JAMSEntity.NoSuchAttributeException {
        HashSet<JAMSDouble> closedList = new HashSet<JAMSDouble>();
        HashSet<JAMSDouble> visitedList = new HashSet<JAMSDouble>();
        this.getModel().getRuntime().println("Cycle checking...");
        Iterator hruIterator = this.hrus.getEntities().iterator();
        boolean result = false;
        while (hruIterator.hasNext()) {
            JAMSEntity start_node = (JAMSEntity)hruIterator.next();
            if (closedList.contains(start_node.getObject("ID"))) continue;
            if (this.cycleCheck(start_node, new Stack<JAMSEntity>(), closedList, visitedList)) {
                result = true;
            }
            closedList.addAll(visitedList);
            visitedList.clear();
        }
        return result;
    }

    protected void createTopology() throws JAMSEntity.NoSuchAttributeException {
        HashMap<Double, JAMSEntity> hruMap = new HashMap<Double, JAMSEntity>();
        HashMap<Double, JAMSEntity> reachMap = new HashMap<Double, JAMSEntity>();
        HashMap<Double, JAMSEntity> reservoirMap = null;
        if (this.reservoirs != null) {
            reservoirMap = new HashMap<Double, JAMSEntity>();
        }
        for (JAMSEntity e : this.hrus.getEntities()) {
            hruMap.put(e.getDouble("ID"), e);
        }
        for (JAMSEntity e : this.reaches.getEntities()) {
            reachMap.put(e.getDouble("ID"), e);
        }
        if (this.reservoirs != null) {
            for (JAMSEntity e : this.reservoirs.getEntities()) {
                reservoirMap.put(e.getDouble("ID"), e);
            }
        }
        for (JAMSEntity e : this.hrus.getEntities()) {
            e.setObject("to_poly", hruMap.get(e.getDouble("to_poly")));
            e.setObject("to_reach", reachMap.get(e.getDouble("to_reach")));
            if (this.reservoirs == null) continue;
            try {
                e.setObject("to_reservoir", reservoirMap.get(e.getDouble("to_reservoir")));
            }
            catch (JAMSEntity.NoSuchAttributeException ex) {}
        }
        for (JAMSEntity e : this.reaches.getEntities()) {
            e.setObject("to_reach", reachMap.get(e.getDouble("to_reach")));
            if (this.reservoirs == null) continue;
            try {
                e.setObject("to_reservoir", reservoirMap.get(e.getDouble("to-reservoir")));
            }
            catch (JAMSEntity.NoSuchAttributeException ex) {}
        }
        if (this.getModel().getRuntime().getDebugLevel() >= 3) {
            if (this.cycleCheck()) {
                this.getModel().getRuntime().println("HRUs --> cycle found ... :( ");
            } else {
                this.getModel().getRuntime().println("HRUs --> no cycle found");
            }
        }
    }

    protected void createOrderedList(JAMSEntityCollection col, String asso) throws JAMSEntity.NoSuchAttributeException {
        int i;
        ArrayList<JAMSEntity> newList = new ArrayList<JAMSEntity>();
        HashMap<Object, Integer> depthMap = new HashMap<Object, Integer>();
        boolean mapChanged = true;
        Iterator hruIterator = col.getEntities().iterator();
        while (hruIterator.hasNext()) {
            depthMap.put(hruIterator.next(), new Integer(0));
        }
        int numHRUs = col.getEntities().size();
        int maxDepth = 0;
        while (mapChanged) {
            mapChanged = false;
            for (JAMSEntity e : col.getEntities()) {
                JAMSEntity f = (JAMSEntity)e.getObject(asso);
                if (f == null) continue;
                Integer eDepth = (Integer)depthMap.get(e);
                Integer fDepth = (Integer)depthMap.get(f);
                if (fDepth > eDepth) continue;
                depthMap.put(f, new Integer(fDepth + 1));
                mapChanged = true;
            }
        }
        maxDepth = 0;
        for (JAMSEntity e : col.getEntities()) {
            maxDepth = Math.max(maxDepth, (Integer)depthMap.get(e));
        }
        ArrayList alList = new ArrayList();
        for (i = 0; i <= maxDepth; ++i) {
            alList.add(new ArrayList());
        }
        for (JAMSEntity e : col.getEntities()) {
            int depth = (Integer)depthMap.get(e);
            ((ArrayList)alList.get(depth)).add(e);
        }
        for (i = 0; i <= maxDepth; ++i) {
            for (JAMSEntity e : (ArrayList)alList.get(i)) {
                newList.add(e);
            }
        }
        col.setEntities(newList);
    }
}

