/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="LinearTestModel", author="Peter Krause", description="A linear regression model, which can be used to test optimizer and efficiency calculation")
public class LinearTestModel
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="known intercept")
    public JAMSDouble paraAgoal;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="known gradient")
    public JAMSDouble paraBgoal;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="known intercept")
    public JAMSDouble paraCgoal;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="known gradient")
    public JAMSDouble paraDgoal;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="unknown intercept")
    public JAMSDouble paraA;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="unknown gradient")
    public JAMSDouble paraB;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="unknown intercept")
    public JAMSDouble paraC;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="unknown gradient")
    public JAMSDouble paraD;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="model output y")
    public JAMSDoubleArray yVal;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="real output y")
    public JAMSDoubleArray yValKnown;

    public void run() {
        double a = this.paraA.getValue();
        double b = this.paraB.getValue();
        double c = this.paraC.getValue();
        double d = this.paraD.getValue();
        double aFin = this.paraAgoal.getValue();
        double bFin = this.paraBgoal.getValue();
        double cFin = this.paraCgoal.getValue();
        double dFin = this.paraDgoal.getValue();
        double[] x = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        double[] y = new double[x.length];
        double[] yFin = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = a * Math.pow(x[i], 4.0) + b * Math.pow(x[i], 3.0) + c * x[i] + d;
            yFin[i] = aFin * Math.pow(x[i], 4.0) + bFin * Math.pow(x[i], 3.0) + cFin * x[i] + dFin;
        }
        this.yVal.setValue(y);
        this.yValKnown.setValue(yFin);
    }
}

