/*
 * Decompiled with CFR 0.152.
 */
package hymod;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Hymod01", author="Peter Krause", description="The HYMOD Model implemented based on the MatLab sourcesof Hoshin V. Gupta from 9/18/2005")
public class HymodCore
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="precipitation")
    public JAMSDouble precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="potential evapotranspiration")
    public JAMSDouble pet;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Max height of soil moisture accounting tank")
    public JAMSDouble cmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Distribution function shape parameter")
    public JAMSDouble bexp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Quick-slow split parameter")
    public JAMSDouble alpha;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Number of quickflow routing tanks")
    public JAMSDouble nq;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Quickflow routing tanks rate parameter")
    public JAMSDouble kq;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Slowflow routing tanks rate parameter")
    public JAMSDouble ks;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="Soil moisture accounting tank state contents")
    public JAMSDouble xcuz;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="Quickflow routing tanks state contents")
    public JAMSDouble xq;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="Slowflow routing tank state content")
    public JAMSDouble xs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Model computed upper zone soil moisture tank state contents")
    public JAMSDouble mxhuz;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Model computed upper zone soil moisture tank state contents")
    public JAMSDouble mxcuz;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Model computed quickflow tank states contents")
    public JAMSDoubleArray mxq;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Model computed slowflow tank state contentss")
    public JAMSDouble mxs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Model computed evapotranspiration flux")
    public JAMSDouble met;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Model computed precipitation excess flux")
    public JAMSDouble mov;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Model computed quickflow flux")
    public JAMSDouble mqq;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Model computed slowflow flux")
    public JAMSDouble mqs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Model computed total streamflow flux")
    public JAMSDouble mq;
    boolean firstDay = true;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        int n = (int)this.nq.getValue();
        if (n <= 1) {
            n = 1;
        }
        double[] stors = new double[n];
        this.mxq.setValue(stors);
        this.mxs.setValue(0.0);
        double cpar = this.cmax.getValue() / (1.0 + this.bexp.getValue());
        double huzIni = this.cmax.getValue() * (1.0 - Math.pow(1.0 - 0.0 / cpar, 1.0 / (1.0 + this.bexp.getValue())));
        this.mxhuz.setValue(huzIni);
        System.out.println("Init finished");
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        this.pdm();
        double input = this.alpha.getValue() * this.mov.getValue();
        int n = (int)this.nq.getValue();
        if (n <= 1) {
            n = 1;
        }
        double[] qOut = this.nash(input, n, this.kq.getValue(), this.mxq.getValue());
        double[] stor = new double[qOut.length - 1];
        for (int i = 0; i < stor.length; ++i) {
            stor[i] = qOut[i];
        }
        this.mxq.setValue(stor);
        this.mqq.setValue(qOut[stor.length]);
        input = (1.0 - this.alpha.getValue()) * this.mov.getValue();
        stor = new double[]{this.mxs.getValue()};
        double[] bOut = this.nash(input, 1, this.ks.getValue(), stor);
        this.mxs.setValue(bOut[0]);
        this.mqs.setValue(bOut[1]);
        this.mq.setValue(this.mqq.getValue() + this.mqs.getValue());
    }

    private void pdm() {
        double bpar = this.bexp.getValue() == 2.0 ? 1000000.0 : Math.log(1.0 - this.bexp.getValue() / 2.0) / Math.log(0.5);
        double cpar = this.cmax.getValue() / (1.0 + bpar);
        double cbeg = cpar * (1.0 - Math.pow(1.0 - this.mxhuz.getValue() / this.cmax.getValue(), 1.0 + bpar));
        double ov2 = Math.max(0.0, this.precip.getValue() + this.mxhuz.getValue() - this.cmax.getValue());
        double ppinf = this.precip.getValue() - ov2;
        double hint = Math.min(this.cmax.getValue(), ppinf + this.mxhuz.getValue());
        double cint = cpar * (1.0 - Math.pow(1.0 - hint / this.cmax.getValue(), 1.0 + bpar));
        double ov1 = Math.max(0.0, ppinf + cbeg - cint);
        this.mov.setValue(ov1 + ov2);
        this.met.setValue(Math.min(this.pet.getValue(), cint));
        this.mxcuz.setValue(cint - this.met.getValue());
        this.mxhuz.setValue(this.cmax.getValue() * (1.0 - Math.pow(1.0 - this.mxcuz.getValue() / cpar, 1.0 / (1.0 + bpar))));
    }

    public double[] nash(double inp, int n, double k, double[] stor) {
        double[] oo = new double[n];
        double[] xend = new double[n + 1];
        for (int i = 0; i < n; ++i) {
            try {
                oo[i] = k * stor[i];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println("ioofe");
            }
            xend[i] = stor[i] - oo[i];
            xend[i] = i == 0 ? xend[i] + inp : xend[i] + oo[i - 1];
        }
        xend[n] = oo[n - 1];
        return xend;
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException {
        this.mxs.setValue(0.0);
        this.firstDay = true;
    }
}

