/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.units.Unit;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.referencing.operation.transform.MathTransformProxy;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.util.GenericName;

public abstract class MathTransformProvider
extends DefaultOperationMethod {
    private static final long serialVersionUID = 7530475536803158473L;

    public MathTransformProvider(int sourceDimensions, int targetDimensions, ParameterDescriptorGroup parameters) {
        this(MathTransformProvider.toMap(parameters), sourceDimensions, targetDimensions, parameters);
    }

    public MathTransformProvider(Map properties, int sourceDimensions, int targetDimensions, ParameterDescriptorGroup parameters) {
        super(properties, sourceDimensions, targetDimensions, parameters);
    }

    private static Map toMap(IdentifiedObject parameters) {
        MathTransformProvider.ensureNonNull("parameters", parameters);
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("name", parameters.getName());
        properties.put("identifiers", parameters.getIdentifiers().toArray(EMPTY_IDENTIFIER_ARRAY));
        properties.put("alias", parameters.getAlias().toArray(EMPTY_ALIAS_ARRAY));
        return properties;
    }

    protected Class getOperationType() {
        return Operation.class;
    }

    protected abstract MathTransform createMathTransform(ParameterValueGroup var1) throws InvalidParameterNameException, ParameterNotFoundException, InvalidParameterValueException, FactoryException;

    protected static ParameterDescriptor createDescriptor(Identifier[] identifiers, double defaultValue, double minimum, double maximum, Unit unit) {
        return new DefaultParameterDescriptor(MathTransformProvider.toMap(identifiers), defaultValue, minimum, maximum, unit, true);
    }

    protected static ParameterDescriptor createOptionalDescriptor(Identifier[] identifiers, double minimum, double maximum, Unit unit) {
        return new DefaultParameterDescriptor(MathTransformProvider.toMap(identifiers), Double.NaN, minimum, maximum, unit, false);
    }

    protected static ParameterDescriptorGroup createDescriptorGroup(Identifier[] identifiers, GeneralParameterDescriptor[] parameters) {
        return new DefaultParameterDescriptorGroup(MathTransformProvider.toMap(identifiers), parameters);
    }

    private static Map toMap(Identifier[] identifiers) {
        MathTransformProvider.ensureNonNull("identifiers", identifiers);
        if (identifiers.length == 0) {
            throw new IllegalArgumentException(Errors.format(33));
        }
        int idCount = 0;
        int aliasCount = 0;
        Object[] id = new Identifier[identifiers.length];
        Object[] alias = new GenericName[identifiers.length];
        for (int i = 0; i < identifiers.length; ++i) {
            Identifier candidate = identifiers[i];
            if (candidate instanceof GenericName) {
                alias[aliasCount++] = (GenericName)((Object)candidate);
                continue;
            }
            id[idCount++] = candidate;
        }
        id = (Identifier[])XArray.resize(id, idCount);
        alias = (GenericName[])XArray.resize(alias, aliasCount);
        HashMap<String, Object> properties = new HashMap<String, Object>(4, 0.8f);
        properties.put("name", identifiers[0]);
        properties.put("identifiers", id);
        properties.put("alias", alias);
        return properties;
    }

    protected ParameterValueGroup ensureValidValues(ParameterValueGroup values) throws InvalidParameterNameException, InvalidParameterValueException {
        GeneralParameterDescriptor descriptor;
        ParameterDescriptorGroup parameters = this.getParameters();
        if (parameters.equals(descriptor = values.getDescriptor())) {
            return values;
        }
        ParameterValueGroup copy = (ParameterValueGroup)parameters.createValue();
        MathTransformProvider.copy(values, copy);
        return copy;
    }

    private static void copy(ParameterValueGroup values, ParameterValueGroup copy) throws InvalidParameterNameException, InvalidParameterValueException {
        Iterator it = values.values().iterator();
        while (it.hasNext()) {
            ParameterValue target;
            GeneralParameterValue value = (GeneralParameterValue)it.next();
            String name = value.getDescriptor().getName().getCode();
            if (value instanceof ParameterValueGroup) {
                GeneralParameterDescriptor descriptor = ((ParameterDescriptorGroup)copy.getDescriptor()).descriptor(name);
                if (descriptor instanceof ParameterDescriptorGroup) {
                    ParameterValueGroup groups = (ParameterValueGroup)descriptor.createValue();
                    MathTransformProvider.copy((ParameterValueGroup)value, groups);
                    values.groups(name).add(groups);
                    continue;
                }
                throw new InvalidParameterNameException(Errors.format(129, name), name);
            }
            ParameterValue source = (ParameterValue)value;
            try {
                target = copy.parameter(name);
            }
            catch (ParameterNotFoundException cause) {
                InvalidParameterNameException exception = new InvalidParameterNameException(Errors.format(129, name), name);
                exception.initCause(cause);
                throw exception;
            }
            Object v = source.getValue();
            Unit unit = source.getUnit();
            if (unit == null) {
                target.setValue(v);
                continue;
            }
            if (v instanceof Number) {
                target.setValue(((Number)v).doubleValue(), unit);
                continue;
            }
            if (v instanceof double[]) {
                target.setValue((double[])v, unit);
                continue;
            }
            throw new InvalidParameterValueException(Errors.format(42, name, v), name, v);
        }
    }

    private static ParameterValue getParameter(ParameterDescriptor param, ParameterValueGroup group) throws ParameterNotFoundException {
        String name = MathTransformProvider.getName(param, group.getDescriptor().getName().getAuthority());
        if (name == null) {
            name = param.getName().getCode();
        }
        if (param.getMinimumOccurs() != 0) {
            return group.parameter(name);
        }
        GeneralParameterDescriptor search = ((ParameterDescriptorGroup)group.getDescriptor()).descriptor(name);
        if (search instanceof ParameterDescriptor) {
            Iterator it = group.values().iterator();
            while (it.hasNext()) {
                GeneralParameterValue candidate = (GeneralParameterValue)it.next();
                if (!search.equals(candidate.getDescriptor())) continue;
                return (ParameterValue)candidate;
            }
        }
        return null;
    }

    protected static Object value(ParameterDescriptor param, ParameterValueGroup group) throws ParameterNotFoundException {
        ParameterValue value = MathTransformProvider.getParameter(param, group);
        return value != null ? value.getValue() : null;
    }

    protected static String stringValue(ParameterDescriptor param, ParameterValueGroup group) throws ParameterNotFoundException {
        ParameterValue value = MathTransformProvider.getParameter(param, group);
        return value != null ? value.stringValue() : null;
    }

    protected static int intValue(ParameterDescriptor param, ParameterValueGroup group) throws ParameterNotFoundException {
        ParameterValue value = MathTransformProvider.getParameter(param, group);
        return value != null ? value.intValue() : 0;
    }

    protected static double doubleValue(ParameterDescriptor param, ParameterValueGroup group) throws ParameterNotFoundException {
        Unit unit = param.getUnit();
        ParameterValue value = MathTransformProvider.getParameter(param, group);
        return value == null ? Double.NaN : (unit != null ? value.doubleValue(unit) : value.doubleValue());
    }

    protected String formatWKT(Formatter formatter) {
        Class type;
        if (Projection.class.isAssignableFrom(type = this.getOperationType())) {
            return super.formatWKT(formatter);
        }
        formatter.setInvalidWKT();
        return "OperationMethod";
    }

    protected static final class Delegate
    extends MathTransformProxy {
        public final OperationMethod method;

        public Delegate(MathTransform transform, OperationMethod method) {
            super(transform);
            this.method = method;
            MathTransformProvider.ensureNonNull("transform", transform);
            MathTransformProvider.ensureNonNull("method", method);
        }
    }
}

