/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.predictionnet.kernels;

import org.unijena.predictionnet.kernels.Kernel;

public class SimpleMatern
extends Kernel {
    public SimpleMatern(int inputDim) {
        this.inputDim = inputDim;
        this.parameterCount = 2;
        this.KernelParameterCount = 2;
    }

    public double SqrDistance2(double[] x, double[] y) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double tmp = x[i] - y[i];
            sum += tmp * tmp;
        }
        return sum;
    }

    @Override
    public double kernel(double[] x, double[] y, int index1, int index2) {
        double r = Math.sqrt(this.SqrDistance2(x, y));
        double noise = 0.0;
        if (index1 == index2) {
            noise = this.theta[1] * this.theta[1];
        }
        return (1.0 + 1.732 * r / this.theta[0]) * Math.exp(-1.732 * r / this.theta[0]) + noise;
    }

    @Override
    public double dkernel(double[] x, double[] y, int d) {
        return 0.0;
    }
}

