/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.routing;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Title", author="Author", description="Description")
public class J2KProcessNullReachRouting
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The current hru entity")
    public JAMSEntity entity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD1 inflow")
    public JAMSDouble inRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD2 inflow")
    public JAMSDouble inRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG1 inflow")
    public JAMSDouble inRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG2 inflow")
    public JAMSDouble inRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD1 outflow")
    public JAMSDouble outRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD2 outflow")
    public JAMSDouble outRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG1 outflow")
    public JAMSDouble outRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG2 outflow")
    public JAMSDouble outRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar simulated Runoff")
    public JAMSDouble simRunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD1 storage")
    public JAMSDouble actRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD2 storage")
    public JAMSDouble actRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG1 storage")
    public JAMSDouble actRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG2 storage")
    public JAMSDouble actRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Channel storage")
    public JAMSDouble channelStorage;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double RG2DestIn;
        double RG1DestIn;
        double RD2DestIn;
        double RD1DestIn;
        JAMSEntity DestReach = (JAMSEntity)this.entity.getObject("to_reach");
        double RD1act = this.actRD1.getValue() + this.inRD1.getValue();
        double RD2act = this.actRD2.getValue() + this.inRD2.getValue();
        double RG1act = this.actRG1.getValue() + this.inRG1.getValue();
        double RG2act = this.actRG2.getValue() + this.inRG2.getValue();
        this.inRD1.setValue(0.0);
        this.inRD2.setValue(0.0);
        this.inRG1.setValue(0.0);
        this.inRG2.setValue(0.0);
        this.actRD1.setValue(0.0);
        this.actRD2.setValue(0.0);
        this.actRG1.setValue(0.0);
        this.actRG2.setValue(0.0);
        if (this.entity.getObject("to_reach") == null) {
            RD1DestIn = 0.0;
            RD2DestIn = 0.0;
            RG1DestIn = 0.0;
            RG2DestIn = 0.0;
        } else {
            RD1DestIn = DestReach.getDouble("inRD1");
            RD2DestIn = DestReach.getDouble("inRD2");
            RG1DestIn = DestReach.getDouble("inRG1");
            RG2DestIn = DestReach.getDouble("inRG2");
        }
        double RD1out = RD1act;
        double RD2out = RD2act;
        double RG1out = RG1act;
        double RG2out = RG2act;
        RD1DestIn += RD1out;
        RD2DestIn += RD2out;
        RG1DestIn += RG1out;
        RG2DestIn += RG2out;
        RD1act = 0.0;
        RD2act = 0.0;
        RG1act = 0.0;
        RG2act = 0.0;
        double channelStorage = RD1act + RD2act + RG1act + RG2act;
        double cumOutflow = RD1out + RD2out + RG1out + RG2out;
        this.simRunoff.setValue(cumOutflow);
        this.channelStorage.setValue(channelStorage);
        this.inRD1.setValue(0.0);
        this.inRD2.setValue(0.0);
        this.inRG1.setValue(0.0);
        this.inRG2.setValue(0.0);
        this.actRD1.setValue(RD1act);
        this.actRD2.setValue(RD2act);
        this.actRG1.setValue(RG1act);
        this.actRG2.setValue(RG2act);
        this.outRD1.setValue(RD1out);
        this.outRD2.setValue(RD2out);
        this.outRG1.setValue(RG1out);
        this.outRG2.setValue(RG2out);
        if (this.entity.getObject("to_reach") != null) {
            DestReach.setDouble("inRD1", RD1DestIn);
            DestReach.setDouble("inRD2", RD2DestIn);
            DestReach.setDouble("inRG1", RG1DestIn);
            DestReach.setDouble("inRG2", RG2DestIn);
        }
    }

    public void cleanup() {
    }
}

