/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.radiation;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.unijena.j2k.mathematicalCalculations.MathematicalCalculations;
import org.unijena.j2k.physicalCalculations.HourlySolarRadiationCalculationMethods;
import org.unijena.j2k.physicalCalculations.SolarRadiationCalculationMethods;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="HourlySolarRadiation", author="Peter Krause", description="Calculates hourly solar radiation from standard climatological measurements")
public class CalcHourlySolarRadiation
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Workspace directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Use caching of regionalised data?")
    public JAMSBoolean dataCaching;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="latitude of entity")
    public JAMSDouble latitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable slope aspect correction factor")
    public JAMSDouble actSlAsCf;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable fraction of sunshine in one hour")
    public JAMSDouble sunFrac;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Angstrom factor a")
    public JAMSDouble angstrom_a;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Angstrom factor b")
    public JAMSDouble angstrom_b;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="hourly solar radiation [MJ/m\u00b2]")
    public JAMSDouble solRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="extraterrestic radiation [MJ/m\u00b2]")
    public JAMSDouble actExtRad;
    private File cacheFile;
    private boolean useCache = false;
    private ObjectOutputStream writer;
    private ObjectInputStream reader;

    public void init() throws JAMSEntity.NoSuchAttributeException, IOException {
        this.cacheFile = new File(this.dirName.getValue() + "/$" + this.getInstanceName() + ".cache");
        if (this.cacheFile.exists() || this.dataCaching.getValue()) {
            // empty if block
        }
        if (this.dataCaching.getValue()) {
            this.useCache = true;
            this.reader = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.cacheFile)));
        } else {
            this.useCache = false;
            this.writer = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.cacheFile)));
        }
    }

    public void run() throws JAMSEntity.NoSuchAttributeException, IOException {
        if (!this.useCache) {
            int oldjulDay = 0;
            int julDay = this.time.get(6);
            int idx = (julDay - 1) * 24 + this.time.get(11);
            double lat = this.latitude.getValue();
            double radLat = MathematicalCalculations.deg2rad(lat);
            double SAC = this.actSlAsCf.getValue();
            double declination = 0.0;
            double invRelDistEarthSun = 0.0;
            double solarConstant = 0.0;
            double sun_frac = this.sunFrac.getValue();
            if (julDay != oldjulDay) {
                declination = SolarRadiationCalculationMethods.calc_SunDeclination(julDay);
                invRelDistEarthSun = SolarRadiationCalculationMethods.calc_InverseRelativeDistanceEarthSun(julDay);
                solarConstant = SolarRadiationCalculationMethods.calc_SolarConstant(julDay);
                oldjulDay = julDay;
            }
            double longTZ = 15.0;
            double maximumSunshine = HourlySolarRadiationCalculationMethods.calc_HourlyMaxSunshine(this.actExtRad.getValue());
            double solRadiation = SolarRadiationCalculationMethods.calc_SolarRadiation(sun_frac, maximumSunshine, this.actExtRad.getValue(), this.angstrom_a.getValue(), this.angstrom_b.getValue());
            this.solRad.setValue(solRadiation *= SAC);
        } else {
            this.solRad.setValue(this.reader.readDouble());
        }
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException, IOException {
        if (!this.useCache) {
            this.writer.flush();
            this.writer.close();
        } else {
            this.reader.close();
        }
    }
}

