/*
 * Decompiled with CFR 0.152.
 */
package hymod;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Hymod02", author="Peter Krause", description="The HYMOD Model implemented based on the MatLab sourcesof Hoshin V. Gupta from 9/18/2005")
public class Hymod02
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="precipitation")
    public JAMSDouble precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="potential evapotranspiration")
    public JAMSDouble pet;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Max height of soil moisture accounting tank")
    public JAMSDouble huz;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Distribution function shape parameter")
    public JAMSDouble b;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Quick-slow split parameter")
    public JAMSDouble alp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Number of quickflow routing tanks")
    public JAMSDouble nq;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Quickflow routing tanks rate parameter")
    public JAMSDouble kq;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Slowflow routing tanks rate parameter")
    public JAMSDouble ks;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="Soil moisture accounting tank state contents")
    public JAMSDouble xcuz;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="Quickflow routing tanks state contents")
    public JAMSDouble xq;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="Slowflow routing tank state content")
    public JAMSDouble xs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Model computed upper zone soil moisture tank state contents")
    public JAMSDouble mxhuz;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Model computed upper zone soil moisture tank state contents")
    public JAMSDouble mxcuz;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Model computed quickflow tank states contents")
    public JAMSDoubleArray mxq;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Model computed slowflow tank state contentss")
    public JAMSDouble mxs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Model computed evapotranspiration flux")
    public JAMSDouble met;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Model computed precipitation excess flux")
    public JAMSDouble mov;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Model computed quickflow flux")
    public JAMSDouble mqq;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Model computed slowflow flux")
    public JAMSDouble mqs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Model computed total streamflow flux")
    public JAMSDouble mq;
    boolean firstDay = true;
    int r_n = 0;
    double r_huz;
    double r_b;
    double r_alp;
    double r_mov;
    double r_kq;
    double r_ks;
    double r_mxs;
    double r_mqq;
    double r_precip;
    double r_pet;
    double r_mxhuz;
    double r_mxcuz;
    double r_met;
    double[] r_mxq;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        this.r_alp = this.alp.getValue();
        this.r_mov = this.mov.getValue();
        this.r_b = this.b.getValue();
        this.r_huz = this.huz.getValue();
        this.r_kq = this.kq.getValue();
        this.r_ks = this.ks.getValue();
        this.r_mxq = this.mxq.getValue();
        this.r_mxs = this.mxs.getValue();
        this.r_n = (int)this.nq.getValue();
        this.r_precip = this.precip.getValue();
        this.r_pet = this.pet.getValue();
        this.r_mxhuz = this.mxhuz.getValue();
        if (this.firstDay) {
            if (this.r_n <= 1) {
                this.r_n = 1;
            }
            this.r_mxq = new double[this.r_n];
            this.r_mxs = 0.0;
            double cpar = this.r_huz / (1.0 + this.r_b);
            this.r_mxhuz = this.r_huz * (1.0 - Math.pow(1.0 - 0.0 / cpar, 1.0 / (1.0 + this.r_b)));
            this.firstDay = false;
        }
        this.pdm();
        double input = this.r_alp * this.r_mov;
        if (this.r_n <= 1) {
            this.r_n = 1;
        }
        double[] qOut = this.nash(input, this.r_n, this.r_kq, this.r_mxq);
        double[] stor = new double[qOut.length - 1];
        for (int i = 0; i < stor.length; ++i) {
            stor[i] = qOut[i];
        }
        this.mxq.setValue(stor);
        this.mqq.setValue(qOut[stor.length]);
        double r_mqq = qOut[stor.length];
        input = (1.0 - this.r_alp) * this.r_mov;
        stor = new double[]{this.r_mxs};
        double[] bOut = this.nash(input, 1, this.r_ks, stor);
        this.mxs.setValue(bOut[0]);
        this.mqs.setValue(bOut[1]);
        this.mq.setValue(r_mqq + bOut[1]);
        this.mxhuz.setValue(this.r_mxhuz);
        this.met.setValue(this.r_met);
        this.mov.setValue(this.r_mov);
        this.mxcuz.setValue(this.r_mxcuz);
    }

    private void pdm() {
        double bpar = this.r_b == 2.0 ? 1000000.0 : Math.log(1.0 - this.r_b / 2.0) / Math.log(0.5);
        double cpar = this.r_huz / (1.0 + bpar);
        double cbeg = cpar * (1.0 - Math.pow(1.0 - this.r_mxhuz / this.r_huz, 1.0 + bpar));
        double ov2 = Math.max(0.0, this.r_precip + this.r_mxhuz - this.r_huz);
        double ppinf = this.r_precip - ov2;
        double hint = Math.min(this.r_huz, ppinf + this.r_mxhuz);
        double cint = cpar * (1.0 - Math.pow(1.0 - hint / this.r_huz, 1.0 + bpar));
        double ov1 = Math.max(0.0, ppinf + cbeg - cint);
        this.r_mov = ov1 + ov2;
        this.r_met = Math.min(this.r_pet, cint);
        this.r_mxcuz = cint - this.r_met;
        this.r_mxhuz = this.r_huz * (1.0 - Math.pow(1.0 - this.r_mxcuz / cpar, 1.0 / (1.0 + bpar)));
    }

    public double[] nash(double inp, int n, double k, double[] stor) {
        double[] oo = new double[n];
        double[] xend = new double[n + 1];
        for (int i = 0; i < n; ++i) {
            try {
                oo[i] = k * stor[i];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println("ioofe");
            }
            xend[i] = stor[i] - oo[i];
            xend[i] = i == 0 ? xend[i] + inp : xend[i] + oo[i - 1];
        }
        xend[n] = oo[n - 1];
        return xend;
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException {
        this.mxs.setValue(0.0);
        this.firstDay = true;
    }
}

