/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.hydronet;

import org.unijena.hydronet.CostNeuron;
import org.unijena.hydronet.NONeuron;
import org.unijena.hydronet.Neuron;

public class DistNeuron
extends Neuron {
    private NONeuron NitrNeuron = null;
    private CostNeuron CostNeuron = null;
    private double initialInput;
    private double lastDelta = 0.0;
    protected double minValue = Double.MIN_VALUE;
    protected double maxValue = Double.MAX_VALUE;
    static double eta = 1.0E-11;
    static double alpha = 0.0;

    public void setMinInput(double min) {
        this.minValue = min;
    }

    public void setMaxInput(double max) {
        this.maxValue = max;
    }

    public void setNitrNeuron(NONeuron NitrNeuron) {
        this.NitrNeuron = NitrNeuron;
    }

    public void setCostNeuron(CostNeuron CostNeuron2) {
        this.CostNeuron = CostNeuron2;
    }

    public void propagate() {
        if (this.NitrNeuron != null) {
            this.NitrNeuron.addToInput(this.input);
        }
        if (this.CostNeuron != null) {
            this.CostNeuron.addToInput(this.input);
        }
    }

    public void backpropagate() {
        this.calcDelta(this.NitrNeuron.getDelta() + this.CostNeuron.getDelta());
    }

    public double calc() {
        this.activation = this.input;
        return this.activation;
    }

    @Override
    public void reset() {
        this.input = 0.0;
    }

    public double calcDelta(double error) {
        return this.calcDelta(error, 1.0);
    }

    public double calcDelta(double error, double buffer) {
        this.delta = error;
        return this.delta;
    }

    public void setInitialExternInput(double value) {
        this.input = this.initialInput = value;
        if (this.CostNeuron != null) {
            this.CostNeuron.setInitialInput(value);
        } else {
            System.out.println("argggh distribution neuron without costneuron found!!");
        }
    }

    public double getInitalExternInput() {
        return this.initialInput;
    }

    public void modifyWeight() {
        this.lastDelta = eta * this.delta * this.input + alpha * this.lastDelta;
        this.input += this.lastDelta;
        if (this.input < this.minValue) {
            this.input = this.minValue;
        }
        if (this.input > this.maxValue) {
            this.input = this.maxValue;
        }
    }
}

