/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_salt_init;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="InitJ2KGroundwaterNaCl", author="Manfred Fink", description="intitiallizing groundwater NaCl module with two different NaCl-Pools")
public class InitJ2KGroundwaterNaCl
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="maximum RG1 storage")
    public JAMSDouble maxRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="maximum RG2 storage")
    public JAMSDouble maxRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual RG1 NaCl storage in kgNaCl")
    public JAMSDouble NaClActRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual RG2 N storage in kgNaCl")
    public JAMSDouble NaClActRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU Concentration in mgNaCl/l for RG1")
    public JAMSDouble NaCl_concRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU Concentration in mgNaCl/l for RG2")
    public JAMSDouble NaCl_concRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Relativ size of the groundwaterNaCl damping tank RG1 0 - 10 to calibrate in -")
    public JAMSDouble NaCl_delay_RG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Relativ size of the groundwaterNaCl damping tank RG2 0 - 10 to calibrate in -")
    public JAMSDouble NaCl_delay_RG2;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double iNaClActRG1 = this.maxRG1.getValue() * this.NaCl_concRG1.getValue() / 1000000.0 * this.NaCl_delay_RG1.getValue();
        double iNaClActRG2 = this.maxRG2.getValue() * this.NaCl_concRG2.getValue() / 1000000.0 * this.NaCl_delay_RG2.getValue();
        this.NaClActRG1.setValue(iNaClActRG1);
        this.NaClActRG2.setValue(iNaClActRG2);
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException {
    }
}

