/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n.init;

import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="InitJ2KNSoillayer", author="Manfred Fink", description="intitiallizing Nitrogen Pools in Soil and additional variables. Method after SWAT2000")
public class InitJ2KNSoillayer
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in cm depth of soil layer")
    public JAMSDoubleArray layerdepth = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="in kg/dm\u00c2\u00b3 soil bulk density")
    public JAMSDoubleArray soil_bulk_density = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" in % organic Carbon in soil")
    public JAMSDoubleArray C_org = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" NO3-Pool in kgN/ha")
    public JAMSDoubleArray NO3_Pool = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" NH4-Pool in kgN/ha")
    public JAMSDoubleArray NH4_Pool = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" N-Organic Pool with reactive organic matter in kgN/ha")
    public JAMSDoubleArray N_activ_pool = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" N-Organic Pool with stable organic matter in kgN/ha")
    public JAMSDoubleArray N_stabel_pool = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Residue in Layer in kgN/ha")
    public JAMSDoubleArray Residue_pool = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" N-Organic fresh Pool from Residue in kgN/ha")
    public JAMSDoubleArray N_residue_pool_fresh = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in interflow in added to HRU layer in kgN")
    public JAMSDoubleArray InterflowN_in = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate input due to Fertilisation in kgN/ha")
    public JAMSDouble fertNO3;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Ammonium input due to Fertilisation in kgN/ha")
    public JAMSDouble fertNH4;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Stable organig N input due to Fertilisation in kgN/ha")
    public JAMSDouble fertstableorg;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Activ organig N input due to Fertilisation in kgN/ha")
    public JAMSDouble fertactivorg;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Input of plant residues kg/ha")
    public JAMSDouble inp_biomass;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Nitrogen input of plant residues in kgN/ha")
    public JAMSDouble inpN_biomass;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="number of layers in soil profile in [-]")
    public JAMSDouble Layer;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="flag plant existing yes or no ")
    public JAMSBoolean plantExisting = new JAMSBoolean();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Actual rooting depth [m]")
    public JAMSDouble ZRootD;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual LAI")
    public JAMSDouble LAI;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double orgNhum = 0.0;
        int layer = (int)this.Layer.getValue();
        this.plantExisting.setValue(true);
        double hor_dept = 0.0;
        double[] NO3_Poolvals = new double[layer];
        double[] NH4_Poolvals = new double[layer];
        double[] N_activ_poolvals = new double[layer];
        double[] N_stabel_poolvals = new double[layer];
        double[] N_residue_pool_freshvals = new double[layer];
        double[] Residue_poolvals = new double[layer];
        double[] InterflowN_invals = new double[layer];
        double fr_actN = 0.02;
        for (int i = 0; i < layer; ++i) {
            double runC_org = this.C_org.getValue()[i] / 3.44;
            double runsoil_bulk_density = this.soil_bulk_density.getValue()[i];
            double runlayerdepth = this.layerdepth.getValue()[i] * 10.0;
            double runResidue_pool = 10.0;
            double runNO3_Pool = 7.0 * Math.exp(-(hor_dept += runlayerdepth) / 1000.0) * runsoil_bulk_density * runlayerdepth / 1000.0;
            double runNH4_Pool = 0.1 * runNO3_Pool;
            orgNhum = 10000.0 * runC_org / 14.0;
            double runN_activ_pool = orgNhum * fr_actN * runsoil_bulk_density * runlayerdepth / 100.0;
            double runN_stabel_pool = orgNhum * (1.0 - fr_actN) * runsoil_bulk_density * runlayerdepth / 100.0;
            double runN_residue_pool_fresh = 0.0015 * runResidue_pool;
            NO3_Poolvals[i] = runNO3_Pool;
            NH4_Poolvals[i] = runNH4_Pool;
            N_activ_poolvals[i] = runN_activ_pool;
            N_stabel_poolvals[i] = runN_stabel_pool;
            Residue_poolvals[i] = runResidue_pool;
            N_residue_pool_freshvals[i] = runN_residue_pool_fresh;
            InterflowN_invals[i] = 0.0;
        }
        this.NO3_Pool.setValue(NO3_Poolvals);
        this.NH4_Pool.setValue(NH4_Poolvals);
        this.N_activ_pool.setValue(N_activ_poolvals);
        this.N_stabel_pool.setValue(N_stabel_poolvals);
        this.Residue_pool.setValue(Residue_poolvals);
        this.N_residue_pool_fresh.setValue(N_residue_pool_freshvals);
        this.InterflowN_in.setValue(InterflowN_invals);
        this.fertNO3.setValue(0.0);
        this.fertNH4.setValue(0.0);
        this.fertstableorg.setValue(0.0);
        this.fertactivorg.setValue(0.0);
        this.inp_biomass.setValue(0.0);
        this.inpN_biomass.setValue(0.0);
        this.ZRootD.setValue(0.0);
        this.LAI.setValue(0.0);
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException {
    }
}

