/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n.crop;

import java.util.ArrayList;
import org.jams.j2k.s_n.crop.J2KSNCrop;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="j2kCropGrowth", author="Ulrike Bende-Michl & Manfred Fink", description="Module for calculation of crop growth according to the algorithms of SWAT")
public class j2kpotCropGrowth
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Current organic fertilizer amount")
    public JAMSInteger RotPos;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current hru object")
    public JAMSEntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current hru object id")
    public JAMSDouble idValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU attribute name area")
    public JAMSDouble Area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU daily mean temperature [\u00c2\u00b0C]")
    public JAMSDouble Tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Daily solar radiation [MJ/m\u00c2\u00b2]")
    public JAMSDouble SolRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Biomass sum produced for a given day [kg/ha] drymass")
    public JAMSDouble BioAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Actual canopy Height [m]")
    public JAMSDouble CanHeightAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Actual rooting depth [m]")
    public JAMSDouble ZRootD;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Fraction of nitrogen in the plant optimal biomass at the current growth's stage")
    public JAMSDouble FNPlant;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Biomass above ground on the day of harvest [kg/ha]")
    public JAMSDouble BioagAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Biomass added residue pool after harvesting [kg/ha]")
    public JAMSDouble Addresidue_pool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Nitrogen added residue pool after harvesting [kg N/ha]")
    public JAMSDouble Addresidue_pooln;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU actual Transpiration [mm]")
    public JAMSDouble aTP;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU potential Transpiration [mm]")
    public JAMSDouble pTP;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Light Extinct Coefficient [-0.65]")
    public JAMSDouble LExCoef;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Actual N content in plants biomass [kg N/ha]")
    public JAMSDouble BioNoptAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Daily fraction of max LAI [-]")
    public JAMSDouble frLAImxAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Daily fraction of max LAI [-]")
    public JAMSDouble frLAImx_xi;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Daily fraction of max root development [-]")
    public JAMSDouble frRootAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Actual yield [kg/ha]")
    public JAMSDouble BioYield;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Actual N content in yield [absolut]")
    public JAMSDouble NYield;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Actual N content in yield [kg N/ha]")
    public JAMSDouble NYield_ha;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Actual N in Biomass ")
    public JAMSDouble BioNAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual harvest index [0-1]")
    public JAMSDouble HarvIndex;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Fraction of actual potential heat units sum [-]")
    public JAMSDouble FPHUact;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="delta LAI [-]")
    public JAMSDouble LAIdelta;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual LAI")
    public JAMSDouble LAI;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual nitrate uptake by plants in kgN/ha")
    public JAMSDouble actN_up;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="flag plant existing yes or no ")
    public JAMSBoolean plantExisting;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual potential heat units sum [-]")
    public JAMSDouble PHUact;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Plants base growth temperature [\u00c2\u00b0C]")
    public JAMSDouble tbase;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Plants optimum growth temperature [\u00c2\u00b0C]")
    public JAMSDouble topt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Plants daily biomass increase [kg/ha]")
    public JAMSDouble BioOpt_delta;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reset plant state variables?")
    public JAMSBoolean plantStateReset;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Indicator for harvesting")
    public JAMSBoolean doHarvest;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Factor of rootdepth 0 - 10 default 1")
    public JAMSDouble rootfactor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="indicates dormancy of plants")
    public JAMSBoolean dormancy;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="id of the current crop")
    public JAMSDouble cropid;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="max Root depth in soil in m")
    public JAMSDouble soil_root;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Number of fertilisation action in crop [-]")
    public JAMSDouble gift;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Type of harvest to distiguish between crops with undersown plants and normal harvesting")
    public JAMSInteger harvesttype;
    private double area_ha;
    private double sc1_LAI;
    private double sc2_LAI;
    private double sc3_Nbio;
    private double sc4_Nbio;
    private double frLAImx_act;
    private double lai_act;
    private double fnplant_act;
    private double addresidue_pool;
    private double addresidue_pooln;
    private double hc_act;
    private double idc;
    private double phu_50;
    private double phu;
    private double fphu_act;
    private double phu_daily;
    private double phu_Xi;
    private double aTransP;
    private double pTransP;
    private double int_lai;
    private double mlai1;
    private double mlai;
    private double mlai2;
    private double lai_min;
    private double frgrw1;
    private double frgrw2;
    private double frLAImx;
    private double frLAImx_actnew;
    private double frLAImx_Xi;
    private double LAI_actnew;
    private double solrad;
    private double rue;
    private double leco;
    private double chtmx;
    private double rdmx;
    private double frroot_act;
    private double zrootd_act;
    private double zrootd;
    private double bn1;
    private double bn2;
    private double bn3;
    private double betaN;
    private double hvsti;
    private double cnyld;
    private double cid;
    private double bioNopt_act;
    private double bioN_act;
    private double bio_act;
    private double bio_opt;
    private double bioopt_ha;
    private double hi_act;
    private double bioag_act;
    private double yldN;
    private double yldN_ha;
    private double yield;
    private double tmean;
    private double Tbase;
    private double Topt;
    private double julday;
    public double famount;
    public boolean plant;
    public int harvest;
    public double fracharvest;
    public double fracharvestn;
    private double LAI_delta;
    private double frLAImx_delta;
    private double enty_id;
    private double soil_no3;
    private double bioNopt_accumu;
    private double Ndemand_accumu;
    private double actN_uprun;
    private double bio_opt_delta;

    public void init() {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntity entity = this.entities.getCurrent();
        this.yield = 0.0;
        this.yldN = 0.0;
        this.yldN_ha = 0.0;
        this.tmean = this.Tmean.getValue();
        this.fphu_act = this.FPHUact.getValue();
        this.phu_daily = this.PHUact.getValue();
        this.area_ha = this.Area.getValue() / 10000.0;
        this.solrad = this.SolRad.getValue();
        this.leco = this.LExCoef.getValue();
        this.frLAImx_act = this.frLAImxAct.getValue();
        this.frLAImx_Xi = this.frLAImx_xi.getValue();
        this.lai_act = this.LAI.getValue();
        this.LAI_delta = this.LAIdelta.getValue();
        this.hc_act = this.CanHeightAct.getValue();
        this.frroot_act = this.frRootAct.getValue();
        this.zrootd_act = this.ZRootD.getValue();
        this.fnplant_act = this.FNPlant.getValue();
        this.bioNopt_act = this.BioNoptAct.getValue();
        this.bioN_act = this.BioNAct.getValue();
        this.hi_act = this.HarvIndex.getValue();
        this.bioag_act = this.BioagAct.getValue();
        this.bio_opt = this.BioAct.getValue();
        this.actN_uprun = this.actN_up.getValue();
        this.bio_opt_delta = this.BioOpt_delta.getValue();
        ArrayList rotation = (ArrayList)entity.getObject("landuseRotation");
        int rotPos = this.RotPos.getValue();
        J2KSNCrop crop = (J2KSNCrop)rotation.get(rotPos);
        double oldcid = this.cropid.getValue();
        this.cid = crop.cid;
        if (oldcid != this.cid) {
            this.gift.setValue(0.0);
        }
        this.phu = crop.phu;
        this.idc = crop.idc;
        this.rue = crop.rue;
        this.hvsti = crop.hvsti;
        this.frgrw1 = crop.frgrw1;
        this.frgrw2 = crop.frgrw2;
        this.lai_min = crop.lai_min;
        this.mlai = crop.mlai;
        this.mlai1 = crop.laimx1;
        this.mlai2 = crop.laimx2;
        this.chtmx = crop.chtmx;
        this.rdmx = crop.rdmx;
        this.Topt = crop.topt;
        this.Tbase = crop.tbase;
        this.cnyld = crop.cnyld;
        this.bn1 = crop.bn1;
        this.bn2 = crop.bn2;
        this.bn3 = crop.bn3;
        this.cropid.setValue(this.cid);
        if (crop.idc == 11) {
            this.phu_daily = 0.0;
            this.Tbase = 0.0;
            this.Topt = 0.0;
            this.frLAImx_act = 0.0;
            this.LAI_delta = 0.0;
            this.lai_act = 1.0;
            this.hc_act = 0.0;
            this.frroot_act = 0.0;
            this.zrootd_act = 1000.0;
            this.fnplant_act = 0.0;
            this.bioNopt_act = 0.0;
            this.bio_opt = 0.0;
            this.bio_opt_delta = 0.0;
            this.hi_act = 0.0;
            this.bioag_act = 0.0;
            this.fphu_act = 0.0;
            this.bioN_act = 0.0;
            this.frLAImx_Xi = 0.0;
            this.addresidue_pool = 0.0;
            this.addresidue_pooln = 0.0;
        } else if (this.plantExisting.getValue()) {
            this.calc_phu();
            this.calc_lai();
            this.calc_biomass();
            this.hc_act = this.calc_canopy();
            this.calc_root();
            this.calc_nuptake();
            this.addresidue_pool = 0.0;
            this.addresidue_pooln = 0.0;
            if (this.doHarvest.getValue()) {
                this.calc_cropyield();
                this.calc_cropyield_ha();
                this.calc_residues();
                this.doHarvest.setValue(false);
            }
        } else if (this.plantStateReset.getValue()) {
            this.phu_daily = 0.0;
            this.Tbase = 0.0;
            this.Topt = 0.0;
            this.frLAImx_act = 0.0;
            this.LAI_delta = 0.0;
            this.lai_act = 0.0;
            this.hc_act = 0.0;
            this.frroot_act = 0.0;
            this.zrootd_act = 0.0;
            this.fnplant_act = 0.0;
            this.bioNopt_act = 0.0;
            this.bio_opt = 0.0;
            this.bio_opt_delta = 0.0;
            this.hi_act = 0.0;
            this.bioag_act = 0.0;
            this.fphu_act = 0.0;
            this.bioN_act = 0.0;
            this.frLAImx_Xi = 0.0;
            this.addresidue_pool = 0.0;
            this.addresidue_pooln = 0.0;
            this.plantStateReset.setValue(false);
        }
        this.PHUact.setValue(this.phu_daily);
        this.tbase.setValue(this.Tbase);
        this.topt.setValue(this.Topt);
        this.frLAImxAct.setValue(this.frLAImx_act);
        this.LAIdelta.setValue(this.LAI_delta);
        this.LAI.setValue(this.lai_act);
        this.CanHeightAct.setValue(this.hc_act);
        this.frRootAct.setValue(this.frroot_act);
        this.zrootd_act = Math.min(this.zrootd_act * this.rootfactor.getValue(), this.soil_root.getValue());
        this.ZRootD.setValue(this.zrootd_act);
        this.FNPlant.setValue(this.fnplant_act);
        this.BioNoptAct.setValue(this.bioNopt_act);
        this.BioAct.setValue(this.bio_opt);
        this.BioOpt_delta.setValue(this.bio_opt_delta);
        this.HarvIndex.setValue(this.hi_act);
        this.BioagAct.setValue(this.bioag_act);
        this.BioYield.setValue(this.yield);
        this.NYield.setValue(this.yldN);
        this.NYield_ha.setValue(this.yldN_ha);
        this.FPHUact.setValue(this.fphu_act);
        this.BioNAct.setValue(this.bioN_act);
        this.frLAImx_xi.setValue(this.frLAImx_Xi);
        this.Addresidue_pool.setValue(this.addresidue_pool);
        this.Addresidue_pooln.setValue(this.addresidue_pooln);
        if (this.idc == 3.0 || this.idc == 6.0 || this.idc == 7.0) {
            this.plantStateReset.setValue(false);
        } else {
            this.plantStateReset.setValue(true);
        }
    }

    private boolean calc_phu() {
        if (this.tmean > this.Tbase) {
            this.phu_daily += this.tmean - this.Tbase;
            this.fphu_act = this.phu_daily / this.phu;
        }
        return true;
    }

    private boolean calc_lai() {
        double sc1_lai1 = Math.log(this.frgrw1 / this.mlai1 - this.frgrw1);
        double sc2_lai2 = Math.log(this.frgrw2 / this.mlai2 - this.frgrw2);
        double sc_frpuh = this.frgrw2 - this.frgrw1;
        this.sc2_LAI = (sc1_lai1 - sc2_lai2) / sc_frpuh;
        this.sc1_LAI = sc1_lai1 + this.sc2_LAI * this.frgrw1;
        double sc_minus = this.fphu_act * this.sc2_LAI;
        this.frLAImx_Xi = this.frLAImx_act;
        double x = this.fphu_act + Math.exp(this.sc1_LAI - sc_minus);
        this.frLAImx_act = this.fphu_act / x;
        this.frLAImx_delta = this.frLAImx_act - this.frLAImx_Xi;
        double u1 = this.lai_act - this.mlai;
        double u2 = 5.0 * u1;
        double u3 = this.frLAImx_delta;
        this.LAI_delta = u3 * this.mlai * (1.0 - Math.exp(u2));
        this.lai_act += this.LAI_delta;
        if (this.lai_act > this.mlai) {
            this.lai_act = this.mlai;
        }
        if (this.doHarvest.getValue() && (this.idc == 3.0 || this.idc == 6.0 || this.idc == 7.0)) {
            this.frLAImx_act = 0.0;
            this.LAI_delta = 0.0;
            this.lai_act = this.lai_min;
            this.frLAImx_Xi = 0.0;
        }
        return true;
    }

    private void calc_biomass() {
        double Hphosyn = 0.5 * this.solrad * (1.0 - Math.exp(this.leco * this.lai_act));
        this.bio_opt_delta = this.rue * Hphosyn;
        if (this.dormancy.getValue()) {
            this.bio_opt_delta = 0.0;
        }
    }

    private double calc_canopy() {
        double hc_delta = this.chtmx * Math.sqrt(this.frLAImx_act);
        this.hc_act = hc_delta + this.hc_act;
        return this.hc_act;
    }

    private boolean calc_root() {
        double rootpartmodi = 0.2 * this.fphu_act;
        rootpartmodi = Math.min(rootpartmodi, 0.2);
        this.frroot_act = 0.4 - rootpartmodi;
        if (this.idc == 3.0 || this.idc == 6.0 || this.idc == 7.0) {
            this.zrootd_act = this.rdmx;
        }
        if ((this.idc == 1.0 || this.idc == 2.0 || this.idc == 4.0 || this.idc == 5.0 || this.idc == 8.0) && this.fphu_act <= 0.4) {
            this.zrootd_act = 2.5 * this.fphu_act * this.rdmx;
        }
        if (this.fphu_act > 0.4) {
            this.zrootd_act = this.rdmx;
        }
        return true;
    }

    private boolean calc_nuptake() {
        if (this.bn1 > this.bn2 && this.bn2 > this.bn3 && this.bn3 > 0.0) {
            double s1 = 0.0;
            double s2 = 0.0;
            double n1 = 0.0;
            double n2 = 0.0;
            s1 = Math.log(0.5 / (1.0 - (this.bn2 - this.bn3) / (this.bn1 - this.bn3)) - 0.5);
            s2 = Math.log(1.0 / (1.0 - 1.0E-4 / (this.bn1 - this.bn3)) - 1.0);
            n2 = (s1 - s2) / 0.5;
            n1 = Math.log(0.5 / (1.0 - (this.bn2 - this.bn3) / (this.bn1 - this.bn3)) - 0.5) + n2 * 0.5;
            this.fnplant_act = (this.bn1 - this.bn3) * (1.0 - this.fphu_act / (this.fphu_act + Math.exp(n1 - n2 * this.fphu_act))) + this.bn3;
            if (this.harvesttype.getValue() == 2) {
                this.fnplant_act = this.bn3;
            }
        } else {
            this.fnplant_act = 0.01;
        }
        this.bioNopt_act = this.fnplant_act * this.bio_opt;
        return true;
    }

    private boolean calc_cropyield() {
        if (this.idc == 3.0 || this.idc == 6.0 || this.idc == 7.0 || this.idc == 8.0) {
            double bio_ag;
            double u1 = 100.0 * this.fphu_act;
            this.hi_act = this.hvsti * u1 / (u1 + Math.exp(11.1 - 10.0 * this.fphu_act));
            this.hi_act = Math.max(this.hi_act, this.hvsti * 0.75);
            this.hi_act = Math.min(this.hi_act, this.hvsti);
            this.bioag_act = bio_ag = (1.0 - this.frroot_act) * this.bio_opt;
            if (this.fphu_act >= 1.0) {
                double bioag_harvest = this.bioag_act;
            }
            if (this.hvsti <= 1.0) {
                this.yield = this.bioag_act * this.hi_act;
                if (this.yield > this.bioag_act) {
                    this.yield = this.bioag_act;
                }
            } else if (this.hvsti > 1.0) {
                this.yield = this.bio_opt * (1.0 - 1.0 / (1.0 + this.hi_act));
            }
            this.yldN = this.bioN_act * (this.yield / this.bio_opt);
            if (this.idc == 7.0) {
                this.fphu_act = 0.0;
            } else {
                this.fphu_act = Math.min(this.fphu_act, 1.0);
                this.fphu_act *= 1.0 - this.yield / this.bio_opt;
            }
            this.phu_daily = this.phu * this.fphu_act;
            this.bio_opt -= this.yield;
            if (this.bio_opt < 0.0) {
                this.bio_opt = 0.0;
            }
            this.bioN_act -= this.yldN;
            this.fracharvest = 1.0 - this.yield / this.bio_opt;
            this.fracharvestn = 1.0 - this.yldN / this.bioN_act;
        } else {
            double bio_ag;
            double u1 = 100.0 * this.fphu_act;
            this.hi_act = this.hvsti * u1 / (u1 + Math.exp(11.1 - 10.0 * this.fphu_act));
            this.hi_act = Math.max(this.hi_act, this.hvsti * 0.75);
            this.bioag_act = bio_ag = (1.0 - this.frroot_act) * this.bio_opt;
            if (this.fphu_act >= 1.0) {
                double bioag_harvest = this.bioag_act;
            }
            if (this.hvsti <= 1.0) {
                this.yield = this.bioag_act * this.hi_act;
            } else if (this.hvsti > 1.0) {
                this.yield = this.bio_opt * (1.0 - 1.0 / (1.0 + this.hi_act));
            }
            this.yldN = this.cnyld * this.yield;
            if (this.yldN > this.bioN_act * (this.yldN / (this.yldN + (this.bio_opt - this.yield) * (this.bn3 / 2.0)))) {
                this.yldN = this.bioN_act * (this.yldN / (this.yldN + (this.bio_opt - this.yield) * (this.bn3 / 2.0)));
            }
            this.fracharvest = 1.0 - this.yield / this.bio_opt;
            this.fracharvestn = 1.0 - this.yldN / this.bioN_act;
        }
        return true;
    }

    private double calc_cropyield_ha() {
        this.yldN_ha = this.yldN * this.area_ha / 10000.0;
        return this.yldN_ha;
    }

    private boolean calc_residues() {
        if (this.idc == 7.0) {
            this.addresidue_pool = this.yield;
            this.addresidue_pooln = this.yldN;
        } else if (this.idc == 1.0 || this.idc == 2.0 || this.idc == 4.0 || this.idc == 5.0) {
            this.addresidue_pool = this.bio_opt - this.yield;
            this.addresidue_pooln = this.bioN_act - this.yldN;
        } else if (this.idc == 6.0 || this.idc == 3.0) {
            this.addresidue_pool = this.yield * 0.1;
            this.addresidue_pooln = this.yldN * 0.1;
            this.addresidue_pool = Math.min(this.addresidue_pool, this.bio_opt);
            this.addresidue_pooln = Math.min(this.addresidue_pooln, this.bioN_act);
            this.bio_opt -= this.addresidue_pool;
            this.bioN_act -= this.addresidue_pooln;
        } else if (this.idc == 8.0) {
            this.addresidue_pool = this.yield * 0.1;
            this.addresidue_pooln = this.yldN * 0.1;
            this.addresidue_pool = Math.min(this.addresidue_pool, this.bio_opt);
            this.addresidue_pooln = Math.min(this.addresidue_pooln, this.bioN_act);
            this.bio_opt -= this.addresidue_pool;
            this.bioN_act -= this.addresidue_pooln;
        }
        return true;
    }

    public void cleanup() {
    }
}

