/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KPlantGrothWaterStress", author="Manfred Fink", description="Calculation of the plant groth water factor after SWAT")
public class J2KPlantGrowthWaterStress
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU actual Transpiration in mm")
    public JAMSDouble aTP;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU potential Transpiration in mm")
    public JAMSDouble pTP;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="in [-] plant groth water stress factor")
    public JAMSDouble wstrs;

    public void init() {
    }

    public void run() {
        double run_wstrs = 0.0;
        double run_aTP = this.aTP.getValue();
        double run_pTP = this.pTP.getValue();
        run_wstrs = 1.0 - (run_aTP + 1.0E-6) / (run_pTP + 1.0E-6);
        this.wstrs.setValue(run_wstrs);
    }

    public void cleanup() {
    }
}

