/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import org.geotools.feature.Feature;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.expression.ExpressionAbstract;
import org.geotools.filter.expression.FilterVisitorExpressionWrapper;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.Subtract;

public abstract class DefaultExpression
extends ExpressionAbstract
implements Expression {
    protected short expressionType;
    protected boolean permissiveConstruction;

    public short getType() {
        return this.expressionType;
    }

    public final Object getValue(Feature feature) {
        return this.evaluate(feature);
    }

    public Object evaluate(Feature feature) {
        return new Object();
    }

    public Object evaluate(Object object) {
        if (object instanceof Feature || object == null) {
            return this.evaluate((Feature)object);
        }
        return null;
    }

    public final void accept(FilterVisitor visitor) {
        this.accept(new FilterVisitorExpressionWrapper(visitor), null);
    }

    protected static boolean isAttributeExpression(short expressionType) {
        return expressionType == 109 || expressionType == 110 || expressionType == 111;
    }

    protected static boolean isMathExpression(short expressionType) {
        return expressionType == 105 || expressionType == 106 || expressionType == 107 || expressionType == 108;
    }

    protected static boolean isMathExpression(org.opengis.filter.expression.Expression expression) {
        return expression instanceof Add || expression instanceof Subtract || expression instanceof Multiply || expression instanceof Divide;
    }

    protected static boolean isLiteralExpression(short expressionType) {
        return expressionType == 104 || expressionType == 101 || expressionType == 102 || expressionType == 103;
    }

    protected static boolean isGeometryExpression(short expressionType) {
        return expressionType == 112 || expressionType == 104;
    }

    protected static boolean isExpression(short expressionType) {
        return DefaultExpression.isMathExpression(expressionType) || DefaultExpression.isAttributeExpression(expressionType) || DefaultExpression.isLiteralExpression(expressionType) || DefaultExpression.isFunctionExpression(expressionType);
    }

    public static boolean isFunctionExpression(short expressionType) {
        return expressionType == 114;
    }
}

