/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;

public class DelegateFeatureReader
implements FeatureReader {
    FeatureIterator delegate;
    FeatureType schema;

    public DelegateFeatureReader(FeatureType featureType, FeatureIterator features) {
        this.schema = featureType;
        this.delegate = features;
    }

    public FeatureType getFeatureType() {
        return this.schema;
    }

    public Feature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.delegate == null) {
            throw new IOException("Feature Reader has been closed");
        }
        try {
            Feature feature = this.delegate.next();
            return feature;
        }
        catch (NoSuchElementException end) {
            throw new DataSourceException("There are no more Features", (Throwable)end);
        }
    }

    public boolean hasNext() throws IOException {
        return this.delegate != null && this.delegate.hasNext();
    }

    public void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
        }
        this.delegate = null;
        this.schema = null;
    }
}

