/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequence;

public final class LiteCoordinateSequence
extends PackedCoordinateSequence {
    private double[] coords;

    public LiteCoordinateSequence(double[] coords) {
        this.dimension = 2;
        if (coords.length % this.dimension != 0) {
            throw new IllegalArgumentException("Packed array does not contain an integral number of coordinates");
        }
        this.coords = coords;
    }

    public LiteCoordinateSequence(float[] coordinates) {
        int length = coordinates.length;
        this.coords = new double[length];
        this.dimension = 2;
        for (int i = 0; i < length; ++i) {
            this.coords[i] = coordinates[i];
        }
    }

    public LiteCoordinateSequence(Coordinate[] coordinates) {
        if (coordinates == null) {
            coordinates = new Coordinate[]{};
        }
        int length = coordinates.length;
        this.dimension = 2;
        this.coords = new double[length * this.dimension];
        for (int i = 0; i < length; ++i) {
            this.coords[i * this.dimension] = coordinates[i].x;
            if (this.dimension < 2) continue;
            this.coords[i * this.dimension + 1] = coordinates[i].y;
        }
    }

    public LiteCoordinateSequence(int size, int dimension) {
        if (dimension != 2) {
            throw new IllegalArgumentException("This type of sequence is always 2 dimensional");
        }
        this.dimension = 2;
        this.coords = new double[size * this.dimension];
    }

    public Coordinate getCoordinateInternal(int i) {
        double x = this.coords[i * this.dimension];
        double y = this.coords[i * this.dimension + 1];
        double z = this.dimension == 2 ? 0.0 : this.coords[i * this.dimension + 2];
        return new Coordinate(x, y, z);
    }

    public int size() {
        return this.coords.length / this.dimension;
    }

    public Object clone() {
        double[] clone = new double[this.coords.length];
        System.arraycopy(this.coords, 0, clone, 0, this.coords.length);
        return new PackedCoordinateSequence.Double(clone, this.dimension);
    }

    public double getOrdinate(int index, int ordinate) {
        return this.coords[index * this.dimension + ordinate];
    }

    public void setOrdinate(int index, int ordinate, double value) {
        this.coordRef = null;
        this.coords[index * this.dimension + ordinate] = value;
    }

    public Envelope expandEnvelope(Envelope env) {
        int length = this.coords.length;
        for (int i = 0; i < length; i += this.dimension) {
            env.expandToInclude(this.coords[i], this.coords[i + 1]);
        }
        return env;
    }

    public double[] getArray() {
        return this.coords;
    }

    public void setArray(double[] coords2) {
        this.coords = coords2;
    }
}

