/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.sql.Driver;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Logging;

public final class JDBC {
    private static final Set DRIVERS = new HashSet();

    private JDBC() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogRecord loadDriver(String driver) {
        LogRecord log = null;
        if (driver != null) {
            Set set = DRIVERS;
            synchronized (set) {
                if (!DRIVERS.contains(driver)) {
                    try {
                        Driver d = (Driver)Class.forName(driver).newInstance();
                        log = Logging.format(Level.CONFIG, 29, driver, new Integer(d.getMajorVersion()), new Integer(d.getMinorVersion()));
                        DRIVERS.add(driver);
                    }
                    catch (Exception exception) {
                        log = Utilities.getLogRecord(exception);
                    }
                }
            }
        }
        return log;
    }
}

