/*
 * Decompiled with CFR 0.152.
 */
package javax.units;

import java.io.Serializable;
import javax.units.ConversionException;

public abstract class Converter
implements Serializable {
    public static final Converter IDENTITY = new Identity();

    protected Converter() {
    }

    public abstract Converter inverse();

    public abstract double convert(double var1) throws ConversionException;

    public abstract double derivative(double var1);

    public abstract boolean isLinear();

    public boolean equals(Object object) {
        if (object instanceof Converter) {
            Converter converter = (Converter)object;
            return this.isLinear() && converter.isLinear() && Float.floatToIntBits((float)this.derivative(0.0)) == Float.floatToIntBits((float)converter.derivative(0.0));
        }
        return false;
    }

    public int hashCode() {
        return Float.floatToIntBits((float)this.derivative(0.0));
    }

    public Converter concatenate(Converter converter) {
        if (converter == IDENTITY) {
            return this;
        }
        return new Compound(converter, this);
    }

    private static final class Compound
    extends Converter {
        private final Converter _first;
        private final Converter _second;

        private Compound(Converter converter, Converter converter2) {
            this._first = converter;
            this._second = converter2;
        }

        public Converter inverse() {
            return new Compound(this._second.inverse(), this._first.inverse());
        }

        public double convert(double d) {
            return this._second.convert(this._first.convert(d));
        }

        public double derivative(double d) {
            return this._first.derivative(d) * this._second.derivative(this._first.convert(d));
        }

        public boolean isLinear() {
            return this._first.isLinear() && this._second.isLinear();
        }

        public boolean equals(Object object) {
            return super.equals(object) || object instanceof Compound && ((Compound)object)._first.equals(this._first) && ((Compound)object)._second.equals(this._second);
        }
    }

    private static final class Identity
    extends Converter {
        private Identity() {
        }

        public Converter inverse() {
            return this;
        }

        public double convert(double d) {
            return d;
        }

        public double derivative(double d) {
            return 1.0;
        }

        public boolean isLinear() {
            return true;
        }

        public Converter concatenate(Converter converter) {
            return converter;
        }
    }
}

