/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Set;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.resources.LazySet;

public class FactoryFinder {
    private static FactoryRegistry registry;
    static final /* synthetic */ boolean $assertionsDisabled;

    private FactoryFinder() {
    }

    private static FactoryRegistry getServiceRegistry() {
        if (!$assertionsDisabled && !Thread.holdsLock(FactoryFinder.class)) {
            throw new AssertionError();
        }
        if (registry == null) {
            registry = new Registry();
        }
        return registry;
    }

    public static synchronized GeometryFactory getGeometryFactory(Hints hints) throws FactoryRegistryException {
        return (GeometryFactory)FactoryFinder.getServiceRegistry().getServiceProvider(GeometryFactory.class, null, hints, Hints.JTS_GEOMETRY_FACTORY);
    }

    public static synchronized Set getGeometryFactories() {
        return new LazySet(FactoryFinder.getServiceRegistry().getServiceProviders(GeometryFactory.class));
    }

    public static synchronized PrecisionModel getPrecisionModel(Hints hints) throws FactoryRegistryException {
        return (PrecisionModel)FactoryFinder.getServiceRegistry().getServiceProvider(PrecisionModel.class, null, hints, Hints.JTS_PRECISION_MODEL);
    }

    public static synchronized Set getPrecisionModels() {
        return new LazySet(FactoryFinder.getServiceRegistry().getServiceProviders(PrecisionModel.class));
    }

    public static synchronized CoordinateSequenceFactory getCoordinateSequenceFactory(Hints hints) throws FactoryRegistryException {
        return (CoordinateSequenceFactory)FactoryFinder.getServiceRegistry().getServiceProvider(CoordinateSequenceFactory.class, null, hints, Hints.JTS_COORDINATE_SEQUENCE_FACTORY);
    }

    public static synchronized Set getCoordinateSequenceFactories() {
        return new LazySet(FactoryFinder.getServiceRegistry().getServiceProviders(CoordinateSequenceFactory.class));
    }

    public static void scanForPlugins() {
        if (registry != null) {
            registry.scanForPlugins();
        }
    }

    static {
        $assertionsDisabled = !FactoryFinder.class.desiredAssertionStatus();
    }

    private static final class Registry
    extends FactoryCreator {
        public Registry() {
            super(Arrays.asList(class$com$vividsolutions$jts$geom$GeometryFactory == null ? (class$com$vividsolutions$jts$geom$GeometryFactory = FactoryFinder.class$("com.vividsolutions.jts.geom.GeometryFactory")) : class$com$vividsolutions$jts$geom$GeometryFactory, class$com$vividsolutions$jts$geom$PrecisionModel == null ? (class$com$vividsolutions$jts$geom$PrecisionModel = FactoryFinder.class$("com.vividsolutions.jts.geom.PrecisionModel")) : class$com$vividsolutions$jts$geom$PrecisionModel, class$com$vividsolutions$jts$geom$CoordinateSequenceFactory == null ? (class$com$vividsolutions$jts$geom$CoordinateSequenceFactory = FactoryFinder.class$("com.vividsolutions.jts.geom.CoordinateSequenceFactory")) : class$com$vividsolutions$jts$geom$CoordinateSequenceFactory));
        }

        protected Object createServiceProvider(Class category, Class implementation, Hints hints) throws FactoryRegistryException {
            if ((class$com$vividsolutions$jts$geom$GeometryFactory == null ? (class$com$vividsolutions$jts$geom$GeometryFactory = FactoryFinder.class$("com.vividsolutions.jts.geom.GeometryFactory")) : class$com$vividsolutions$jts$geom$GeometryFactory).isAssignableFrom(category) && (class$com$vividsolutions$jts$geom$GeometryFactory == null ? (class$com$vividsolutions$jts$geom$GeometryFactory = FactoryFinder.class$("com.vividsolutions.jts.geom.GeometryFactory")) : class$com$vividsolutions$jts$geom$GeometryFactory).equals(implementation)) {
                return new GeometryFactory(FactoryFinder.getPrecisionModel(hints), Registry.getSRID(hints), FactoryFinder.getCoordinateSequenceFactory(hints));
            }
            return super.createServiceProvider(category, implementation, hints);
        }

        private static int getSRID(Hints hints) {
            Integer SRID;
            if (hints != null && (SRID = (Integer)hints.get((Object)Hints.JTS_SRID)) != null) {
                return SRID;
            }
            return 0;
        }

        protected boolean isAcceptable(Object provider, Class category, Hints hints) {
            if ((class$com$vividsolutions$jts$geom$GeometryFactory == null ? (class$com$vividsolutions$jts$geom$GeometryFactory = FactoryFinder.class$("com.vividsolutions.jts.geom.GeometryFactory")) : class$com$vividsolutions$jts$geom$GeometryFactory).isAssignableFrom(category)) {
                GeometryFactory factory = (GeometryFactory)provider;
                CoordinateSequenceFactory sequence = factory.getCoordinateSequenceFactory();
                PrecisionModel precision = factory.getPrecisionModel();
                if (!Registry.isAcceptable(sequence, hints.get((Object)Hints.JTS_COORDINATE_SEQUENCE_FACTORY)) || !Registry.isAcceptable(precision, hints.get((Object)Hints.JTS_PRECISION_MODEL))) {
                    return false;
                }
                int SRID = Registry.getSRID(hints);
                if (SRID != 0 && SRID != factory.getSRID()) {
                    return false;
                }
            }
            return super.isAcceptable(provider, category, hints);
        }

        private static boolean isAcceptable(Object actual, Object requested) {
            if (requested == null || requested.equals(actual)) {
                return true;
            }
            if (requested.getClass().isArray()) {
                int length = Array.getLength(requested);
                for (int i = 0; i < length; ++i) {
                    if (Registry.isAcceptable(actual, Array.get(requested, i))) continue;
                    return false;
                }
                return true;
            }
            if (actual != null && requested instanceof Class) {
                return ((Class)requested).isAssignableFrom(actual.getClass());
            }
            return false;
        }
    }
}

