/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Expression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.MathExpression;
import org.geotools.filter.NullFilter;
import org.geotools.filter.visitor.AbstractFilterVisitor;

public class DuplicatorFilterVisitor
extends AbstractFilterVisitor {
    Stack pages = new Stack();
    FilterFactory ff;
    private boolean strict;

    public Stack getPages() {
        return this.pages;
    }

    public DuplicatorFilterVisitor(FilterFactory factory) {
        this(factory, true);
    }

    public DuplicatorFilterVisitor(FilterFactory factory, boolean strict) {
        this.ff = factory;
        this.strict = strict;
    }

    public void setFilterFactory(FilterFactory factory) {
        this.ff = factory;
    }

    public void visit(Filter filter) {
        if (filter == Filter.NONE) {
            this.pages.push(Filter.NONE);
            return;
        }
        if (filter == Filter.ALL) {
            this.pages.push(Filter.ALL);
            return;
        }
        if (this.strict) {
            throw new RuntimeException("visit(Filter) unsupported");
        }
        this.pages.push(filter);
    }

    public void visit(BetweenFilter filter) {
        BetweenFilter copy = null;
        try {
            Expression leftCopy = null;
            if (filter.getLeftValue() != null) {
                filter.getLeftValue().accept((FilterVisitor)this);
                leftCopy = (Expression)this.pages.pop();
            }
            Expression middleCopy = null;
            if (filter.getMiddleValue() != null) {
                filter.getMiddleValue().accept((FilterVisitor)this);
                middleCopy = (Expression)this.pages.pop();
            }
            Expression rightCopy = null;
            if (filter.getRightValue() != null) {
                filter.getRightValue().accept((FilterVisitor)this);
                rightCopy = (Expression)this.pages.pop();
            }
            copy = this.ff.createBetweenFilter();
            copy.addLeftValue(leftCopy);
            copy.addMiddleValue(middleCopy);
            copy.addRightValue(rightCopy);
        }
        catch (IllegalFilterException erp) {
            throw new RuntimeException(erp);
        }
        this.pages.push(copy);
    }

    public void visit(CompareFilter filter) {
        CompareFilter copy = null;
        try {
            Expression leftCopy = null;
            if (filter.getLeftValue() != null) {
                filter.getLeftValue().accept((FilterVisitor)this);
                leftCopy = (Expression)this.pages.pop();
            }
            Expression rightCopy = null;
            if (filter.getRightValue() != null) {
                filter.getRightValue().accept((FilterVisitor)this);
                rightCopy = (Expression)this.pages.pop();
            }
            copy = this.ff.createCompareFilter(filter.getFilterType());
            copy.addLeftValue(leftCopy);
            copy.addRightValue(rightCopy);
        }
        catch (IllegalFilterException erp) {
            throw new RuntimeException(erp);
        }
        this.pages.push(copy);
    }

    public void visit(GeometryFilter filter) {
        GeometryFilter copy = null;
        try {
            Expression leftCopy = null;
            if (filter.getLeftGeometry() != null) {
                filter.getLeftGeometry().accept((FilterVisitor)this);
                leftCopy = (Expression)this.pages.pop();
            }
            Expression rightCopy = null;
            if (filter.getRightGeometry() != null) {
                filter.getRightGeometry().accept((FilterVisitor)this);
                rightCopy = (Expression)this.pages.pop();
            }
            copy = this.ff.createGeometryFilter(filter.getFilterType());
            copy.addLeftGeometry(leftCopy);
            copy.addRightGeometry(rightCopy);
        }
        catch (IllegalFilterException erp) {
            throw new RuntimeException(erp);
        }
        this.pages.push(copy);
    }

    public void visit(LikeFilter filter) {
        LikeFilter copy = null;
        try {
            Expression valueCopy = null;
            if (filter.getValue() != null) {
                filter.getValue().accept((FilterVisitor)this);
                valueCopy = (Expression)this.pages.pop();
            }
            copy = this.ff.createLikeFilter();
            copy.setValue(valueCopy);
            copy.setPattern(filter.getPattern(), filter.getWildcardMulti(), filter.getWildcardSingle(), filter.getEscape());
        }
        catch (IllegalFilterException erp) {
            throw new RuntimeException(erp);
        }
        this.pages.push(copy);
    }

    public void visit(LogicFilter filter) {
        LogicFilter copy = null;
        Iterator iterator = filter.getFilterIterator();
        ArrayList<Filter> subFilters = new ArrayList<Filter>();
        while (iterator.hasNext()) {
            Filter subFilter = (Filter)iterator.next();
            subFilter.accept((FilterVisitor)this);
            subFilters.add((Filter)this.pages.pop());
        }
        try {
            copy = this.ff.createLogicFilter(filter.getFilterType());
            Iterator copyIterator = subFilters.iterator();
            while (copyIterator.hasNext()) {
                copy.addFilter((Filter)copyIterator.next());
            }
        }
        catch (IllegalFilterException erp) {
            throw new RuntimeException(erp);
        }
        this.pages.push(copy);
    }

    public void visit(NullFilter filter) {
        NullFilter copy = null;
        try {
            Expression valueCopy = null;
            if (filter.getNullCheckValue() != null) {
                filter.getNullCheckValue().accept((FilterVisitor)this);
                valueCopy = (Expression)this.pages.pop();
            }
            copy = this.ff.createNullFilter();
            copy.nullCheckValue(valueCopy);
        }
        catch (IllegalFilterException erp) {
            throw new RuntimeException(erp);
        }
        this.pages.push(copy);
    }

    public void visit(FidFilter filter) {
        FidFilter copy = this.ff.createFidFilter();
        String[] fids = filter.getFids();
        for (int i = 0; i < fids.length; ++i) {
            copy.addFid(fids[i]);
        }
        this.pages.push(copy);
    }

    public void visit(AttributeExpression expression) {
        AttributeExpression copy = null;
        copy = this.ff.createAttributeExpression(expression.getAttributePath());
        this.pages.push(copy);
    }

    public void visit(Expression expression) {
        throw new RuntimeException("visit(Expression) unsupported");
    }

    public void visit(LiteralExpression expression) {
        LiteralExpression copy = null;
        try {
            copy = this.ff.createLiteralExpression(expression.getLiteral());
        }
        catch (IllegalFilterException erp) {
            throw new RuntimeException(erp);
        }
        this.pages.push(copy);
    }

    public void visit(MathExpression expression) {
        MathExpression copy = null;
        try {
            copy = this.ff.createMathExpression(expression.getType());
            if (expression.getLeftValue() != null) {
                expression.getLeftValue().accept((FilterVisitor)this);
                copy.addLeftValue((Expression)this.pages.pop());
            }
            if (expression.getRightValue() != null) {
                expression.getRightValue().accept((FilterVisitor)this);
                copy.addRightValue((Expression)this.pages.pop());
            }
        }
        catch (IllegalFilterException erp) {
            throw new RuntimeException(erp);
        }
        this.pages.push(copy);
    }

    public void visit(FunctionExpression expression) {
        FunctionExpression copy = null;
        Expression[] args = expression.getArgs();
        Expression[] copyArgs = new Expression[args.length];
        for (int i = 0; i < args.length; ++i) {
            args[i].accept((FilterVisitor)this);
            copyArgs[i] = (Expression)this.pages.pop();
        }
        copy = this.ff.createFunctionExpression(expression.getName());
        copy.setArgs(copyArgs);
        this.pages.push(copy);
    }

    public Object getCopy() {
        if (this.pages.isEmpty()) {
            return null;
        }
        return this.pages.firstElement();
    }
}

