/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.List;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureVisitor;
import org.geotools.feature.visitor.QuantileListVisitor;
import org.geotools.filter.Expression;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.function.RangedClassificationFunction;
import org.geotools.util.NullProgressListener;

public class QuantileFunction
extends RangedClassificationFunction {
    List[] bin;
    Comparable globalMin = null;
    Comparable globalMax = null;
    Comparable[] localMin = null;
    Comparable[] localMax = null;
    boolean isNumber = false;
    boolean isValid = false;

    public String getName() {
        return "Quantile";
    }

    private void calculate() throws IllegalFilterException, IOException {
        QuantileListVisitor quantileVisit = new QuantileListVisitor(this.expr, this.classNum);
        if (this.progress == null) {
            this.progress = new NullProgressListener();
        }
        this.fc.accepts((FeatureVisitor)quantileVisit, this.progress);
        if (this.progress.isCanceled()) {
            return;
        }
        CalcResult calcResult = quantileVisit.getResult();
        if (calcResult == null) {
            return;
        }
        Object result = calcResult.getValue();
        this.bin = (List[])result;
        if (this.bin.length != this.classNum) {
            this.classNum = this.bin.length;
        }
        this.globalMin = (Comparable)this.bin[0].toArray()[0];
        Object[] lastBin = this.bin[this.bin.length - 1].toArray();
        this.globalMax = lastBin.length > 0 ? (Comparable)lastBin[lastBin.length - 1] : null;
        this.isNumber = this.globalMin instanceof Number && this.globalMax instanceof Number;
        this.localMin = new Comparable[this.classNum];
        this.localMax = new Comparable[this.classNum];
        if (this.isNumber) {
            for (int i = 0; i < this.classNum; ++i) {
                int decPlaces;
                List thisBin = this.bin[i];
                this.localMin[i] = (Comparable)thisBin.get(0);
                this.localMax[i] = (Comparable)thisBin.get(thisBin.size() - 1);
                double slotWidth = (((Number)((Object)this.localMax[i])).doubleValue() - ((Number)((Object)this.localMin[i])).doubleValue()) / (double)this.classNum;
                if (slotWidth == 0.0) {
                    slotWidth = (((Number)((Object)this.globalMax)).doubleValue() - ((Number)((Object)this.globalMin)).doubleValue()) / (double)this.classNum;
                }
                if ((decPlaces = this.decimalPlaces(slotWidth)) > -1) {
                    this.localMin[i] = new Double(this.round(((Number)((Object)this.localMin[i])).doubleValue(), decPlaces));
                    this.localMax[i] = new Double(this.round(((Number)((Object)this.localMax[i])).doubleValue(), decPlaces));
                }
                if (i == 0) {
                    if (this.localMin[i].compareTo(new Double(((Number)((Object)this.globalMin)).doubleValue())) > 0) {
                        this.localMin[i] = new Double(this.fixRound(((Number)((Object)this.localMin[i])).doubleValue(), decPlaces, false));
                    }
                } else if (i == this.classNum - 1 && this.localMax[i].compareTo(new Double(((Number)((Object)this.globalMax)).doubleValue())) < 0) {
                    this.localMax[i] = new Double(this.fixRound(((Number)((Object)this.localMax[i])).doubleValue(), decPlaces, true));
                }
                if (i == 0 || this.localMin[i].equals(this.localMax[i - 1]) || this.localMin[i].equals(this.localMax[i])) continue;
                this.localMin[i] = this.localMax[i - 1];
            }
        } else {
            for (int i = 0; i < this.classNum; ++i) {
                List thisBin = this.bin[i];
                this.localMin[i] = (Comparable)thisBin.get(0);
                this.localMax[i] = (Comparable)thisBin.get(thisBin.size() - 1);
            }
        }
        this.isValid = true;
    }

    private int calculateSlot(Object val) {
        if (val == null) {
            return -1;
        }
        if (this.isValid) {
            for (int i = 0; i < this.bin.length; ++i) {
                if (!this.bin[i].contains(val)) continue;
                return i;
            }
        }
        return -1;
    }

    public Object evaluate(Feature feature) {
        FeatureCollection fcNew = feature instanceof FeatureCollection ? (FeatureCollection)feature : feature.getParent();
        if (fcNew == null) {
            return new Integer(0);
        }
        if (!fcNew.equals(this.fc) || !this.isValid) {
            this.fc = fcNew;
            try {
                this.calculate();
            }
            catch (IllegalFilterException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        int slot = this.calculateSlot(this.expr.getValue(feature));
        return new Integer(slot);
    }

    public void setExpression(Expression e) {
        super.setExpression(e);
        if (this.fc != null) {
            try {
                this.calculate();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public Object getValue(int index) {
        if (this.fc == null) {
            return null;
        }
        if (!this.isValid) {
            try {
                this.calculate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.bin[index];
    }

    public Object getMin(int index) {
        return this.localMin[index];
    }

    public Object getMax(int index) {
        return this.localMax[index];
    }
}

