/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerListModel;
import org.unijena.jams.JAMSProperties;
import org.unijena.jams.JAMSTools;
import org.unijena.jams.gui.LHelper;
import org.unijena.jams.gui.input.BooleanInput;
import org.unijena.jams.gui.input.FileInput;
import org.unijena.jams.gui.input.ListInput;
import org.unijena.jams.gui.input.TextInput;

public class PropertyDlg
extends JDialog {
    private static final int JCOMP_HEIGHT = 20;
    private ListInput list;
    private BooleanInput verboseCheck;
    private BooleanInput windowEnable;
    private BooleanInput windowOnTop;
    private BooleanInput errorDlg;
    private JSpinner debugSpinner;
    private FileInput infoFile;
    private FileInput errorFile;
    private TextInput windowHeight;
    private TextInput windowWidth;
    private JAMSProperties properties;
    public static final int APPROVE_OPTION = 1;
    public static final int CANCEL_OPTION = 0;
    private int result = 0;

    public PropertyDlg(Frame owner, JAMSProperties properties) {
        super(owner);
        this.setLayout(new BorderLayout());
        this.setLocationRelativeTo(owner);
        this.setDefaultCloseOperation(1);
        this.properties = properties;
        this.setTitle("JAMS Properties");
        this.setModal(true);
        JPanel contentPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        contentPanel.setLayout(gbl);
        int y = 0;
        LHelper.addGBComponent(contentPanel, gbl, new JLabel("Libraries:"), 0, y, 1, 1, 0.0, 0.0);
        this.list = new ListInput();
        this.list.setPreferredSize(new Dimension(295, 130));
        LHelper.addGBComponent(contentPanel, gbl, this.list, 1, y, 1, 1, 1.0, 1.0);
        LHelper.addGBComponent(contentPanel, gbl, new JLabel("Command line output:"), 0, ++y, 1, 1, 0.0, 0.0);
        this.verboseCheck = new BooleanInput();
        this.verboseCheck.setPreferredSize(new Dimension(295, 20));
        LHelper.addGBComponent(contentPanel, gbl, this.verboseCheck, 1, y, 1, 1, 1.0, 1.0);
        LHelper.addGBComponent(contentPanel, gbl, new JLabel("Debug level:"), 0, ++y, 1, 1, 0.0, 0.0);
        this.debugSpinner = new JSpinner();
        JPanel spinnerPanel = new JPanel();
        spinnerPanel.setLayout(new BorderLayout());
        spinnerPanel.add((Component)this.debugSpinner, "West");
        ArrayList<Integer> vals = new ArrayList<Integer>();
        vals.add(0);
        vals.add(1);
        vals.add(2);
        vals.add(3);
        SpinnerListModel sModel = new SpinnerListModel(vals);
        this.debugSpinner.setModel(sModel);
        this.debugSpinner.setPreferredSize(new Dimension(35, 26));
        LHelper.addGBComponent(contentPanel, gbl, spinnerPanel, 1, y, 1, 1, 0.0, 0.0);
        LHelper.addGBComponent(contentPanel, gbl, new JLabel("Info log file:"), 0, ++y, 1, 1, 0.0, 0.0);
        this.infoFile = new FileInput();
        this.infoFile.setPreferredSize(new Dimension(286, 20));
        LHelper.addGBComponent(contentPanel, gbl, this.infoFile, 1, y, 1, 1, 1.0, 1.0);
        LHelper.addGBComponent(contentPanel, gbl, new JLabel("Error log file:"), 0, ++y, 1, 1, 0.0, 0.0);
        this.errorFile = new FileInput();
        this.errorFile.setPreferredSize(new Dimension(286, 20));
        LHelper.addGBComponent(contentPanel, gbl, this.errorFile, 1, y, 1, 1, 1.0, 1.0);
        LHelper.addGBComponent(contentPanel, gbl, new JLabel("Model window visible:"), 0, ++y, 1, 1, 0.0, 0.0);
        this.windowEnable = new BooleanInput();
        this.windowEnable.setPreferredSize(new Dimension(295, 20));
        LHelper.addGBComponent(contentPanel, gbl, this.windowEnable, 1, y, 1, 1, 1.0, 1.0);
        LHelper.addGBComponent(contentPanel, gbl, new JLabel("Show dialog on errors:"), 0, ++y, 1, 1, 0.0, 0.0);
        this.errorDlg = new BooleanInput();
        this.errorDlg.setPreferredSize(new Dimension(295, 20));
        LHelper.addGBComponent(contentPanel, gbl, this.errorDlg, 1, y, 1, 1, 1.0, 1.0);
        LHelper.addGBComponent(contentPanel, gbl, new JLabel("Model window on top:"), 0, ++y, 1, 1, 0.0, 0.0);
        this.windowOnTop = new BooleanInput();
        this.windowOnTop.setPreferredSize(new Dimension(295, 20));
        LHelper.addGBComponent(contentPanel, gbl, this.windowOnTop, 1, y, 1, 1, 1.0, 1.0);
        LHelper.addGBComponent(contentPanel, gbl, new JLabel("Model window width:"), 0, ++y, 1, 1, 0.0, 0.0);
        this.windowWidth = new TextInput();
        this.windowWidth.getComponent().setPreferredSize(new Dimension(100, 20));
        LHelper.addGBComponent(contentPanel, gbl, this.windowWidth, 1, y, 1, 1, 1.0, 1.0);
        JPanel buttonPanel = new JPanel();
        LHelper.addGBComponent(contentPanel, gbl, new JLabel("Model window height:"), 0, ++y, 1, 1, 0.0, 0.0);
        this.windowHeight = new TextInput();
        this.windowHeight.getComponent().setPreferredSize(new Dimension(100, 20));
        LHelper.addGBComponent(contentPanel, gbl, this.windowHeight, 1, y, 1, 1, 1.0, 1.0);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyDlg.this.ok();
            }
        });
        buttonPanel.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyDlg.this.cancel();
            }
        });
        buttonPanel.add(cancelButton);
        JPanel mainPanel = new JPanel();
        mainPanel.add(contentPanel);
        this.getContentPane().add((Component)new JScrollPane(mainPanel), "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.pack();
    }

    private void cancel() {
        this.setVisible(false);
        this.result = 0;
    }

    private void ok() {
        this.setVisible(false);
        this.result = 1;
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane pane = super.createRootPane();
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertyDlg.this.cancel();
            }
        };
        AbstractAction okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertyDlg.this.ok();
            }
        };
        InputMap inputMap = pane.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "ENTER");
        pane.getActionMap().put("ESCAPE", cancelAction);
        pane.getActionMap().put("ENTER", okAction);
        return pane;
    }

    public void setProperties(JAMSProperties properties) {
        this.properties = properties;
        String[] libs = JAMSTools.toArray(properties.getProperty("libs"), ";");
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < libs.length; ++i) {
            v.add(libs[i]);
        }
        this.list.setListData(v);
        this.verboseCheck.setValue(properties.getProperty("verbose"));
        Integer debugLevel = 1;
        try {
            debugLevel = Integer.parseInt(properties.getProperty("debug"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.debugSpinner.setValue(debugLevel);
        this.errorFile.setFile(properties.getProperty("errorlog"));
        this.infoFile.setFile(properties.getProperty("infolog"));
        this.windowEnable.setValue(properties.getProperty("windowenable"));
        this.errorDlg.setValue(properties.getProperty("errordlg"));
        this.windowOnTop.setValue(properties.getProperty("windowontop"));
        this.windowHeight.setValue(properties.getProperty("windowheight"));
        this.windowWidth.setValue(properties.getProperty("windowwidth"));
    }

    public void validateProperties() {
        Vector<String> v = this.list.getListData();
        String libs = "";
        if (v.size() > 0) {
            libs = v.get(0);
        }
        for (int i = 1; i < v.size(); ++i) {
            libs = libs + ";" + v.get(i);
        }
        this.properties.setProperty("libs", libs);
        this.properties.setProperty("debug", this.debugSpinner.getValue().toString());
        this.properties.setProperty("verbose", this.verboseCheck.getValue());
        this.properties.setProperty("errorlog", this.errorFile.getFileName());
        this.properties.setProperty("infolog", this.infoFile.getFileName());
        this.properties.setProperty("windowenable", this.windowEnable.getValue());
        this.properties.setProperty("errordlg", this.errorDlg.getValue());
        this.properties.setProperty("windowontop", this.windowOnTop.getValue());
        this.properties.setProperty("windowheight", this.windowHeight.getValue());
        this.properties.setProperty("windowwidth", this.windowWidth.getValue());
    }

    public JAMSProperties getProperties() {
        this.validateProperties();
        return this.properties;
    }

    public int getResult() {
        return this.result;
    }
}

