/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Point;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.util.Range;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureResults;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.crs.ForceCoordinateSystemFeatureReader;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.BBoxExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.JTS;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.Renderer;
import org.geotools.renderer.Renderer2D;
import org.geotools.renderer.lite.BoundsExtractor;
import org.geotools.renderer.lite.Decimator;
import org.geotools.renderer.lite.ImageLoader;
import org.geotools.renderer.lite.IndexedFeatureResults;
import org.geotools.renderer.lite.Java2DMark;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.lite.LabelCacheDefault;
import org.geotools.renderer.lite.ListenerList;
import org.geotools.renderer.lite.LiteShape2;
import org.geotools.renderer.lite.StyledShapePainter;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRenderer;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleAttributeExtractor;
import org.geotools.styling.StyleFactoryFinder;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.NumberRange;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;

public class LiteRenderer
implements Renderer,
Renderer2D {
    private static final double TOLERANCE = 1.0E-6;
    private static final Logger LOGGER = Logger.getLogger("org.geotools.rendering");
    int error = 0;
    public static final DefaultRenderListener DEFAULT_LISTENER = new DefaultRenderListener();
    private FilterFactory filterFactory = FilterFactoryFinder.createFilterFactory();
    private static final CoordinateOperationFactory operationFactory;
    private static final MathTransformFactory mathTransformFactory;
    private MapContext context;
    private boolean interactive = true;
    private boolean concatTransforms = false;
    private Envelope mapExtent = null;
    private Graphics2D outputGraphics;
    private Rectangle screenSize;
    private boolean optimizedDataLoadingEnabled;
    private boolean renderingStopRequested;
    private double scaleDenominator;
    private double generalizationDistance = 1.0;
    private SLDStyleFactory styleFactory = new SLDStyleFactory();
    LabelCache labelCache = new LabelCacheDefault();
    private StyledShapePainter painter = new StyledShapePainter(this.labelCache);
    private HashMap transformMap = new HashMap();
    private boolean canTransform = true;
    private boolean memoryPreloadingEnabled;
    private IndexedFeatureResults indexedFeatureResults;
    private ListenerList renderListeners = new ListenerList();
    private RenderingHints hints;
    HashMap decimators = new HashMap();
    private static Canvas obs;
    private static Set supportedGraphicFormats;
    private static ImageLoader imageLoader;
    private static Set wellKnownMarks;
    private static Point markCentrePoint;
    private static final Map joinLookup;
    private static final Map capLookup;
    private static final Composite DEFAULT_COMPOSITE;

    public LiteRenderer() {
        this.addRenderListener(DEFAULT_LISTENER);
    }

    public LiteRenderer(MapContext context) {
        this();
        this.context = context;
    }

    public void setConcatTransforms(boolean flag) {
        this.concatTransforms = flag;
    }

    public static long getImageLoadingTimeout() {
        return ImageLoader.getTimeout();
    }

    public static void setImageLoadingTimeout(long newTimeout) {
        ImageLoader.setTimeout(newTimeout);
    }

    public boolean getConcatTransforms() {
        return this.concatTransforms;
    }

    public void setOutput(Graphics g, Rectangle bounds) {
        this.outputGraphics = (Graphics2D)g;
        this.screenSize = bounds;
    }

    public void addRenderListener(RenderListener listener) {
        this.renderListeners.add(listener);
    }

    public void removeRenderListener(RenderListener listener) {
        this.renderListeners.remove(listener);
    }

    private void fireFeatureRenderedEvent(Feature feature) {
        Object[] objects = this.renderListeners.getListeners();
        for (int i = 0; i < objects.length; ++i) {
            RenderListener listener = (RenderListener)objects[i];
            listener.featureRenderer(feature);
        }
    }

    private void fireErrorEvent(Exception e) {
        Object[] objects = this.renderListeners.getListeners();
        for (int i = 0; i < objects.length; ++i) {
            RenderListener listener = (RenderListener)objects[i];
            listener.errorOccurred(e);
        }
    }

    protected void setScaleDenominator(double scaleDenominator) {
        this.scaleDenominator = scaleDenominator;
    }

    public void stopRendering() {
        this.renderingStopRequested = true;
        this.labelCache.stop();
    }

    public void paint(Graphics2D graphics, Rectangle paintArea, AffineTransform transform) {
        AffineTransform pixelToWorld = null;
        try {
            pixelToWorld = transform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            this.fireErrorEvent(new Exception("Can't create pixel to world transform", e));
        }
        Point2D.Double p1 = new Point2D.Double();
        Point2D.Double p2 = new Point2D.Double();
        pixelToWorld.transform(new Point2D.Double(paintArea.getMinX(), paintArea.getMinY()), p1);
        pixelToWorld.transform(new Point2D.Double(paintArea.getMaxX(), paintArea.getMaxY()), p2);
        double x1 = ((Point2D)p1).getX();
        double y1 = ((Point2D)p1).getY();
        double x2 = ((Point2D)p2).getX();
        double y2 = ((Point2D)p2).getY();
        Envelope envelope = new Envelope(Math.min(x1, x2), Math.max(x1, x2), Math.min(y1, y2), Math.max(y1, y2));
        this.paint(graphics, paintArea, envelope);
    }

    public void paint(Graphics2D graphics, Rectangle paintArea, Envelope envelope) {
        AffineTransform transform = this.worldToScreenTransform(envelope, paintArea);
        this.error = 0;
        if (this.hints != null) {
            graphics.setRenderingHints(this.hints);
        }
        if (graphics == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        this.renderingStopRequested = false;
        AffineTransform at = transform;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Affine Transform is " + at);
        }
        if (this.concatTransforms) {
            AffineTransform atg = graphics.getTransform();
            atg.concatenate(at);
            at = atg;
        }
        try {
            this.setScaleDenominator(LiteRenderer.calculateScale(envelope, this.context.getCoordinateReferenceSystem(), paintArea.width, paintArea.height, 90.0));
        }
        catch (Exception e) {
            this.setScaleDenominator(1.0 / at.getScaleX());
        }
        MapLayer[] layers = this.context.getLayers();
        CoordinateReferenceSystem destinationCrs = this.context.getCoordinateReferenceSystem();
        this.labelCache.start();
        for (int i = 0; i < layers.length; ++i) {
            MapLayer currLayer = layers[i];
            if (!currLayer.isVisible()) continue;
            if (this.renderingStopRequested) {
                return;
            }
            this.labelCache.startLayer();
            try {
                FeatureResults results = this.queryLayer(currLayer, envelope, destinationCrs);
                this.processStylers(graphics, results, currLayer.getStyle().getFeatureTypeStyles(), at, this.context.getCoordinateReferenceSystem(), currLayer.getFeatureSource().getSchema().getDefaultGeometry().getCoordinateSystem());
            }
            catch (Exception exception) {
                this.fireErrorEvent(new Exception("Exception rendering layer " + currLayer, exception));
            }
            this.labelCache.endLayer(graphics, this.screenSize);
        }
        this.labelCache.end(graphics, paintArea);
        LOGGER.fine("Style cache hit ratio: " + this.styleFactory.getHitRatio() + " , hits " + this.styleFactory.getHits() + ", requests " + this.styleFactory.getRequests());
        if (this.error > 0) {
            LOGGER.warning("Number of Errors during paint(Graphics2D, AffineTransform) = " + this.error);
        }
    }

    public static double calculateScale(Envelope envelope, CoordinateReferenceSystem coordinateReferenceSystem, int imageWidth, int imageHeight, double DPI) throws Exception {
        double diagonalGroundDistance = org.geotools.geometry.jts.JTS.orthodromicDistance((Coordinate)new Coordinate(envelope.getMinX(), envelope.getMinY()), (Coordinate)new Coordinate(envelope.getMaxX(), envelope.getMaxY()), (CoordinateReferenceSystem)coordinateReferenceSystem);
        double diagonalPixelDistancePixels = Math.sqrt(imageWidth * imageWidth + imageHeight * imageHeight);
        double diagonalPixelDistanceMeters = diagonalPixelDistancePixels / DPI * 2.54 / 100.0;
        return diagonalGroundDistance / diagonalPixelDistanceMeters;
    }

    FeatureResults queryLayer(MapLayer currLayer, Envelope envelope, CoordinateReferenceSystem destinationCrs) throws IllegalFilterException, IOException, IllegalAttributeException {
        Query definitionQuery;
        Object results = null;
        FeatureSource featureSource = currLayer.getFeatureSource();
        FeatureType schema = featureSource.getSchema();
        Query query = Query.ALL;
        MathTransform transform = null;
        if (this.optimizedDataLoadingEnabled) {
            String[] attributes = this.findStyleAttributes(currLayer, schema);
            try {
                CoordinateReferenceSystem sourceCrs = currLayer.getFeatureSource().getSchema().getDefaultGeometry().getCoordinateSystem();
                if (sourceCrs != null && !sourceCrs.equals(destinationCrs)) {
                    transform = operationFactory.createOperation(destinationCrs, sourceCrs).getMathTransform();
                    if (transform != null && !transform.isIdentity()) {
                        envelope = JTS.transform((Envelope)envelope, (MathTransform)transform, (int)10);
                    } else {
                        transform = null;
                    }
                }
                BoundsExtractor extractor = new BoundsExtractor(envelope);
                currLayer.getQuery().getFilter().accept((FilterVisitor)extractor);
                envelope = extractor.getBBox();
                Filter filter = null;
                if (!this.memoryPreloadingEnabled) {
                    BBoxExpression rightBBox = this.filterFactory.createBBoxExpression(envelope);
                    filter = this.createBBoxFilters(schema, attributes, rightBBox);
                } else {
                    filter = Filter.NONE;
                }
                DefaultQuery q = new DefaultQuery(schema.getTypeName());
                q.setFilter(filter);
                q.setPropertyNames(attributes);
                query = q;
            }
            catch (Exception e) {
                this.fireErrorEvent(new Exception("Error transforming bbox", e));
                this.canTransform = false;
                DefaultQuery q = new DefaultQuery(schema.getTypeName());
                q.setPropertyNames(attributes);
                if (envelope.intersects(featureSource.getBounds())) {
                    LOGGER.fine("Got a tranform exception while trying to de-project the current envelope, bboxs intersect therefore using envelope)");
                    BoundsExtractor extractor = new BoundsExtractor(envelope);
                    currLayer.getQuery().getFilter().accept((FilterVisitor)extractor);
                    envelope = extractor.getBBox();
                    Filter filter = null;
                    BBoxExpression rightBBox = this.filterFactory.createBBoxExpression(envelope);
                    filter = this.createBBoxFilters(schema, attributes, rightBBox);
                    q.setFilter(filter);
                } else {
                    LOGGER.fine("Got a tranform exception while trying to de-project the current envelope, falling back on full data loading (no bbox query)");
                    q.setFilter(Filter.NONE);
                }
                query = q;
            }
        }
        if ((definitionQuery = currLayer.getQuery()) != Query.ALL) {
            query = query == Query.ALL ? definitionQuery : DataUtilities.mixQueries((Query)definitionQuery, (Query)query, (String)"liteRenderer");
        }
        if (!(query instanceof DefaultQuery)) {
            query = new DefaultQuery(query);
        }
        ((DefaultQuery)query).setCoordinateSystem(currLayer.getFeatureSource().getSchema().getDefaultGeometry().getCoordinateSystem());
        if (this.memoryPreloadingEnabled) {
            if (this.indexedFeatureResults == null) {
                this.indexedFeatureResults = new IndexedFeatureResults((FeatureResults)featureSource.getFeatures(query));
            }
            this.indexedFeatureResults.setQueryBounds(envelope);
            results = this.indexedFeatureResults;
        } else {
            results = featureSource.getFeatures(query);
        }
        return results;
    }

    private String[] findStyleAttributes(MapLayer layer, FeatureType schema) {
        StyleAttributeExtractor sae = new StyleAttributeExtractor();
        sae.visit(layer.getStyle());
        String[] ftsAttributes = sae.getAttributeNames();
        LinkedList<String> atts = new LinkedList<String>(Arrays.asList(ftsAttributes));
        AttributeType[] attTypes = schema.getAttributeTypes();
        for (int i = 0; i < attTypes.length; ++i) {
            String attName = attTypes[i].getName();
            if (!(attTypes[i] instanceof GeometryAttributeType) && !attTypes[i].getName().equalsIgnoreCase("grid") || atts.contains(attName)) continue;
            atts.add(attName);
            LOGGER.fine("added attribute " + attName);
        }
        ftsAttributes = new String[atts.size()];
        atts.toArray(ftsAttributes);
        return ftsAttributes;
    }

    private Filter createBBoxFilters(FeatureType schema, String[] attributes, BBoxExpression bbox) throws IllegalFilterException {
        Object filter = null;
        for (int j = 0; j < attributes.length; ++j) {
            AttributeType attType = schema.getAttributeType(attributes[j]);
            if (attType == null) {
                throw new IllegalFilterException("Could not find '" + attributes[j] + "' in the FeatureType (" + schema.getTypeName() + ")");
            }
            if (!(attType instanceof GeometryAttributeType)) continue;
            GeometryFilter gfilter = this.filterFactory.createGeometryFilter((short)4);
            AttributeExpression left = this.filterFactory.createAttributeExpression(schema, attType.getName());
            gfilter.addLeftGeometry((Expression)left);
            gfilter.addRightGeometry((Expression)bbox);
            filter = filter == null ? gfilter : filter.or((Filter)gfilter);
        }
        return filter;
    }

    public void render(FeatureCollection features, Envelope map, Style s) {
        if (this.outputGraphics == null) {
            LOGGER.info("renderer passed null graphics");
            return;
        }
        this.renderingStopRequested = false;
        this.mapExtent = map;
        AffineTransform at = this.worldToScreenTransform(this.mapExtent, this.screenSize);
        this.scaleDenominator = 1.0 / this.outputGraphics.getTransform().getScaleX();
        FeatureTypeStyle[] featureStylers = s.getFeatureTypeStyles();
        try {
            this.processStylers(this.outputGraphics, DataUtilities.results((FeatureCollection)features), featureStylers, at, null, null);
        }
        catch (IOException ioe) {
            this.fireErrorEvent(new Exception("I/O error while rendering the layer", ioe));
        }
        catch (IllegalAttributeException iae) {
            this.fireErrorEvent(new Exception("Illegal attribute exception while rendering the layer", iae));
        }
    }

    public AffineTransform worldToScreenTransform(Envelope mapExtent, Rectangle screenSize) {
        double scaleX = screenSize.getWidth() / mapExtent.getWidth();
        double scaleY = screenSize.getHeight() / mapExtent.getHeight();
        double tx = -mapExtent.getMinX() * scaleX;
        double ty = mapExtent.getMinY() * scaleY + screenSize.getHeight();
        AffineTransform at = new AffineTransform(scaleX, 0.0, 0.0, -scaleY, tx, ty);
        AffineTransform originTranslation = AffineTransform.getTranslateInstance(screenSize.x, screenSize.y);
        originTranslation.concatenate(at);
        return originTranslation != null ? originTranslation : at;
    }

    public Coordinate pixelToWorld(int x, int y, Envelope map) {
        if (this.outputGraphics == null) {
            LOGGER.info("no graphics yet deffined");
            return null;
        }
        AffineTransform at = this.worldToScreenTransform(map, this.screenSize);
        if (this.concatTransforms) {
            this.outputGraphics.getTransform().concatenate(at);
        } else {
            this.outputGraphics.setTransform(at);
        }
        try {
            Point2D result = at.inverseTransform(new Point2D.Double(x, y), new Point2D.Double());
            Coordinate c = new Coordinate(result.getX(), result.getY());
            return c;
        }
        catch (Exception e) {
            this.fireErrorEvent(e);
            return null;
        }
    }

    private boolean isWithInScale(Rule r) {
        return r.getMinScaleDenominator() - 1.0E-6 <= this.scaleDenominator && r.getMaxScaleDenominator() + 1.0E-6 > this.scaleDenominator;
    }

    private void processStylers(Graphics2D graphics, FeatureResults features, FeatureTypeStyle[] featureStylers, AffineTransform at, CoordinateReferenceSystem destinationCrs, CoordinateReferenceSystem sourceCrs) throws IOException, IllegalAttributeException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("processing " + featureStylers.length + " stylers for " + features.getSchema().getTypeName());
        }
        this.transformMap = new HashMap();
        for (int i = 0; i < featureStylers.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("processing style " + i);
            }
            FeatureTypeStyle fts = featureStylers[i];
            String typeName = features.getSchema().getTypeName();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.fine("... done: " + typeName);
            }
            if (typeName == null || !features.getSchema().isDescendedFrom(null, fts.getFeatureTypeName()) && !typeName.equalsIgnoreCase(fts.getFeatureTypeName())) continue;
            Rule[] rules = fts.getRules();
            ArrayList<Rule> ruleList = new ArrayList<Rule>();
            ArrayList<Rule> elseRuleList = new ArrayList<Rule>();
            for (int j = 0; j < rules.length; ++j) {
                Rule r;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("processing rule " + j);
                }
                if (!this.isWithInScale(r = rules[j])) continue;
                if (r.hasElseFilter()) {
                    elseRuleList.add(r);
                    continue;
                }
                ruleList.add(r);
            }
            if (ruleList.size() == 0 && elseRuleList.size() == 0) {
                return;
            }
            NumberRange scaleRange = new NumberRange(this.scaleDenominator, this.scaleDenominator);
            FeatureReader reader = features.reader();
            CoordinateReferenceSystem rCS = reader.getFeatureType().getDefaultGeometry().getCoordinateSystem();
            if (!(rCS == sourceCrs || sourceCrs == null || rCS != null && rCS.equals(sourceCrs))) {
                try {
                    reader = new ForceCoordinateSystemFeatureReader(reader, sourceCrs);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            while (true) {
                try {
                    while (!this.renderingStopRequested && reader.hasNext()) {
                        Rule r;
                        boolean doElse = true;
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.fine("trying to read Feature ...");
                        }
                        Feature feature = reader.next();
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("... done: " + feature.toString());
                        }
                        Iterator it = ruleList.iterator();
                        while (it.hasNext()) {
                            Filter filter;
                            r = (Rule)it.next();
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("applying rule: " + r.toString());
                            }
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("this rule applies ...");
                            }
                            if ((filter = r.getFilter()) != null && !filter.contains(feature)) continue;
                            doElse = false;
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("processing Symobolizer ...");
                            }
                            Symbolizer[] symbolizers = r.getSymbolizers();
                            this.processSymbolizers(graphics, feature, symbolizers, (Range)scaleRange, at, destinationCrs);
                            if (!LOGGER.isLoggable(Level.FINER)) continue;
                            LOGGER.finer("... done!");
                        }
                        if (doElse) {
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("rules with an else filter");
                            }
                            it = elseRuleList.iterator();
                            while (it.hasNext()) {
                                r = (Rule)it.next();
                                Symbolizer[] symbolizers = r.getSymbolizers();
                                if (LOGGER.isLoggable(Level.FINER)) {
                                    LOGGER.finer("processing Symobolizer ...");
                                }
                                this.processSymbolizers(graphics, feature, symbolizers, (Range)scaleRange, at, destinationCrs);
                                if (!LOGGER.isLoggable(Level.FINER)) continue;
                                LOGGER.finer("... done!");
                            }
                        }
                        if (!LOGGER.isLoggable(Level.FINER)) continue;
                        LOGGER.finer("feature rendered event ...");
                    }
                }
                catch (Exception e) {
                    this.fireErrorEvent(e);
                    continue;
                }
                break;
            }
            reader.close();
        }
    }

    private void processSymbolizers(Graphics2D graphics, Feature feature, Symbolizer[] symbolizers, Range scaleRange, AffineTransform at, CoordinateReferenceSystem destinationCrs) throws TransformException, FactoryException {
        for (int m = 0; m < symbolizers.length; ++m) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("applying symbolizer " + symbolizers[m]);
            }
            if (symbolizers[m] instanceof RasterSymbolizer) {
                AffineTransform tempTransform = graphics.getTransform();
                graphics.setTransform(at);
                this.renderRaster(graphics, feature, (RasterSymbolizer)symbolizers[m], destinationCrs);
                graphics.setTransform(tempTransform);
                continue;
            }
            Geometry g = this.findGeometry(feature, symbolizers[m]);
            CoordinateReferenceSystem crs = this.findGeometryCS(feature, symbolizers[m]);
            MathTransform2D transform = null;
            if (this.canTransform) {
                try {
                    transform = this.getMathTransform(crs, destinationCrs);
                    transform = transform != null ? (MathTransform2D)mathTransformFactory.createConcatenatedTransform((MathTransform)transform, mathTransformFactory.createAffineTransform((Matrix)new GeneralMatrix(at))) : (MathTransform2D)mathTransformFactory.createAffineTransform((Matrix)new GeneralMatrix(at));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            LiteShape2 shape = this.getTransformedShape(g, transform);
            if (symbolizers[m] instanceof TextSymbolizer) {
                this.labelCache.put((TextSymbolizer)symbolizers[m], feature, shape, scaleRange);
                continue;
            }
            Style2D style = this.styleFactory.createStyle(feature, symbolizers[m], scaleRange);
            this.painter.paint(graphics, shape, style, this.scaleDenominator);
        }
        this.fireFeatureRenderedEvent(feature);
    }

    private LiteShape2 getTransformedShape(Geometry g, MathTransform2D transform) throws TransformException, FactoryException {
        LiteShape2 shape = new LiteShape2(g, (MathTransform)transform, this.getDecimator(transform), false);
        return shape;
    }

    private Decimator getDecimator(MathTransform2D mathTransform) throws org.opengis.referencing.operation.NoninvertibleTransformException {
        Decimator decimator = (Decimator)this.decimators.get(mathTransform);
        if (decimator == null) {
            decimator = mathTransform != null && !mathTransform.isIdentity() ? new Decimator(mathTransform.inverse()) : new Decimator(null);
            this.decimators.put(mathTransform, decimator);
        }
        return decimator;
    }

    private MathTransform2D getMathTransform(CoordinateReferenceSystem sourceCrs, CoordinateReferenceSystem destinationCrs) throws OperationNotFoundException, FactoryException {
        MathTransform2D transform = (MathTransform2D)this.transformMap.get(sourceCrs);
        if (transform != null) {
            return transform;
        }
        if (sourceCrs == null || destinationCrs == null) {
            return null;
        }
        transform = (MathTransform2D)operationFactory.createOperation(sourceCrs, destinationCrs).getMathTransform();
        this.transformMap.put(sourceCrs, transform);
        return transform;
    }

    private void renderRaster(Graphics2D graphics, Feature feature, RasterSymbolizer symbolizer, CoordinateReferenceSystem destinationCRS) {
        LOGGER.fine("rendering Raster for feature " + feature.toString() + " - " + feature.getAttribute("grid"));
        float alpha = this.getOpacity(symbolizer);
        graphics.setComposite(AlphaComposite.getInstance(3, alpha));
        try {
            GridCoverageRenderer gcr = new GridCoverageRenderer(destinationCRS, this.mapExtent, this.screenSize);
            gcr.paint(graphics, (GridCoverage2D)feature.getAttribute("grid"), symbolizer);
            LOGGER.fine("Raster rendered");
        }
        catch (TransformException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (FactoryException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (NoninvertibleTransformException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    private float getOpacity(RasterSymbolizer sym) {
        float alpha = 1.0f;
        Expression exp = sym.getOpacity();
        if (exp == null) {
            return alpha;
        }
        Object obj = exp.getValue(null);
        if (obj == null) {
            return alpha;
        }
        Number num = null;
        if (obj instanceof Number) {
            num = (Number)obj;
        }
        if (num == null) {
            return alpha;
        }
        return num.floatValue();
    }

    private Geometry findGeometry(Feature f, Symbolizer s) {
        String geomName = this.getGeometryPropertyName(s);
        Geometry geom = geomName == null ? f.getDefaultGeometry() : (Geometry)f.getAttribute(geomName);
        if (s instanceof PointSymbolizer) {
            geom = this.getCentroid(geom);
        }
        return geom;
    }

    public Geometry getCentroid(Geometry g) {
        if (g instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)g;
            Coordinate[] pts = new Coordinate[gc.getNumGeometries()];
            for (int t = 0; t < gc.getNumGeometries(); ++t) {
                pts[t] = gc.getGeometryN(t).getCentroid().getCoordinate();
            }
            return g.getFactory().createMultiPoint(pts);
        }
        return g.getCentroid();
    }

    private CoordinateReferenceSystem findGeometryCS(Feature f, Symbolizer s) {
        String geomName = this.getGeometryPropertyName(s);
        if (geomName != null) {
            return ((GeometryAttributeType)f.getFeatureType().getAttributeType(geomName)).getCoordinateSystem();
        }
        return f.getFeatureType().getDefaultGeometry().getCoordinateSystem();
    }

    private String getGeometryPropertyName(Symbolizer s) {
        String geomName = null;
        if (s instanceof PolygonSymbolizer) {
            geomName = ((PolygonSymbolizer)s).getGeometryPropertyName();
        } else if (s instanceof PointSymbolizer) {
            geomName = ((PointSymbolizer)s).getGeometryPropertyName();
        } else if (s instanceof LineSymbolizer) {
            geomName = ((LineSymbolizer)s).getGeometryPropertyName();
        } else if (s instanceof TextSymbolizer) {
            geomName = ((TextSymbolizer)s).getGeometryPropertyName();
        }
        return geomName;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public boolean isOptimizedDataLoadingEnabled() {
        return this.optimizedDataLoadingEnabled;
    }

    public void setOptimizedDataLoadingEnabled(boolean b) {
        this.optimizedDataLoadingEnabled = b;
    }

    public double getGeneralizationDistance() {
        return this.generalizationDistance;
    }

    public void setGeneralizationDistance(double d) {
        this.generalizationDistance = d;
    }

    public void setMemoryPreloadingEnabled(boolean enabled) {
        this.memoryPreloadingEnabled = enabled;
        if (!enabled) {
            this.indexedFeatureResults = null;
        }
    }

    public void setRenderingHints(RenderingHints hints) {
        this.hints = hints;
    }

    public void setRenderingHint(RenderingHints.Key key, Object value) {
        if (this.hints == null) {
            this.hints = new RenderingHints(key, value);
        } else {
            this.hints.put(key, value);
        }
    }

    public void applyFill(Graphics2D graphic, Fill fill, Feature feature) {
        if (fill == null) {
            return;
        }
        graphic.setColor(Color.decode((String)fill.getColor().getValue(feature)));
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Setting fill: " + graphic.getColor().toString());
        }
        Number value = (Number)fill.getOpacity().getValue(feature);
        float opacity = value.floatValue();
        graphic.setComposite(AlphaComposite.getInstance(3, opacity));
        Graphic grd = fill.getGraphicFill();
        if (grd != null) {
            this.setTexture(graphic, grd, feature);
        } else if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("no graphic fill set");
        }
    }

    public void setTexture(Graphics2D graphic, Graphic gr, Feature feature) {
        BufferedImage image = this.getExternalGraphic(gr);
        if (image != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("got an image in graphic fill");
            }
        } else {
            Mark mark;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("going for the mark from graphic fill");
            }
            if ((mark = this.getMark(gr, feature)) == null) {
                mark = StyleFactoryFinder.createStyleFactory().getDefaultMark();
            }
            int size = 200;
            image = new BufferedImage(size, size, 2);
            Graphics2D g1 = image.createGraphics();
            double rotation = 0.0;
            rotation = ((Number)gr.getRotation().getValue(feature)).doubleValue();
            this.fillDrawMark(g1, markCentrePoint, mark, (int)((double)size * 0.9), rotation, 0, 0, feature);
            MediaTracker track = new MediaTracker(obs);
            track.addImage(image, 1);
            try {
                track.waitForID(1);
            }
            catch (InterruptedException e) {
                LOGGER.warning(e.toString());
            }
        }
        double width = image.getWidth();
        double height = image.getHeight();
        double unitSize = Math.max(width, height);
        int size = 6;
        size = ((Number)gr.getSize().getValue(feature)).intValue();
        double drawSize = (double)size / unitSize;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("size = " + size + " unitsize " + unitSize + " drawSize " + drawSize);
        }
        AffineTransform at = graphic.getTransform();
        double scaleX = drawSize / at.getScaleX();
        double scaleY = drawSize / -at.getScaleY();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("scale " + scaleX + " " + scaleY);
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, width *= scaleX, height *= scaleY);
        TexturePaint imagePaint = new TexturePaint(image, rect);
        graphic.setPaint(imagePaint);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("applied TexturePaint " + imagePaint);
        }
    }

    private BufferedImage getExternalGraphic(Graphic graphic) {
        ExternalGraphic[] extgraphics = graphic.getExternalGraphics();
        if (extgraphics != null) {
            for (int i = 0; i < extgraphics.length; ++i) {
                ExternalGraphic eg = extgraphics[i];
                BufferedImage img = this.getImage(eg);
                if (img == null) continue;
                return img;
            }
        }
        return null;
    }

    private BufferedImage getImage(ExternalGraphic eg) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("got a " + eg.getFormat());
        }
        if (LiteRenderer.getSupportedGraphicFormats().contains(eg.getFormat().toLowerCase())) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("a java supported format");
            }
            try {
                BufferedImage img = imageLoader.get(eg.getLocation(), this.isInteractive());
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Image return = " + img);
                }
                return img;
            }
            catch (MalformedURLException e) {
                LOGGER.warning("ExternalGraphicURL was badly formed");
            }
        }
        return null;
    }

    private static Set getSupportedGraphicFormats() {
        if (supportedGraphicFormats == null) {
            supportedGraphicFormats = new HashSet();
            String[] types = ImageIO.getReaderMIMETypes();
            for (int i = 0; i < types.length; ++i) {
                supportedGraphicFormats.add(types[i]);
            }
        }
        return supportedGraphicFormats;
    }

    private Mark getMark(Graphic graphic, Feature feature) {
        Mark[] marks = graphic.getMarks();
        Mark mark = null;
        for (int i = 0; i < marks.length; ++i) {
            String name = marks[i].getWellKnownName().getValue(feature).toString();
            if (!wellKnownMarks.contains(name)) continue;
            mark = marks[i];
            break;
        }
        return mark;
    }

    private void fillDrawMark(Graphics2D graphic, Point point, Mark mark, int size, double rotation, int xOffset, int yOffset, Feature feature) {
        this.fillDrawMark(graphic, point.getX(), point.getY(), mark, size, rotation, xOffset, yOffset, feature);
    }

    private void fillDrawMark(Graphics2D graphic, double tx, double ty, Mark mark, int size, double rotation, int xOffset, int yOffset, Feature feature) {
        AffineTransform temp = graphic.getTransform();
        AffineTransform markAT = new AffineTransform();
        Shape shape = Java2DMark.getWellKnownMark(mark.getWellKnownName().getValue(feature).toString());
        Point2D.Double mapCentre = new Point2D.Double(tx, ty);
        Point2D.Double graphicCentre = new Point2D.Double();
        temp.transform(mapCentre, graphicCentre);
        markAT.translate(((Point2D)graphicCentre).getX(), ((Point2D)graphicCentre).getY());
        double shearY = temp.getShearY();
        double scaleY = temp.getScaleY();
        double originalRotation = Math.atan(shearY / scaleY);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("originalRotation " + originalRotation);
        }
        markAT.rotate(rotation - originalRotation);
        Rectangle2D bounds = shape.getBounds2D();
        double unitSize = Math.max(bounds.getWidth(), bounds.getHeight());
        double drawSize = (double)size / unitSize;
        markAT.scale(drawSize, -drawSize);
        markAT.translate((double)xOffset / unitSize, (double)yOffset / unitSize);
        graphic.setTransform(markAT);
        if (mark.getFill() != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("applying fill to mark");
            }
            this.applyFill(graphic, mark.getFill(), feature);
            graphic.fill(shape);
        }
        if (mark.getStroke() != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("applying stroke to mark");
            }
            this.applyStroke(graphic, mark.getStroke(), feature);
            graphic.draw(shape);
        }
        graphic.setTransform(temp);
        if (mark.getFill() != null) {
            this.resetFill(graphic);
        }
    }

    private void applyStroke(Graphics2D graphic, Stroke stroke, Feature feature) {
        Graphic gr;
        BasicStroke stroke2d;
        String joinType;
        if (stroke == null) {
            return;
        }
        double scale = graphic.getTransform().getScaleX();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("line join = " + stroke.getLineJoin());
        }
        if ((joinType = stroke.getLineJoin() == null ? "miter" : (String)stroke.getLineJoin().getValue(feature)) == null) {
            joinType = "miter";
        }
        int joinCode = joinLookup.containsKey(joinType) ? (Integer)joinLookup.get(joinType) : 0;
        String capType = stroke.getLineCap() != null ? (String)stroke.getLineCap().getValue(feature) : "square";
        if (capType == null) {
            capType = "square";
        }
        int capCode = capLookup.containsKey(capType) ? (Integer)capLookup.get(capType) : 2;
        float[] dashes = stroke.getDashArray();
        if (dashes != null) {
            for (int i = 0; i < dashes.length; ++i) {
                dashes[i] = Math.max(1.0f, dashes[i] / (float)scale);
            }
        }
        Number value = (Number)stroke.getWidth().getValue(feature);
        float width = value.floatValue();
        value = (Number)stroke.getDashOffset().getValue(feature);
        float dashOffset = value.floatValue();
        value = (Number)stroke.getOpacity().getValue(feature);
        float opacity = value.floatValue();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("width, dashoffset, opacity " + width + " " + dashOffset + " " + opacity);
        }
        if (dashes != null && dashes.length > 0) {
            if ((double)width <= 1.0) {
                width = 0.0f;
            }
            stroke2d = new BasicStroke(width / (float)scale, capCode, joinCode, 1.0f, dashes, dashOffset / (float)scale);
        } else {
            if ((double)width <= 1.0) {
                width = 0.0f;
            }
            stroke2d = new BasicStroke(width / (float)scale, capCode, joinCode, 1.0f);
        }
        graphic.setComposite(AlphaComposite.getInstance(3, opacity));
        if (!graphic.getStroke().equals(stroke2d)) {
            graphic.setStroke(stroke2d);
        }
        Color color = Color.decode((String)stroke.getColor().getValue(feature));
        if (!graphic.getColor().equals(color)) {
            graphic.setColor(color);
        }
        if ((gr = stroke.getGraphicFill()) != null) {
            this.setTexture(graphic, gr, feature);
        } else if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("no graphic fill set");
        }
    }

    private void resetFill(Graphics2D graphic) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("reseting the graphics");
        }
        graphic.setComposite(DEFAULT_COMPOSITE);
    }

    static {
        Hints hints = new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
        operationFactory = FactoryFinder.getCoordinateOperationFactory((Hints)hints);
        hints = new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
        mathTransformFactory = FactoryFinder.getMathTransformFactory((Hints)hints);
        obs = new Canvas();
        imageLoader = new ImageLoader();
        wellKnownMarks = new HashSet();
        joinLookup = new HashMap();
        capLookup = new HashMap();
        DEFAULT_COMPOSITE = AlphaComposite.getInstance(3, 1.0f);
    }

    private static class DefaultRenderListener
    implements RenderListener {
        private DefaultRenderListener() {
        }

        public void featureRenderer(Feature feature) {
        }

        public void errorOccurred(Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

