/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.unijena.jams.gui.input.BooleanInput;
import org.unijena.jams.gui.input.CalendarInput;
import org.unijena.jams.gui.input.FileInput;
import org.unijena.jams.gui.input.FloatInput;
import org.unijena.jams.gui.input.InputComponent;
import org.unijena.jams.gui.input.IntegerInput;
import org.unijena.jams.gui.input.TextInput;
import org.unijena.jams.gui.input.TimeintervalInput;

public class LHelper {
    private static final int JCOMP_HEIGHT = 20;
    private static final int NUMBERINPUT_WIDTH = 100;
    private static final int TEXTINPUT_WIDTH = 250;
    private static final int FILEINPUT_WIDTH = 250;

    public static void removeGBComponent(Container cont, Component c) {
        cont.remove(c);
    }

    public static Component addGBComponent(Container cont, GridBagLayout gbl, Component c, int x, int y, int width, int height, double weightx, double weighty) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(0, 2, 2, 2);
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbl.setConstraints(c, gbc);
        return cont.add(c);
    }

    public static Component addGBComponent(Container cont, GridBagLayout gbl, Component c, int x, int y, int width, int height, double weightx, double weighty, int fill, int anchor) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = fill;
        gbc.anchor = anchor;
        gbc.insets = new Insets(0, 2, 2, 2);
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbl.setConstraints(c, gbc);
        return cont.add(c);
    }

    public static int showYesNoCancelDlg(Component owner, String message, String title) {
        Object[] options = new Object[]{"Yes", "No", "Cancel"};
        int result = JOptionPane.showOptionDialog(owner, message, title, 1, 3, null, options, options[0]);
        return result;
    }

    public static int showYesNoDlg(Component owner, String message, String title) {
        Object[] options = new Object[]{"Yes", "No"};
        int result = JOptionPane.showOptionDialog(owner, message, title, 0, 3, null, options, options[0]);
        return result;
    }

    public static void showInfoDlg(Component owner, String message, String title) {
        JOptionPane.showMessageDialog(owner, message, title, 1);
    }

    public static void showErrorDlg(Component owner, String message, String title) {
        JOptionPane.showMessageDialog(owner, message, title, 0);
    }

    public static String showInputDlg(Component owner, String message, String initalValue) {
        return JOptionPane.showInputDialog(owner, message, initalValue);
    }

    public static InputComponent createInputComponent(String type) {
        JComponent ic;
        if (type.equals("JAMSFileName")) {
            ic = new FileInput();
            ((Component)ic).setPreferredSize(new Dimension(250, 20));
        } else if (type.equals("JAMSDirName")) {
            ic = new FileInput(true);
            ((Component)ic).setPreferredSize(new Dimension(250, 20));
        } else if (type.equals("JAMSCalendar")) {
            ic = new CalendarInput();
        } else if (type.equals("JAMSTimeInterval")) {
            ic = new TimeintervalInput();
        } else if (type.equals("JAMSBoolean")) {
            ic = new BooleanInput();
        } else if (type.equals("JAMSInteger") || type.equals("JAMSLong")) {
            ic = new IntegerInput();
            ic.getComponent().setPreferredSize(new Dimension(100, 20));
        } else if (type.equals("JAMSFloat") || type.equals("JAMSDouble")) {
            ic = new FloatInput();
            ic.getComponent().setPreferredSize(new Dimension(100, 20));
        } else {
            ic = new TextInput();
            ic.getComponent().setPreferredSize(new Dimension(250, 20));
        }
        ic.getComponent().setBorder(BorderFactory.createEtchedBorder());
        return ic;
    }
}

