/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.unijena.jams.JAMS;
import org.unijena.jams.JAMSFileFilter;
import org.unijena.jams.JAMSProperties;
import org.unijena.jams.JAMSTools;
import org.unijena.jams.gui.AboutDlg;
import org.unijena.jams.gui.LHelper;
import org.unijena.jams.gui.LogViewDlg;
import org.unijena.jams.gui.PropertyDlg;
import org.unijena.jams.gui.WorkerDlg;
import org.unijena.jams.gui.input.InputComponent;
import org.unijena.jams.io.XMLIO;
import org.unijena.jams.io.XMLProcessor;
import org.unijena.jams.runtime.JAMSRuntime;
import org.unijena.jams.runtime.StandardRuntime;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JAMSLauncher
extends JFrame {
    public static final int APPROVE_OPTION = 1;
    public static final int EXIT_OPTION = 0;
    private static final String baseTitle = "JAMS Launcher";
    private int result = 0;
    private Map<InputComponent, Element> inputMap;
    private Map<InputComponent, JScrollPane> groupMap;
    private String modelFilename;
    private Document modelDocument = null;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JAMSProperties properties;
    private JButton resetButton;
    private JButton runButton;
    private JMenuItem saveItem;
    private JMenuItem saveAsItem;
    private PropertyDlg propertyDlg;
    private JFileChooser jfc = new JFileChooser();
    private LogViewDlg infoDlg = new LogViewDlg((Frame)this, 400, 400, "Info Log");
    private LogViewDlg errorDlg = new LogViewDlg((Frame)this, 400, 400, "Error Log");
    private JMenuBar mainMenu;
    private JMenu logsMenu;
    private String initialModelDocString = "";
    private JAMSRuntime runtime;
    private Runnable modelLoading;
    private WorkerDlg setupModelDlg;

    public JAMSLauncher(JAMSProperties properties) {
        this.properties = properties;
        this.init();
    }

    public JAMSLauncher(String modelFilename, JAMSProperties properties, String cmdLineArgs) {
        this(properties);
        this.loadModelDefinition(modelFilename, JAMSTools.toArray(cmdLineArgs, ";"));
    }

    protected void loadModelDefinition(String modelFilename, String[] args) {
        if (!this.closeModel()) {
            return;
        }
        try {
            File file = new File(modelFilename);
            if (!file.exists()) {
                LHelper.showErrorDlg(this, "Model file " + modelFilename + " could not be found!", "File open error");
                return;
            }
            String newModelFilename = XMLProcessor.modelDocConverter(modelFilename);
            if (!newModelFilename.equalsIgnoreCase(modelFilename)) {
                LHelper.showInfoDlg(this, "The model definition in \"" + modelFilename + "\" has been adapted in order to meet modifications of the JAMS model DTD.\nThe new definition has been stored in \"" + newModelFilename + "\" while your original file was left untouched.", "Info");
                this.modelFilename = newModelFilename;
            } else {
                this.modelFilename = modelFilename;
            }
            String xmlString = JAMSTools.fileToString(modelFilename);
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    xmlString = xmlString.replaceAll("%" + i, args[i]);
                }
            }
            this.modelDocument = XMLIO.getDocumentFromString(xmlString);
            this.initialModelDocString = XMLIO.getStringFromDocument(this.modelDocument);
            this.modelFilename = modelFilename;
            this.fillTabbedPane(this.getModelDocument());
        }
        catch (IOException ioe) {
            LHelper.showErrorDlg(this, "The specified model configuration file \"" + modelFilename + "\" could not be found!", "Error");
        }
        catch (SAXException se) {
            LHelper.showErrorDlg(this, "The specified model configuration file \"" + modelFilename + "\" contains errors!", "Error");
        }
    }

    private void init() throws HeadlessException, DOMException, NumberFormatException {
        this.modelLoading = new Runnable(){

            @Override
            public void run() {
                Document modelDocCopy = (Document)JAMSLauncher.this.getModelDocument().cloneNode(true);
                JAMSLauncher.this.runtime = new StandardRuntime();
                JAMSLauncher.this.runtime.addInfoLogObserver(new Observer(){

                    @Override
                    public void update(Observable obs, Object obj) {
                        JAMSLauncher.this.getInfoDlg().appendText(obj.toString());
                    }
                });
                JAMSLauncher.this.runtime.addErrorLogObserver(new Observer(){

                    @Override
                    public void update(Observable obs, Object obj) {
                        LHelper.showErrorDlg(JAMSLauncher.this, "An error has occurred! Please check the error log for further information!", "JAMS Error");
                        JAMSLauncher.this.getErrorDlg().appendText(obj.toString());
                    }
                });
                JAMSLauncher.this.runtime.loadModel(modelDocCopy, JAMSLauncher.this.getProperties());
            }
        };
        this.setupModelDlg = new WorkerDlg((Frame)this, "Setting up the model");
        this.propertyDlg = new PropertyDlg((Frame)this, this.getProperties());
        this.setLocationByPlatform(true);
        this.setLayout(new BorderLayout());
        int width = Integer.parseInt(this.getProperties().getProperty("guiconfigwidth", "600"));
        int height = Integer.parseInt(this.getProperties().getProperty("guiconfigheight", "400"));
        this.setPreferredSize(new Dimension(width, height));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                JAMSLauncher.this.exit();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        this.setIconImage(new ImageIcon(ClassLoader.getSystemResource("resources/images/JAMSicon16.png")).getImage());
        this.setTitle(this.getBaseTitle());
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                JAMSLauncher.this.exit();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        this.runButton = new JButton();
        this.runButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ModelRun.png")));
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        JAMSLauncher.this.runModel();
                        Runtime.getRuntime().gc();
                    }
                };
                t.start();
            }
        });
        this.runButton.setEnabled(false);
        this.resetButton = new JButton("Default");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (InputComponent ic : JAMSLauncher.this.getInputMap().keySet()) {
                    Element element = JAMSLauncher.this.getInputMap().get(ic);
                    ic.setValue(element.getAttribute("default"));
                }
            }
        });
        this.resetButton.setEnabled(false);
        this.mainMenu = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem loadItem = new JMenuItem("Load Model");
        loadItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File file = null;
                file = JAMSLauncher.this.modelFilename != null ? new File(JAMSLauncher.this.modelFilename) : new File(System.getProperty("user.dir"));
                JAMSLauncher.this.jfc.setCurrentDirectory(file);
                JAMSLauncher.this.jfc.setFileFilter(JAMSFileFilter.getModelFilter());
                if (JAMSLauncher.this.jfc.showOpenDialog(JAMSLauncher.this) == 0) {
                    String modelFilename = JAMSLauncher.this.jfc.getSelectedFile().getAbsolutePath();
                    JAMSLauncher.this.loadModelDefinition(modelFilename, null);
                }
            }
        });
        loadItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        fileMenu.add(loadItem);
        this.saveItem = new JMenuItem("Save Model");
        this.saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JAMSLauncher.this.saveModel();
            }
        });
        this.saveItem.setEnabled(false);
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        fileMenu.add(this.saveItem);
        this.saveAsItem = new JMenuItem("Save Model As...");
        this.saveAsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File file = null;
                file = JAMSLauncher.this.modelFilename != null ? new File(JAMSLauncher.this.modelFilename) : new File(System.getProperty("user.dir"));
                JAMSLauncher.this.jfc.setCurrentDirectory(file);
                JAMSLauncher.this.jfc.setFileFilter(JAMSFileFilter.getModelFilter());
                if (JAMSLauncher.this.jfc.showSaveDialog(JAMSLauncher.this) == 0) {
                    JAMSLauncher.this.modelFilename = JAMSLauncher.this.jfc.getSelectedFile().getAbsolutePath();
                    JAMSLauncher.this.saveModel();
                }
            }
        });
        this.saveAsItem.setEnabled(false);
        fileMenu.add(this.saveAsItem);
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JAMSLauncher.this.exit();
            }
        });
        exitItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        fileMenu.add(exitItem);
        this.getMainMenu().add(fileMenu);
        JMenu editMenu = new JMenu("Edit");
        JMenuItem editOptionsItem = new JMenuItem("Edit Options");
        editOptionsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAMSLauncher.this.propertyDlg.setProperties(JAMSLauncher.this.getProperties());
                JAMSLauncher.this.propertyDlg.setVisible(true);
                if (JAMSLauncher.this.propertyDlg.getResult() == 1) {
                    JAMSLauncher.this.propertyDlg.validateProperties();
                }
            }
        });
        editMenu.add(editOptionsItem);
        JMenuItem loadOptionsItem = new JMenuItem("Load Options");
        loadOptionsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAMSLauncher.this.jfc.setFileFilter(JAMSFileFilter.getPropertyFilter());
                JAMSLauncher.this.jfc.setSelectedFile(new File(JAMSLauncher.this.getProperties().getDefaultFilename()));
                int result = JAMSLauncher.this.jfc.showOpenDialog(JAMSLauncher.this);
                if (result == 0) {
                    String stringValue = JAMSLauncher.this.jfc.getSelectedFile().getAbsolutePath();
                    try {
                        JAMSLauncher.this.getProperties().load(stringValue);
                    }
                    catch (IOException ioe) {
                        JAMS.handle(ioe);
                    }
                }
            }
        });
        editMenu.add(loadOptionsItem);
        JMenuItem saveOptionsItem = new JMenuItem("Save Options as...");
        saveOptionsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAMSLauncher.this.jfc.setFileFilter(JAMSFileFilter.getPropertyFilter());
                JAMSLauncher.this.jfc.setSelectedFile(new File(JAMSLauncher.this.getProperties().getDefaultFilename()));
                int result = JAMSLauncher.this.jfc.showSaveDialog(JAMSLauncher.this);
                if (result == 0) {
                    String stringValue = JAMSLauncher.this.jfc.getSelectedFile().getAbsolutePath();
                    try {
                        JAMSLauncher.this.getProperties().save(stringValue);
                    }
                    catch (IOException ioe) {
                        JAMS.handle(ioe);
                    }
                }
            }
        });
        editMenu.add(saveOptionsItem);
        this.getMainMenu().add(editMenu);
        this.logsMenu = new JMenu("Logs");
        JMenuItem infoLogItem = new JMenuItem("Model info log");
        infoLogItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAMSLauncher.this.getInfoDlg().setVisible(true);
            }
        });
        this.getLogsMenu().add(infoLogItem);
        JMenuItem errorLogItem = new JMenuItem("Model error log");
        errorLogItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAMSLauncher.this.getErrorDlg().setVisible(true);
            }
        });
        this.getLogsMenu().add(errorLogItem);
        this.getMainMenu().add(this.getLogsMenu());
        JMenu helpMenu = new JMenu("Help");
        JMenuItem aboutItem = new JMenuItem("About");
        aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new AboutDlg(null).setVisible(true);
            }
        });
        helpMenu.add(aboutItem);
        this.getMainMenu().add(helpMenu);
        this.setJMenuBar(this.getMainMenu());
        this.tabbedPane.setTabPlacement(2);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        JToolBar toolBar = new JToolBar();
        toolBar.setPreferredSize(new Dimension(0, 40));
        toolBar.add(this.runButton);
        this.getContentPane().add((Component)toolBar, "North");
        this.pack();
    }

    protected boolean verifyInputs() {
        for (InputComponent ic : this.getInputMap().keySet()) {
            if (ic.verify()) continue;
            this.tabbedPane.setSelectedComponent(this.getGroupMap().get(ic));
            Color oldColor = ic.getComponent().getBackground();
            ic.getComponent().setBackground(new Color(255, 0, 0));
            if (ic.getErrorCode() == -2) {
                LHelper.showErrorDlg(this, "Selected value out of range!", "Range error");
            } else {
                LHelper.showErrorDlg(this, "Invalid value!", "Format error");
            }
            ic.getComponent().setBackground(oldColor);
            return false;
        }
        return true;
    }

    private void fillTabbedPane(Document doc) {
        this.tabbedPane.removeAll();
        this.inputMap = new HashMap<InputComponent, Element>();
        this.groupMap = new HashMap<InputComponent, JScrollPane>();
        Element root = doc.getDocumentElement();
        this.setTitle(this.getBaseTitle() + ": " + root.getAttribute("name") + " [" + this.modelFilename + "]");
        Element config = (Element)root.getElementsByTagName("launcher").item(0);
        NodeList groups = config.getElementsByTagName("group");
        for (int i = 0; i < groups.getLength(); ++i) {
            JPanel contentPanel = new JPanel();
            GridBagLayout gbl = new GridBagLayout();
            contentPanel.setLayout(gbl);
            JPanel scrollPanel = new JPanel();
            scrollPanel.add(contentPanel);
            JScrollPane scrollPane = new JScrollPane(scrollPanel);
            Element group = (Element)groups.item(i);
            int y = 0;
            NodeList properties = group.getElementsByTagName("property");
            for (int j = 0; j < properties.getLength(); ++j) {
                String lenStr;
                Element property = (Element)properties.item(j);
                LHelper.addGBComponent(contentPanel, gbl, new JLabel(property.getAttribute("name")), 0, y, 1, 1, 0.0, 0.0);
                InputComponent ic = LHelper.createInputComponent(property.getAttribute("type"));
                StringTokenizer tok = new StringTokenizer(property.getAttribute("range"), ";");
                if (tok.countTokens() == 2) {
                    String lower = tok.nextToken();
                    String upper = tok.nextToken();
                    ic.setRange(Double.parseDouble(lower), Double.parseDouble(upper));
                }
                if ((lenStr = property.getAttribute("length")) != null && lenStr.length() > 0) {
                    ic.setLength(Integer.parseInt(lenStr));
                }
                ic.getComponent().setToolTipText(property.getAttribute("description"));
                ic.setValue(property.getAttribute("value"));
                this.getInputMap().put(ic, property);
                this.getGroupMap().put(ic, scrollPane);
                LHelper.addGBComponent(contentPanel, gbl, (Component)((Object)ic), 1, y, 2, 1, 1.0, 1.0);
                ++y;
            }
            this.tabbedPane.addTab(group.getAttribute("name"), scrollPane);
        }
        this.runButton.setEnabled(true);
        this.resetButton.setEnabled(true);
        this.saveItem.setEnabled(true);
        this.saveAsItem.setEnabled(true);
    }

    private boolean closeModel() {
        String modelDocString;
        if (this.modelDocument == null) {
            return true;
        }
        for (InputComponent ic : this.getInputMap().keySet()) {
            Element element = this.getInputMap().get(ic);
            element.setAttribute("value", ic.getValue());
        }
        if (this.modelDocument != null && !this.initialModelDocString.equals(modelDocString = XMLIO.getStringFromDocument(this.modelDocument))) {
            int result = LHelper.showYesNoCancelDlg(this, "Save modifications in " + this.modelFilename + "?", "JAMS Launcher: unsaved modifications");
            if (result == 2) {
                return false;
            }
            if (result == 0) {
                this.saveModel();
            }
        }
        return true;
    }

    private void exit() {
        if (!this.closeModel()) {
            return;
        }
        try {
            String defaultFile = this.getProperties().getDefaultFilename();
            this.getProperties().save(defaultFile);
        }
        catch (IOException ioe) {
            JAMS.handle(ioe);
        }
        this.dispose();
        System.exit(0);
    }

    protected void runModel() {
        if (!this.verifyInputs()) {
            return;
        }
        for (InputComponent ic : this.getInputMap().keySet()) {
            Element element = this.getInputMap().get(ic);
            element.setAttribute("value", ic.getValue());
        }
        this.setupModelDlg.setTask(this.modelLoading);
        this.setupModelDlg.execute();
        Thread t = new Thread(){

            @Override
            public void run() {
                JAMSLauncher.this.runtime.runModel();
                JAMSLauncher.this.getInfoDlg().appendText("\n\n");
                JAMSLauncher.this.getErrorDlg().appendText("\n\n");
                JAMSLauncher.this.runtime = null;
                Runtime.getRuntime().gc();
            }
        };
        try {
            t.start();
        }
        catch (Exception e) {
            this.runtime.handle(e);
        }
    }

    private void saveModel() {
        for (InputComponent ic : this.getInputMap().keySet()) {
            Element element = this.getInputMap().get(ic);
            element.setAttribute("value", ic.getValue());
        }
        try {
            XMLIO.writeXmlFile(this.getModelDocument(), this.modelFilename);
        }
        catch (IOException ioe) {
            LHelper.showErrorDlg(this, "Error saving configuration to " + this.modelFilename, "Error");
            return;
        }
        LHelper.showInfoDlg(this, "Configuration has been saved to " + this.modelFilename, "Info");
    }

    public int getResult() {
        return this.result;
    }

    protected String getBaseTitle() {
        return baseTitle;
    }

    public JMenuBar getMainMenu() {
        return this.mainMenu;
    }

    protected JAMSProperties getProperties() {
        return this.properties;
    }

    public Map<InputComponent, Element> getInputMap() {
        return this.inputMap;
    }

    public Map<InputComponent, JScrollPane> getGroupMap() {
        return this.groupMap;
    }

    protected JMenu getLogsMenu() {
        return this.logsMenu;
    }

    protected JButton getRunButton() {
        return this.runButton;
    }

    protected Document getModelDocument() {
        return this.modelDocument;
    }

    protected LogViewDlg getInfoDlg() {
        return this.infoDlg;
    }

    protected LogViewDlg getErrorDlg() {
        return this.errorDlg;
    }
}

