/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.data;

import com.vividsolutions.jts.geom.Geometry;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSFloat;
import org.unijena.jams.data.JAMSGeometry;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSLong;

class JAMSCheckedEntity
implements JAMSEntity {
    private HashMap<String, Object> values = new HashMap();

    JAMSCheckedEntity() {
    }

    @Override
    public void setFloat(String name, float attribute) {
        JAMSFloat v = (JAMSFloat)this.values.get(name);
        try {
            v.setValue(attribute);
        }
        catch (NullPointerException npe) {
            this.values.put(name, new JAMSFloat(attribute));
        }
    }

    @Override
    public void setDouble(String name, double attribute) {
        JAMSDouble v = (JAMSDouble)this.values.get(name);
        try {
            v.setValue(attribute);
        }
        catch (NullPointerException npe) {
            this.values.put(name, new JAMSDouble(attribute));
        }
    }

    @Override
    public void setInt(String name, int attribute) {
        JAMSInteger v = (JAMSInteger)this.values.get(name);
        try {
            v.setValue(attribute);
        }
        catch (NullPointerException npe) {
            this.values.put(name, new JAMSInteger(attribute));
        }
    }

    @Override
    public void setLong(String name, long attribute) {
        JAMSLong v = (JAMSLong)this.values.get(name);
        try {
            v.setValue(attribute);
        }
        catch (NullPointerException npe) {
            this.values.put(name, new JAMSLong(attribute));
        }
    }

    @Override
    public void setObject(String name, Object attribute) {
        this.values.put(name, attribute);
    }

    @Override
    public void setGeometry(String name, Geometry attribute) {
        JAMSGeometry v = (JAMSGeometry)this.values.get(name);
        try {
            v.setValue(attribute);
        }
        catch (NullPointerException npe) {
            this.values.put(name, new JAMSGeometry(attribute));
        }
    }

    @Override
    public float getFloat(String name) throws JAMSEntity.NoSuchAttributeException {
        if (this.values.containsKey(name)) {
            return ((JAMSFloat)this.values.get(name)).getValue();
        }
        throw new JAMSEntity.NoSuchAttributeException("Attribute " + name + " (float) not found!");
    }

    @Override
    public double getDouble(String name) throws JAMSEntity.NoSuchAttributeException {
        if (this.values.containsKey(name)) {
            return ((JAMSDouble)this.values.get(name)).getValue();
        }
        throw new JAMSEntity.NoSuchAttributeException("Attribute " + name + " (double) not found!");
    }

    @Override
    public int getInt(String name) throws JAMSEntity.NoSuchAttributeException {
        if (this.values.containsKey(name)) {
            return ((JAMSInteger)this.values.get(name)).getValue();
        }
        throw new JAMSEntity.NoSuchAttributeException("Attribute " + name + " (int) not found!");
    }

    @Override
    public long getLong(String name) throws JAMSEntity.NoSuchAttributeException {
        if (this.values.containsKey(name)) {
            return ((JAMSLong)this.values.get(name)).getValue();
        }
        throw new JAMSEntity.NoSuchAttributeException("Attribute " + name + " (long) not found!");
    }

    @Override
    public Object getObject(String name) throws JAMSEntity.NoSuchAttributeException {
        if (this.values.containsKey(name)) {
            return this.values.get(name);
        }
        throw new JAMSEntity.NoSuchAttributeException("Attribute " + name + " (Object) not found!");
    }

    @Override
    public Geometry getGeometry(String name) throws JAMSEntity.NoSuchAttributeException {
        if (this.values.containsKey(name)) {
            return ((JAMSGeometry)this.values.get(name)).getValue();
        }
        throw new JAMSEntity.NoSuchAttributeException("Attribute " + name + " (Geometry) not found!");
    }

    @Override
    public boolean existsAttribute(String name) {
        return this.values.containsKey(name);
    }

    @Override
    public Object[] getKeys() {
        return this.values.keySet().toArray(new Object[this.values.size()]);
    }

    @Override
    public void setValue(String value) {
        StringTokenizer st1 = new StringTokenizer(value, "\t");
        while (st1.hasMoreTokens()) {
            StringTokenizer st2 = new StringTokenizer(st1.nextToken(), "=");
            String name = st2.nextToken().trim();
            String val = st2.nextToken().trim();
            try {
                JAMSDouble d = new JAMSDouble(Double.parseDouble(val));
                this.values.put(name, d);
            }
            catch (NumberFormatException nfe) {
                System.out.println("\"" + val + "\" is not a valid double expression!");
                nfe.printStackTrace();
            }
        }
    }

    @Override
    public void setValue(HashMap<String, Object> values) {
        this.values = values;
    }

    @Override
    public HashMap<String, Object> getValue() {
        return this.values;
    }

    public String getStringValue() {
        String result = "";
        Object[] names = this.values.keySet().toArray();
        if (names.length > 0) {
            result = result + names[0] + "=" + this.values.get(names[0]) + "f";
        }
        for (int i = 1; i < names.length; ++i) {
            result = result + "\t" + names[i] + "=" + this.values.get(names[i]) + "f";
        }
        return result;
    }
}

