/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.dataaccess;

import org.unijena.jams.data.JAMSData;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSIntegerArray;
import org.unijena.jams.dataaccess.JAMSEntityDataAccessor;

public class IntegerArrayAccessor
implements JAMSEntityDataAccessor {
    JAMSIntegerArray componentObject;
    JAMSIntegerArray[] entityObject;
    int index;
    int accessType;

    public IntegerArrayAccessor(JAMSEntity[] entities, JAMSData dataObject, String attributeName, int accessType) throws JAMSEntity.NoSuchAttributeException {
        this.entityObject = new JAMSIntegerArray[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            if (entities[i].existsAttribute(attributeName)) {
                try {
                    this.entityObject[i] = (JAMSIntegerArray)entities[i].getObject(attributeName);
                }
                catch (JAMSEntity.NoSuchAttributeException nsae) {}
                continue;
            }
            if (accessType != 0) {
                this.entityObject[i] = new JAMSIntegerArray();
                entities[i].setObject(attributeName, this.entityObject[i]);
                continue;
            }
            throw new JAMSEntity.NoSuchAttributeException("Attribute " + attributeName + " does not exist!");
        }
        this.accessType = accessType;
        this.componentObject = (JAMSIntegerArray)dataObject;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void read() {
        this.componentObject.setValue(this.entityObject[this.index].getValue());
    }

    @Override
    public void write() {
        this.entityObject[this.index].setValue(this.componentObject.getValue());
    }

    @Override
    public int getAccessType() {
        return this.accessType;
    }
}

