/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.model;

import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSComponentEnumerator;
import org.unijena.jams.model.JAMSContext;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="JAMS conditional context", author="Sven Kralisch", date="7. January 2008", description="This component represents a JAMS context which can be used to conditionally execute components. This context must contain two components. If \"condition\" is true, the first one will be executed, else the second one.\nAn application example can be downloaded <a href=''>here</a>")
public class JAMSConditionalContext
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Time interval of temporal context")
    public JAMSBoolean condition;

    @Override
    public void run() {
        super.run();
    }

    @Override
    public JAMSComponentEnumerator getRunEnumerator() {
        return new RunEnumerator();
    }

    @Override
    public JAMSComponentEnumerator getChildrenEnumerator() {
        return new RunEnumerator();
    }

    @Override
    public long getNumberOfIterations() {
        return 1L;
    }

    class RunEnumerator
    implements JAMSComponentEnumerator {
        JAMSComponent[] compArray;
        boolean next;

        RunEnumerator() {
            this.compArray = JAMSConditionalContext.this.getCompArray();
            this.next = true;
        }

        @Override
        public boolean hasNext() {
            if (this.next) {
                this.next = false;
                return true;
            }
            return false;
        }

        @Override
        public JAMSComponent next() {
            if (JAMSConditionalContext.this.condition.getValue()) {
                return this.compArray[0];
            }
            return this.compArray[1];
        }

        @Override
        public void reset() {
            this.next = true;
        }
    }
}

