/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.gui.input;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.unijena.jams.JAMSFileFilter;
import org.unijena.jams.gui.LHelper;

public class ListInput
extends JPanel {
    static final int BUTTON_SIZE = 21;
    public static final int FILE_LIST = 0;
    public static final int STRING_LIST = 1;
    private JList listbox;
    private JButton addButton;
    private JButton removeButton;
    private JScrollPane scrollPane;
    private JFileChooser jfc;
    private int type = 0;
    private ListData listData = new ListData();

    public ListInput(int type) {
        this();
        this.type = type;
    }

    public ListInput() {
        this.jfc = new JFileChooser();
        this.jfc.setFileSelectionMode(2);
        BorderLayout layout = new BorderLayout();
        layout.setHgap(5);
        this.setLayout(layout);
        this.listbox = new JList<String>(this.listData.getValue());
        this.getListbox().setSelectionMode(0);
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().add(this.getListbox());
        this.add((Component)this.scrollPane, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setPreferredSize(new Dimension(21, 21));
        buttonPanel.setLayout(new FlowLayout());
        this.add((Component)buttonPanel, "East");
        this.addButton = new JButton("+");
        this.addButton.setMargin(new Insets(0, 1, 1, 0));
        this.addButton.setPreferredSize(new Dimension(21, 21));
        buttonPanel.add(this.addButton);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String stringValue = null;
                if (ListInput.this.type == 0) {
                    int result;
                    Object o = ListInput.this.getListbox().getSelectedValue();
                    if (o != null) {
                        File file = new File((String)o);
                        ListInput.this.jfc.setSelectedFile(file);
                        ListInput.this.jfc.setFileFilter(JAMSFileFilter.getJarFilter());
                    }
                    if ((result = ListInput.this.jfc.showOpenDialog(ListInput.this)) == 0) {
                        stringValue = ListInput.this.jfc.getSelectedFile().getAbsolutePath();
                    }
                } else {
                    stringValue = LHelper.showInputDlg(ListInput.this, null, null);
                }
                if (stringValue != null && !ListInput.this.listData.getValue().contains(stringValue)) {
                    ListInput.this.listData.addElement(stringValue);
                    ListInput.this.scrollPane.revalidate();
                    ListInput.this.scrollPane.repaint();
                }
            }
        });
        this.removeButton = new JButton("-");
        this.removeButton.setMargin(new Insets(0, 1, 1, 0));
        this.removeButton.setPreferredSize(new Dimension(21, 21));
        buttonPanel.add(this.removeButton);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selection = ListInput.this.getListbox().getSelectedIndex();
                if (selection >= 0) {
                    ListInput.this.listData.removeElementAt(selection);
                    ListInput.this.scrollPane.revalidate();
                    ListInput.this.scrollPane.repaint();
                    if (selection >= ListInput.this.listData.getValue().size()) {
                        selection = ListInput.this.listData.getValue().size() - 1;
                    }
                    ListInput.this.getListbox().setSelectedIndex(selection);
                }
            }
        });
    }

    public void addListDataObserver(Observer obs) {
        this.listData.addObserver(obs);
    }

    public void setListData(Vector<String> listData) {
        this.listData.setValue(listData);
        this.scrollPane.revalidate();
        this.scrollPane.repaint();
    }

    public Vector<String> getListData() {
        return this.listData.getValue();
    }

    public String getSelectedString() {
        int selection = this.getListbox().getSelectedIndex();
        if (selection >= 0) {
            return this.listData.getValue().elementAt(selection);
        }
        return null;
    }

    public JList getListbox() {
        return this.listbox;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getListbox().setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
    }

    private class ListData
    extends Observable {
        private Vector<String> listData = new Vector();

        private ListData() {
        }

        public void addElement(String s) {
            this.listData.addElement(s);
            ListInput.this.getListbox().setListData(this.listData);
            ListInput.this.getListbox().setSelectedValue(s, true);
            this.setChanged();
            this.notifyObservers();
        }

        public void removeElementAt(int selection) {
            this.listData.removeElementAt(selection);
            ListInput.this.getListbox().setListData(this.listData);
            this.setChanged();
            this.notifyObservers();
        }

        public Vector<String> getValue() {
            return this.listData;
        }

        public void setValue(Vector<String> listData) {
            this.listData = listData;
            ListInput.this.getListbox().setListData(listData);
            this.setChanged();
            this.notifyObservers();
        }
    }
}

