/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams;

import org.unijena.jams.CmdLineParser;

public class JAMSCmdLine {
    private String configFileName = null;
    private String modelFileName = null;
    private String parameterValues = null;
    private String[] otherArgs = null;
    private String appTitle;
    public static final String USAGE_STRING = "[Options]\nOptions:\n  -h, --help                                         Print help\n  -c, --config <config file name>                    Provide config file name\n  -m, --model <model configuration file name>        Provide model file name\n  -p, --parametervalue <list of parameter values>    Provide initial parameter values divided by semicolons";

    public JAMSCmdLine(String[] args) {
        this(args, "JAMS");
    }

    public JAMSCmdLine(String[] args, String appTitle) {
        this.appTitle = appTitle;
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option configOption = parser.addStringOption('c', "config");
        CmdLineParser.Option modelOption = parser.addStringOption('m', "model");
        CmdLineParser.Option pValueOption = parser.addStringOption('p', "parametervalue");
        CmdLineParser.Option helpOption = parser.addBooleanOption('h', "help");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            System.err.println(USAGE_STRING);
            System.exit(2);
        }
        boolean usage = (Boolean)parser.getOptionValue(helpOption, Boolean.FALSE);
        if (usage) {
            System.out.println("Usage: " + appTitle + " " + USAGE_STRING);
            System.exit(0);
        }
        this.configFileName = (String)parser.getOptionValue(configOption, null);
        this.modelFileName = (String)parser.getOptionValue(modelOption, null);
        this.parameterValues = (String)parser.getOptionValue(pValueOption, null);
        this.otherArgs = parser.getRemainingArgs();
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public String getModelFileName() {
        return this.modelFileName;
    }

    public String[] getOtherArgs() {
        return this.otherArgs;
    }

    public String getParameterValues() {
        return this.parameterValues;
    }
}

