/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.model;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSBooleanArray;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSData;
import org.unijena.jams.data.JAMSDataFactory;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSEntityEnumerator;
import org.unijena.jams.data.JAMSFloat;
import org.unijena.jams.data.JAMSFloatArray;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSIntegerArray;
import org.unijena.jams.data.JAMSLong;
import org.unijena.jams.data.JAMSLongArray;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.data.JAMSStringArray;
import org.unijena.jams.dataaccess.BooleanAccessor;
import org.unijena.jams.dataaccess.BooleanArrayAccessor;
import org.unijena.jams.dataaccess.CalendarAccessor;
import org.unijena.jams.dataaccess.DoubleAccessor;
import org.unijena.jams.dataaccess.DoubleArrayAccessor;
import org.unijena.jams.dataaccess.EntityAccessor;
import org.unijena.jams.dataaccess.EntityCollectionAccessor;
import org.unijena.jams.dataaccess.FloatAccessor;
import org.unijena.jams.dataaccess.FloatArrayAccessor;
import org.unijena.jams.dataaccess.IntegerAccessor;
import org.unijena.jams.dataaccess.IntegerArrayAccessor;
import org.unijena.jams.dataaccess.JAMSEntityDataAccessor;
import org.unijena.jams.dataaccess.LongArrayAccessor;
import org.unijena.jams.dataaccess.StringAccessor;
import org.unijena.jams.dataaccess.StringArrayAccessor;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSComponentEnumerator;
import org.unijena.jams.model.JAMSModel;
import org.unijena.jams.runtime.JAMSRuntime;

@JAMSComponentDescription(title="JAMS Component", author="Sven Kralisch", date="27. Juni 2005", description="This component represents a JAMS context which is the top level component of every component hierarchie in JAMS")
public class JAMSContext
extends JAMSComponent {
    protected JAMSEntityCollection entities;
    protected JAMSEntity currentEntity;
    protected ArrayList<JAMSComponent> components = new ArrayList();
    protected JAMSComponentEnumerator runEnumerator = null;
    protected JAMSComponentEnumerator initCleanupEnumerator = null;
    protected ArrayList<AccessSpec> accessSpecs = new ArrayList();
    protected ArrayList<AttributeSpec> attributeSpecs = new ArrayList();
    protected JAMSEntityDataAccessor[] dataAccessors = new JAMSEntityDataAccessor[0];
    protected ArrayList<JAMSEntityDataAccessor> daList = new ArrayList();
    protected HashMap<String, JAMSData> attribs = new HashMap();
    protected boolean doRun = true;

    public JAMSContext() {
        this.setCurrentEntity(JAMSDataFactory.createEntity());
        ArrayList<JAMSEntity> list = new ArrayList<JAMSEntity>();
        list.add(this.getCurrentEntity());
        this.setEntities(new JAMSEntityCollection());
        this.getEntities().setEntities(list);
        this.attribs = new HashMap();
    }

    public void exchange(int i, int j) {
        JAMSComponent oi = this.components.get(i);
        JAMSComponent oj = this.components.get(j);
        this.components.set(i, oj);
        this.components.set(j, oi);
    }

    public void addComponent(JAMSComponent c) {
        this.components.add(c);
    }

    public void removeComponent(int index) {
        this.components.remove(index);
    }

    public ArrayList getComponents() {
        return this.components;
    }

    public void setComponents(ArrayList<JAMSComponent> components) {
        this.components = components;
        Iterator<JAMSComponent> i = components.iterator();
        while (i.hasNext()) {
            i.next().setContext(this);
        }
    }

    public JAMSComponentEnumerator getRunEnumerator() {
        return new RunEnumerator();
    }

    public JAMSComponentEnumerator getChildrenEnumerator() {
        return new ChildrenEnumerator();
    }

    public JAMSComponent[] getCompArray() {
        JAMSComponent[] comps = new JAMSComponent[this.components.size()];
        this.components.toArray(comps);
        return comps;
    }

    public void addAccess(JAMSComponent user, String varName, String attributeName, int accessType) {
        this.accessSpecs.add(new AccessSpec(user, varName, attributeName, accessType));
    }

    public void addAttribute(String attributeName, String clazz, String value) {
        this.attributeSpecs.add(new AttributeSpec(attributeName, clazz, value));
    }

    @Override
    public void setModel(JAMSModel model) {
        super.setModel(model);
        JAMSRuntime rt = this.getModel().getRuntime();
        rt.addRunStateObserver(new Observer(){

            @Override
            public void update(Observable obs, Object obj) {
                if (JAMSContext.this.getModel().getRuntime().getRunState() != 1) {
                    JAMSContext.this.doRun = false;
                }
            }
        });
    }

    @Override
    public void init() {
        this.attribs = new HashMap();
        this.daList = new ArrayList();
        this.runEnumerator = null;
        if (!this.doRun) {
            return;
        }
        JAMSEntity[] entityArray = this.getEntities().getEntityArray();
        for (AttributeSpec attributeSpec : this.attributeSpecs) {
            try {
                JAMSData data = JAMSDataFactory.getData(attributeSpec.className);
                data.setValue(attributeSpec.value);
                this.attribs.put(attributeSpec.attributeName, data);
                String id = this.getInstanceName() + "." + attributeSpec.attributeName;
                this.getModel().getRuntime().getDataHandles().put(id, data);
                for (JAMSEntity entity : entityArray) {
                    entity.setObject(attributeSpec.attributeName, data);
                }
            }
            catch (ClassNotFoundException cnfe) {
                this.getModel().getRuntime().handle((Exception)cnfe, false);
            }
            catch (InstantiationException ie) {
                this.getModel().getRuntime().handle((Exception)ie, false);
            }
            catch (IllegalAccessException iae) {
                this.getModel().getRuntime().handle((Exception)iae, false);
            }
        }
        for (AccessSpec accessSpec : this.accessSpecs) {
            try {
                Class<?> clazz = accessSpec.component.getClass().getDeclaredField(accessSpec.varName).getType();
                if (clazz.isArray()) {
                    String className = clazz.getCanonicalName();
                    className = className.substring(0, className.length() - 2);
                    StringTokenizer tok = new StringTokenizer(accessSpec.attributeName, ";");
                    int count = tok.countTokens();
                    Class<?> componentClass = Class.forName(className);
                    JAMSData[] array = (JAMSData[])Array.newInstance(componentClass, count);
                    for (int i = 0; i < count; ++i) {
                        array[i] = this.getDataObject(entityArray, componentClass, tok.nextToken(), accessSpec.accessType, null);
                    }
                    accessSpec.component.getClass().getDeclaredField(accessSpec.varName).set(accessSpec.component, array);
                    continue;
                }
                JAMSData componentObject = null;
                JAMSData dataObject = this.getDataObject(entityArray, clazz, accessSpec.attributeName, accessSpec.accessType, componentObject);
                accessSpec.component.getClass().getDeclaredField(accessSpec.varName).set(accessSpec.component, dataObject);
            }
            catch (Exception e) {
                this.getModel().getRuntime().sendErrorMsg("Error occured in " + accessSpec.component.getInstanceName() + ": " + accessSpec.varName);
                this.getModel().getRuntime().handle(e, false);
            }
        }
        if (this.daList.size() > 0) {
            this.dataAccessors = this.daList.toArray(new JAMSEntityDataAccessor[this.daList.size()]);
        }
        if (this.initCleanupEnumerator == null) {
            this.initCleanupEnumerator = this.getChildrenEnumerator();
        }
        this.initCleanupEnumerator.reset();
        while (this.initCleanupEnumerator.hasNext() && this.doRun) {
            JAMSComponent comp = this.initCleanupEnumerator.next();
            try {
                comp.init();
            }
            catch (Exception e) {
                this.getModel().getRuntime().handle(e, comp.getInstanceName());
            }
        }
        this.initEntityData();
    }

    protected JAMSData getDataObject(JAMSEntity[] ea, Class clazz, String attributeName, int accessType, JAMSData componentObject) throws InstantiationException, IllegalAccessException, ClassNotFoundException, JAMSEntity.NoSuchAttributeException {
        JAMSEntityDataAccessor da = null;
        JAMSData dataObject = this.attribs.get(attributeName);
        if (dataObject == null) {
            dataObject = componentObject != null ? componentObject : (clazz.getName().equals("org.unijena.jams.data.JAMSEntity") ? JAMSDataFactory.createEntity() : (JAMSData)clazz.newInstance());
            this.attribs.put(attributeName, dataObject);
            if (clazz.equals(JAMSDouble.class)) {
                da = new DoubleAccessor(ea, dataObject, attributeName, accessType);
            } else if (clazz.equals(JAMSDoubleArray.class)) {
                da = new DoubleArrayAccessor(ea, dataObject, attributeName, accessType);
            } else if (clazz.equals(JAMSLong.class)) {
                da = new CalendarAccessor(ea, dataObject, attributeName, accessType);
            } else if (clazz.equals(JAMSLongArray.class)) {
                da = new LongArrayAccessor(ea, dataObject, attributeName, accessType);
            } else if (clazz.equals(JAMSString.class)) {
                da = new StringAccessor(ea, dataObject, attributeName, accessType);
            } else if (clazz.equals(JAMSStringArray.class)) {
                da = new StringArrayAccessor(ea, dataObject, attributeName, accessType);
            } else if (clazz.equals(JAMSBoolean.class)) {
                da = new BooleanAccessor(ea, dataObject, attributeName, accessType);
            } else if (clazz.equals(JAMSBooleanArray.class)) {
                da = new BooleanArrayAccessor(ea, dataObject, attributeName, accessType);
            } else if (clazz.equals(JAMSFloat.class)) {
                da = new FloatAccessor(ea, dataObject, attributeName, accessType);
            } else if (clazz.equals(JAMSFloatArray.class)) {
                da = new FloatArrayAccessor(ea, dataObject, attributeName, accessType);
            } else if (clazz.equals(JAMSInteger.class)) {
                da = new IntegerAccessor(ea, dataObject, attributeName, accessType);
            } else if (clazz.equals(JAMSIntegerArray.class)) {
                da = new IntegerArrayAccessor(ea, dataObject, attributeName, accessType);
            } else if (clazz.equals(JAMSEntity.class)) {
                da = new EntityAccessor(ea, dataObject, attributeName, accessType);
            } else if (clazz.equals(JAMSEntityCollection.class)) {
                da = new EntityCollectionAccessor(ea, dataObject, attributeName, accessType);
            } else if (clazz.equals(JAMSCalendar.class)) {
                da = new CalendarAccessor(ea, dataObject, attributeName, accessType);
            } else {
                this.getModel().getRuntime().sendHalt("Class " + clazz.getCanonicalName() + " not supported!");
            }
            this.daList.add(da);
        }
        return dataObject;
    }

    protected void initEntityData() {
        for (int i = 0; i < this.dataAccessors.length; ++i) {
            if (this.dataAccessors[i].getAccessType() != 1) continue;
            for (int j = 0; j < this.getEntities().getEntities().size(); ++j) {
                this.dataAccessors[i].setIndex(j);
                this.dataAccessors[i].write();
            }
        }
    }

    @Override
    public void run() {
        if (this.runEnumerator == null) {
            this.runEnumerator = this.getRunEnumerator();
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            JAMSComponent comp = this.runEnumerator.next();
            try {
                comp.run();
            }
            catch (Exception e) {
                this.getModel().getRuntime().handle(e, comp.getInstanceName());
            }
        }
        this.updateEntityData();
    }

    @Override
    public void cleanup() {
        if (this.initCleanupEnumerator == null) {
            this.initCleanupEnumerator = this.getChildrenEnumerator();
        }
        this.initCleanupEnumerator.reset();
        while (this.initCleanupEnumerator.hasNext()) {
            JAMSComponent comp = this.initCleanupEnumerator.next();
            try {
                comp.cleanup();
            }
            catch (Exception e) {
                this.getModel().getRuntime().handle(e, comp.getInstanceName());
            }
        }
        ArrayList<JAMSEntity> list = new ArrayList<JAMSEntity>();
        list.add(JAMSDataFactory.createEntity());
    }

    protected void updateEntityData() {
        for (int i = 0; i < this.dataAccessors.length; ++i) {
            this.dataAccessors[i].write();
        }
    }

    private void updateDataAccessors(int index) {
        for (int i = 0; i < this.dataAccessors.length; ++i) {
            this.dataAccessors[i].setIndex(index);
            this.dataAccessors[i].read();
        }
    }

    public long getNumberOfIterations() {
        return this.getEntities().getEntities().size();
    }

    public JAMSEntityCollection getEntities() {
        return this.entities;
    }

    public void setEntities(JAMSEntityCollection entities) {
        this.entities = entities;
    }

    public JAMSEntity getCurrentEntity() {
        return this.currentEntity;
    }

    public void setCurrentEntity(JAMSEntity currentEntity) {
        this.currentEntity = currentEntity;
    }

    protected class AccessSpec {
        JAMSComponent component;
        String varName;
        String attributeName;
        int accessType;

        public AccessSpec(JAMSComponent component, String varName, String attributeName, int accessType) {
            this.component = component;
            this.varName = varName;
            this.attributeName = attributeName;
            this.accessType = accessType;
        }
    }

    protected class AttributeSpec {
        String attributeName;
        String className;
        String value;

        public AttributeSpec(String attributeName, String className, String value) {
            this.attributeName = attributeName;
            this.className = className;
            this.value = value;
        }
    }

    class RunEnumerator
    implements JAMSComponentEnumerator {
        JAMSComponentEnumerator ce;
        JAMSEntityEnumerator ee;
        int index;

        RunEnumerator() {
            this.ce = JAMSContext.this.getChildrenEnumerator();
            this.ee = JAMSContext.this.getEntities().getEntityEnumerator();
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            boolean nextComp = this.ce.hasNext();
            boolean nextEntity = this.ee.hasNext();
            return nextEntity || nextComp;
        }

        @Override
        public JAMSComponent next() {
            if (!this.ce.hasNext() && this.ee.hasNext()) {
                JAMSContext.this.updateEntityData();
                JAMSContext.this.setCurrentEntity(this.ee.next());
                ++this.index;
                JAMSContext.this.updateDataAccessors(this.index);
                this.ce.reset();
            }
            return this.ce.next();
        }

        @Override
        public void reset() {
            this.ee.reset();
            JAMSContext.this.setCurrentEntity(JAMSContext.this.getEntities().getCurrent());
            this.ce.reset();
            this.index = 0;
            JAMSContext.this.updateDataAccessors(this.index);
        }
    }

    class ChildrenEnumerator
    implements JAMSComponentEnumerator {
        JAMSComponent[] compArray;
        int index;

        ChildrenEnumerator() {
            this.compArray = JAMSContext.this.getCompArray();
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.compArray.length;
        }

        @Override
        public JAMSComponent next() {
            return this.compArray[this.index++];
        }

        @Override
        public void reset() {
            this.index = 0;
        }
    }
}

