/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.spatialschema.geometry;

import java.util.Set;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.Boundary;
import org.opengis.spatialschema.geometry.DirectPosition;
import org.opengis.spatialschema.geometry.Envelope;
import org.opengis.spatialschema.geometry.TransfiniteSet;
import org.opengis.spatialschema.geometry.complex.Complex;

public interface Geometry
extends TransfiniteSet {
    public CoordinateReferenceSystem getCoordinateReferenceSystem();

    public Geometry getMbRegion();

    public DirectPosition getRepresentativePoint();

    public Boundary getBoundary();

    public Complex getClosure();

    public boolean isSimple();

    public boolean isCycle();

    public double getDistance(Geometry var1);

    public int getDimension(DirectPosition var1);

    public int getCoordinateDimension();

    public Set getMaximalComplex();

    public Geometry transform(CoordinateReferenceSystem var1) throws TransformException;

    public Geometry transform(CoordinateReferenceSystem var1, MathTransform var2) throws TransformException;

    public Envelope getEnvelope();

    public DirectPosition getCentroid();

    public Geometry getConvexHull();

    public Geometry getBuffer(double var1);

    public boolean isMutable();

    public Geometry toImmutable();

    public Object clone() throws CloneNotSupportedException;
}

