/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.event.AbstractGTRoot;
import org.geotools.event.GTComponent;
import org.geotools.event.GTDelta;
import org.geotools.event.GTDeltaImpl;
import org.geotools.event.GTEvent;
import org.geotools.event.GTEventImpl;
import org.geotools.event.GTNoteImpl;
import org.geotools.resources.Utilities;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.StyledLayerImpl;
import org.geotools.styling.UserLayer;

public class StyledLayerDescriptorImpl
extends AbstractGTRoot
implements StyledLayerDescriptor {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.styling");
    private String name;
    private String title;
    private String abstractStr;
    private List layers = new ArrayList();

    public Style getDefaultStyle() {
        for (int i = 0; i < this.layers.size(); ++i) {
            StyledLayer layer = (StyledLayer)this.layers.get(i);
            if (!(layer instanceof UserLayer)) continue;
            UserLayer userLayer = (UserLayer)layer;
            Style[] styles = userLayer.getUserStyles();
            for (int j = 0; j < styles.length; ++j) {
                if (!styles[j].isDefault()) continue;
                return styles[j];
            }
        }
        return null;
    }

    public StyledLayer[] getStyledLayers() {
        return this.layers.toArray(new StyledLayerImpl[this.layers.size()]);
    }

    public void setStyledLayers(StyledLayer[] layers) {
        this.layers.clear();
        for (int i = 0; i < layers.length; ++i) {
            this.addStyledLayer(layers[i]);
        }
        LOGGER.fine("StyleLayerDescriptorImpl added " + this.layers.size() + " styled layers");
        this.fireChanged();
    }

    public void addStyledLayer(StyledLayer layer) {
        layer.getNote().setParent((GTComponent)this);
        this.layers.add(layer);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.fireChanged();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.fireChanged();
    }

    public String getAbstract() {
        return this.abstractStr;
    }

    public void setAbstract(String abstractStr) {
        this.abstractStr = abstractStr;
        this.fireChanged();
    }

    public void removed(GTDelta childDelta) {
        if (!this.hasListeners()) {
            return;
        }
        GTDeltaImpl delta = new GTDeltaImpl(new GTNoteImpl("", -1), GTDelta.Kind.NO_CHANGE, this, childDelta);
        GTEventImpl event = new GTEventImpl(this, GTEvent.Type.PRE_DELETE, delta);
        this.fire(event);
    }

    public void changed(GTDelta delta) {
        if (!this.hasListeners()) {
            return;
        }
        this.fire(new GTDeltaImpl(new GTNoteImpl("", -1), GTDelta.Kind.NO_CHANGE, this, delta));
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((StyledLayerDescriptor)this);
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof StyledLayerDescriptorImpl) {
            StyledLayerDescriptorImpl other = (StyledLayerDescriptorImpl)oth;
            return Utilities.equals((Object)this.abstractStr, (Object)other.abstractStr) && Utilities.equals((Object)this.layers, (Object)other.layers) && Utilities.equals((Object)this.name, (Object)other.name) && Utilities.equals((Object)this.title, (Object)other.title);
        }
        return false;
    }
}

