/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import org.geotools.event.AbstractGTComponent;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ChannelSelectionImpl;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapImpl;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.ContrastEnhancementImpl;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.ShadedReliefImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbolizer;

public class RasterSymbolizerImpl
extends AbstractGTComponent
implements RasterSymbolizer {
    private FilterFactory filterFactory = FilterFactoryFinder.createFilterFactory();
    private ChannelSelection channelSelection = new ChannelSelectionImpl();
    private ColorMap colorMap = new ColorMapImpl();
    private ContrastEnhancement contrastEnhancement = new ContrastEnhancementImpl();
    private ShadedRelief shadedRelief = new ShadedReliefImpl();
    private String geometryName = "raster";
    private Symbolizer symbolizer;
    private Expression opacity = this.filterFactory.createLiteralExpression(1.0);
    private Expression overlap = this.filterFactory.createLiteralExpression("Random");

    public int hashcode() {
        int key = 0;
        key = this.channelSelection.hashCode();
        key = key * 13 + this.colorMap.hashCode();
        key = key * 13 + this.contrastEnhancement.hashCode();
        key = key * 13 + this.shadedRelief.hashCode();
        key = key * 13 + this.opacity.hashCode();
        key = key * 13 + this.overlap.hashCode();
        key = key * 13 + this.geometryName.hashCode();
        return key;
    }

    public ChannelSelection getChannelSelection() {
        return this.channelSelection;
    }

    public ColorMap getColorMap() {
        return this.colorMap;
    }

    public ContrastEnhancement getContrastEnhancement() {
        return this.contrastEnhancement;
    }

    public String getGeometryPropertyName() {
        return this.geometryName;
    }

    public Symbolizer getImageOutline() {
        return this.symbolizer;
    }

    public Expression getOpacity() {
        return this.opacity;
    }

    public Expression getOverlap() {
        return this.overlap;
    }

    public ShadedRelief getShadedRelief() {
        return this.shadedRelief;
    }

    public void setChannelSelection(ChannelSelection channel) {
        if (this.channelSelection == channel) {
            return;
        }
        ChannelSelection old = this.channelSelection;
        this.channelSelection = channel;
        this.fireChildChanged("channelSelection", channel, old);
    }

    public void setColorMap(ColorMap colorMap) {
        if (this.colorMap == colorMap) {
            return;
        }
        ColorMap old = colorMap;
        this.colorMap = colorMap;
        this.fireChildChanged("colorMap", colorMap, old);
    }

    public void setContrastEnhancement(ContrastEnhancement contrastEnhancement) {
        if (this.contrastEnhancement == contrastEnhancement) {
            return;
        }
        ContrastEnhancement old = this.contrastEnhancement;
        this.contrastEnhancement = contrastEnhancement;
        this.fireChildChanged("contrastEnhancement", contrastEnhancement, old);
    }

    public void setGeometryPropertyName(String geometryName) {
        if (this.geometryName == geometryName) {
            return;
        }
        String old = this.geometryName;
        this.geometryName = geometryName;
        this.fireChildChanged("geometryName", geometryName, old);
    }

    public void setImageOutline(Symbolizer symbolizer) {
        if (symbolizer instanceof LineSymbolizer || symbolizer instanceof PolygonSymbolizer) {
            if (this.symbolizer == symbolizer) {
                return;
            }
        } else {
            throw new IllegalArgumentException("Only a line or polygon symbolizer may be used to outline a raster");
        }
        Symbolizer old = this.symbolizer;
        this.symbolizer = symbolizer;
        this.fireChildChanged("symbolizer", symbolizer, old);
    }

    public void setOpacity(Expression opacity) {
        if (this.opacity == opacity) {
            return;
        }
        Expression old = this.opacity;
        this.opacity = opacity;
        this.fireChildChanged("opacity", opacity, old);
    }

    public void setOverlap(Expression overlap) {
        if (this.overlap == overlap) {
            return;
        }
        Expression old = this.overlap;
        this.overlap = overlap;
        this.fireChildChanged("overlap", overlap, old);
    }

    public void setShadedRelief(ShadedRelief shadedRelief) {
        if (this.shadedRelief == shadedRelief) {
            return;
        }
        ShadedRelief old = this.shadedRelief;
        this.shadedRelief = shadedRelief;
        this.fireChildChanged("shadedRelief", shadedRelief, old);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((RasterSymbolizer)this);
    }

    public Object clone() {
        Object clone;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clone;
    }
}

